/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.session.component;

import com.github.copilot.CopilotIcons;
import com.github.copilot.chat.session.ChatSession;
import com.github.copilot.chat.session.ChatSessionController;
import com.github.copilot.chat.session.SessionManager;
import com.github.copilot.chat.session.component.ChatSessionOption;
import com.github.copilot.chat.session.component.context.menu.DeleteConversationOption;
import com.github.copilot.chat.session.component.context.menu.RenameConversationOption;
import com.github.copilot.chat.session.listener.ChatSessionLoadRequestListener;
import com.github.copilot.chat.utils.TimeUtilKt;
import com.github.copilot.style.Style;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u000eJ\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\"\u0010\u001c\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bH\u0016J\"\u0010!\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bH\u0016J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u000e2\b\u0010#\u001a\u0004\u0018\u00010\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/github/copilot/chat/session/component/AllConversationComponent;", "Ljavax/swing/JPanel;", "Ljavax/swing/Scrollable;", "sessionController", "Lcom/github/copilot/chat/session/ChatSessionController;", "<init>", "(Lcom/github/copilot/chat/session/ChatSessionController;)V", "currentGridY", "", "currentlyFocusedIndex", "optionList", "", "Lcom/github/copilot/chat/session/component/ChatSessionOption;", "navigateUp", "", "navigateDown", "selectCurrent", "scrollToVisible", "component", "Ljava/awt/Component;", "remove", "chatSession", "Lcom/github/copilot/chat/session/ChatSession;", "getPreferredScrollableViewportSize", "Ljava/awt/Dimension;", "getScrollableTracksViewportWidth", "", "getScrollableTracksViewportHeight", "getScrollableUnitIncrement", "visibleRect", "Ljava/awt/Rectangle;", "orientation", "direction", "getScrollableBlockIncrement", "add", "comp", "core"})
@SourceDebugExtension(value={"SMAP\nViewAllConversationComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewAllConversationComponent.kt\ncom/github/copilot/chat/session/component/AllConversationComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,193:1\n1054#2:194\n1855#2,2:195\n1282#3,2:197\n*S KotlinDebug\n*F\n+ 1 ViewAllConversationComponent.kt\ncom/github/copilot/chat/session/component/AllConversationComponent\n*L\n79#1:194\n79#1:195,2\n148#1:197,2\n*E\n"})
public final class AllConversationComponent
extends JPanel
implements Scrollable {
    @NotNull
    private final ChatSessionController sessionController;
    private int currentGridY;
    private int currentlyFocusedIndex;
    @NotNull
    private final List<ChatSessionOption> optionList;

    /*
     * WARNING - void declaration
     */
    public AllConversationComponent(@NotNull ChatSessionController sessionController) {
        Intrinsics.checkNotNullParameter((Object)sessionController, (String)"sessionController");
        this.sessionController = sessionController;
        this.optionList = new ArrayList();
        this.setLayout(new GridBagLayout());
        Iterable $this$sortedByDescending$iv = SessionManager.DefaultImpls.getChatSessions$default(this.sessionController.getChatSessionManager(), null, 1, null);
        boolean $i$f$sortedByDescending = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ChatSession it = (ChatSession)b;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getModifiedAt();
                it = (ChatSession)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getModifiedAt()));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$lambda_u245_u24lambda_u244_u24lambda_u243;
            DeleteConversationOption deleteConversationOption;
            JPopupMenu jPopupMenu;
            ChatSession chatSession = (ChatSession)element$iv;
            boolean bl = false;
            Icon icon = CopilotIcons.Thread;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Thread");
            ChatSessionOption option = new ChatSessionOption(icon, chatSession.getName().getValue(), TimeUtilKt.timeAgo(chatSession.getModifiedAt()), null, () -> AllConversationComponent.lambda$5$lambda$1(this, chatSession), 8, null);
            JPopupMenu $this$lambda_u245_u24lambda_u244 = jPopupMenu = new JPopupMenu();
            boolean bl2 = false;
            $this$lambda_u245_u24lambda_u244.add(new RenameConversationOption(chatSession, option));
            DeleteConversationOption deleteConversationOption2 = deleteConversationOption = new DeleteConversationOption(this.sessionController.getChatSessionManager().getProject(), chatSession);
            JPopupMenu jPopupMenu2 = $this$lambda_u245_u24lambda_u244;
            boolean bl3 = false;
            $this$lambda_u245_u24lambda_u244_u24lambda_u243.getPostDialogActions().add((Function0<Unit>)((Function0)() -> AllConversationComponent.lambda$5$lambda$4$lambda$3$lambda$2(this, chatSession)));
            jPopupMenu2.add(deleteConversationOption);
            JPopupMenu contextMenu = jPopupMenu;
            option.setContextMenu(contextMenu);
            if (Intrinsics.areEqual((Object)this.sessionController.getSession().getId(), (Object)chatSession.getId())) {
                option.setSelected(true);
                option.setBackgroundColor(JBUI.CurrentTheme.List.Hover.background((boolean)true));
                this.currentlyFocusedIndex = this.optionList.size();
            }
            this.optionList.add(option);
            this.add(option);
        }
        this.setBorder(Style.Borders.INSTANCE.getAllConversationComponentBorder());
        if (!((Collection)this.optionList).isEmpty()) {
            this.optionList.get(this.currentlyFocusedIndex).applyKeyboardFocus();
        }
    }

    public final void navigateUp() {
        if (this.optionList.isEmpty()) {
            return;
        }
        this.optionList.get(this.currentlyFocusedIndex).removeKeyboardFocus();
        this.currentlyFocusedIndex = this.currentlyFocusedIndex == 0 ? this.optionList.size() - 1 : this.currentlyFocusedIndex - 1;
        this.optionList.get(this.currentlyFocusedIndex).applyKeyboardFocus();
        this.scrollToVisible(this.optionList.get(this.currentlyFocusedIndex));
    }

    public final void navigateDown() {
        if (this.optionList.isEmpty()) {
            return;
        }
        this.optionList.get(this.currentlyFocusedIndex).removeKeyboardFocus();
        this.currentlyFocusedIndex = this.currentlyFocusedIndex == this.optionList.size() - 1 ? 0 : this.currentlyFocusedIndex + 1;
        this.optionList.get(this.currentlyFocusedIndex).applyKeyboardFocus();
        this.scrollToVisible(this.optionList.get(this.currentlyFocusedIndex));
    }

    public final void selectCurrent() {
        if (!((Collection)this.optionList).isEmpty()) {
            this.optionList.get(this.currentlyFocusedIndex).getOnClick().invoke();
        }
    }

    private final void scrollToVisible(Component component2) {
        Rectangle bounds = component2.getBounds();
        boolean bl = false;
        this.scrollRectToVisible(bounds);
    }

    private final void remove(ChatSession chatSession) {
        block2: {
            Object object;
            block1: {
                Component[] componentArray = this.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                Object[] $this$firstOrNull$iv = componentArray;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Component it = (Component)element$iv;
                    boolean bl = false;
                    if (!(it instanceof ChatSessionOption && Intrinsics.areEqual((Object)((ChatSessionOption)it).getText(), (Object)chatSession.getName().getValue()))) continue;
                    object = element$iv;
                    break block1;
                }
                object = null;
            }
            Component component2 = (Component)object;
            if (component2 == null) break block2;
            Component it = component2;
            boolean bl = false;
            this.remove(it);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        return dimension;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(@Nullable Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public int getScrollableBlockIncrement(@Nullable Rectangle visibleRect, int orientation, int direction) {
        return 100;
    }

    @Override
    @NotNull
    public Component add(@NotNull Component component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = this.currentGridY;
        int n = this.currentGridY;
        this.currentGridY = n + 1;
        this.add(component2, c);
        return component2;
    }

    @Override
    public void remove(@Nullable Component comp) {
        try {
            super.remove(comp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final Unit lambda$5$lambda$1(AllConversationComponent this$0, ChatSession $chatSession) {
        ChatSessionLoadRequestListener.Companion.onSessionLoadRequest(this$0.sessionController.getChatSessionManager().getProject(), $chatSession);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$5$lambda$4$lambda$3$lambda$2(AllConversationComponent this$0, ChatSession $chatSession) {
        this$0.remove($chatSession);
        return Unit.INSTANCE;
    }
}

