/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.session.component;

import com.github.copilot.actions.PopupActionGroup;
import com.github.copilot.chat.agent.RemoteAgent;
import com.github.copilot.chat.agent.RemoteAgentService;
import com.github.copilot.chat.contentExclusion.ContentExclusionInfoPanel;
import com.github.copilot.chat.conversation.ConversationService;
import com.github.copilot.chat.conversation.agent.rpc.command.DeleteTurnCommand;
import com.github.copilot.chat.conversation.agent.rpc.message.Step;
import com.github.copilot.chat.conversation.agent.rpc.message.StepError;
import com.github.copilot.chat.followup.FollowUpComponent;
import com.github.copilot.chat.followup.FollowUpPanel;
import com.github.copilot.chat.input.CopilotChatInputPanel;
import com.github.copilot.chat.input.UserMessageListener;
import com.github.copilot.chat.message.ChatFollowUp;
import com.github.copilot.chat.message.ChatMessage;
import com.github.copilot.chat.message.ChatMessageKt;
import com.github.copilot.chat.message.ChatMessageType;
import com.github.copilot.chat.message.CopilotMessageComponent;
import com.github.copilot.chat.message.MessageComponent;
import com.github.copilot.chat.message.MessagePanelScrollWorker;
import com.github.copilot.chat.message.UserMessageComponent;
import com.github.copilot.chat.models.CopilotModelService;
import com.github.copilot.chat.panels.VerticalStackWrappingPanel;
import com.github.copilot.chat.session.ChatSessionController;
import com.github.copilot.chat.session.SessionController;
import com.github.copilot.chat.session.actions.DeleteAction;
import com.github.copilot.chat.session.actions.RenameAction;
import com.github.copilot.chat.session.component.ChatSessionToolBarComponent;
import com.github.copilot.chat.session.component.SecondaryTextLabel;
import com.github.copilot.chat.session.listener.DragAndDropFileListener;
import com.github.copilot.chat.session.listener.FocusMouseListener;
import com.github.copilot.chat.session.persistence.ChatSessionPersistenceService;
import com.github.copilot.chat.user.GitHubUser;
import com.github.copilot.chat.user.Users;
import com.github.copilot.chat.window.actions.ConversationHistoryAction;
import com.github.copilot.chat.window.actions.NewConversationAction;
import com.github.copilot.platform.utils.ProjectKt;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.github.copilot.style.Style;
import com.github.copilot.ui.animation.strategy.EaseOut;
import com.github.copilot.ui.dsl.AnimationDslKt;
import com.github.copilot.ui.manager.StickyScrollingManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.util.UiSizeUtilKt;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010*\u001a\u00020+H\u0016J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0003J\b\u0010/\u001a\u00020-H\u0002J\u0018\u00100\u001a\u00020-2\u0010\u00101\u001a\f\u0012\u0004\u0012\u00020302j\u0002`4J\u001a\u00105\u001a\u00020-2\u0006\u00106\u001a\u0002072\b\b\u0002\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020-2\u0006\u00106\u001a\u000207H\u0002J\u0010\u0010;\u001a\u00020-2\u0006\u00106\u001a\u000207H\u0002J\u0010\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u00106\u001a\u00020>H\u0002J\u0010\u0010A\u001a\u00020-2\u0006\u00106\u001a\u00020>H\u0002J\u0015\u0010B\u001a\u00020C2\u0006\u00106\u001a\u000207H\u0000\u00a2\u0006\u0002\bDJ\u0006\u0010E\u001a\u00020-R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0013\u0010&\u001a\u0004\u0018\u00010'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006F"}, d2={"Lcom/github/copilot/chat/session/component/ChatSessionComponent;", "Ljavax/swing/JPanel;", "controller", "Lcom/github/copilot/chat/session/ChatSessionController;", "remoteAgentService", "Lcom/github/copilot/chat/agent/RemoteAgentService;", "copilotModelService", "Lcom/github/copilot/chat/models/CopilotModelService;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "<init>", "(Lcom/github/copilot/chat/session/ChatSessionController;Lcom/github/copilot/chat/agent/RemoteAgentService;Lcom/github/copilot/chat/models/CopilotModelService;Lcom/github/copilot/platform/utils/observability/Logger;)V", "getController", "()Lcom/github/copilot/chat/session/ChatSessionController;", "messagePanel", "Lcom/github/copilot/chat/panels/VerticalStackWrappingPanel;", "getMessagePanel", "()Lcom/github/copilot/chat/panels/VerticalStackWrappingPanel;", "chatInputPanel", "Lcom/github/copilot/chat/input/CopilotChatInputPanel;", "getChatInputPanel", "()Lcom/github/copilot/chat/input/CopilotChatInputPanel;", "toolBarComponent", "Lcom/github/copilot/chat/session/component/ChatSessionToolBarComponent;", "getToolBarComponent", "()Lcom/github/copilot/chat/session/component/ChatSessionToolBarComponent;", "setToolBarComponent", "(Lcom/github/copilot/chat/session/component/ChatSessionToolBarComponent;)V", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "stickyScrollingManager", "Lcom/github/copilot/ui/manager/StickyScrollingManager;", "followUpPanel", "Lcom/github/copilot/chat/followup/FollowUpPanel;", "dragAndDropFileListener", "Lcom/github/copilot/chat/session/listener/DragAndDropFileListener;", "getDragAndDropFileListener", "()Lcom/github/copilot/chat/session/listener/DragAndDropFileListener;", "messagePanelScrollWorker", "Ljavax/swing/Timer;", "getMessagePanelScrollWorker", "()Ljavax/swing/Timer;", "getPreferredSize", "Ljava/awt/Dimension;", "replaceToolbarForController", "", "chatSessionController", "updateToolBar", "updateFollowUps", "followUps", "", "Lcom/github/copilot/chat/message/ChatFollowUp;", "Lcom/github/copilot/chat/message/ChatFollowUps;", "addWelcomeMessage", "message", "Lcom/github/copilot/chat/message/ChatMessage;", "animate", "", "addCopilotMessage", "addUserMessage", "addMessageAndTriggerUpdate", "messageComponent", "Lcom/github/copilot/chat/message/MessageComponent;", "removeUserMessage", "", "retryUserMessage", "addUserMessageWithResponsePlaceholder", "Lcom/github/copilot/chat/message/CopilotMessageComponent;", "addUserMessageWithResponsePlaceholder$core", "focusInputPanel", "core"})
@SourceDebugExtension(value={"SMAP\nChatSessionComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatSessionComponent.kt\ncom/github/copilot/chat/session/component/ChatSessionComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,404:1\n766#2:405\n857#2,2:406\n1855#2:408\n1856#2:411\n1855#2,2:426\n1855#2,2:428\n215#3,2:409\n39#4:412\n37#5,2:413\n4098#6,11:415\n*S KotlinDebug\n*F\n+ 1 ChatSessionComponent.kt\ncom/github/copilot/chat/session/component/ChatSessionComponent\n*L\n98#1:405\n98#1:406,2\n99#1:408\n99#1:411\n184#1:426,2\n198#1:428,2\n101#1:409,2\n52#1:412\n173#1:413,2\n184#1:415,11\n*E\n"})
public final class ChatSessionComponent
extends JPanel {
    @NotNull
    private final ChatSessionController controller;
    @NotNull
    private final CopilotModelService copilotModelService;
    @NotNull
    private final Logger log;
    @NotNull
    private final VerticalStackWrappingPanel messagePanel;
    @NotNull
    private final CopilotChatInputPanel chatInputPanel;
    @Nullable
    private ChatSessionToolBarComponent toolBarComponent;
    @NotNull
    private final JBScrollPane scrollPane;
    @NotNull
    private final StickyScrollingManager stickyScrollingManager;
    @NotNull
    private final FollowUpPanel followUpPanel;
    @NotNull
    private final DragAndDropFileListener dragAndDropFileListener;
    @Nullable
    private final Timer messagePanelScrollWorker;

    /*
     * WARNING - void declaration
     */
    public ChatSessionComponent(@NotNull ChatSessionController controller, @NotNull RemoteAgentService remoteAgentService, @NotNull CopilotModelService copilotModelService, @NotNull Logger log) {
        JPanel jPanel;
        Iterator $this$filterTo$iv$iv;
        void $this$scrollPane_u24lambda_u240;
        JBScrollPane jBScrollPane;
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)remoteAgentService, (String)"remoteAgentService");
        Intrinsics.checkNotNullParameter((Object)copilotModelService, (String)"copilotModelService");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        super(new BorderLayout());
        this.controller = controller;
        this.copilotModelService = copilotModelService;
        this.log = log;
        this.messagePanel = new VerticalStackWrappingPanel();
        this.chatInputPanel = new CopilotChatInputPanel(this.controller, this.controller.getPersistenceService(), remoteAgentService, this.copilotModelService);
        JBScrollPane jBScrollPane2 = jBScrollPane = new JBScrollPane((Component)this.messagePanel);
        ChatSessionComponent chatSessionComponent = this;
        boolean bl = false;
        $this$scrollPane_u24lambda_u240.setOpaque(false);
        $this$scrollPane_u24lambda_u240.getViewport().setOpaque(false);
        $this$scrollPane_u24lambda_u240.setBorder(Style.Borders.INSTANCE.getChatMessageScrollPaneBorder());
        chatSessionComponent.scrollPane = jBScrollPane;
        this.stickyScrollingManager = new StickyScrollingManager(this.messagePanel, (JScrollPane)this.scrollPane, false, 4, null);
        this.followUpPanel = new FollowUpPanel();
        this.dragAndDropFileListener = new DragAndDropFileListener(this.controller.getChatSessionManager().getProject());
        this.messagePanelScrollWorker = ApplicationManager.getApplication().isHeadlessEnvironment() ? null : new MessagePanelScrollWorker(this.controller, this.scrollPane).start();
        UIManager.addPropertyChangeListener(arg_0 -> ChatSessionComponent._init_$lambda$1(this, arg_0));
        this.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                this.getDragAndDropFileListener().addDragAndDropListenerToAllChildren(this);
                this.focusInputPanel();
            }
        });
        Iterable $this$filter$iv = this.controller.getSession().getMessages();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            ChatMessage it = (ChatMessage)element$iv$iv;
            boolean bl2 = false;
            if (!ChatMessageKt.isNotDeleted(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List visibleMessages = (List)destination$iv$iv;
        Iterable $this$forEach$iv = visibleMessages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatMessage it = (ChatMessage)element$iv;
            boolean bl3 = false;
            Map<String, Step> $this$forEach$iv2 = it.getSteps();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, Step>> iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Step> element$iv2;
                Map.Entry<String, Step> step = element$iv2 = iterator2.next();
                boolean bl4 = false;
                if (!step.getValue().isRunning()) continue;
                step.getValue().setFailed(new StepError("Interrupted"));
            }
            switch (WhenMappings.$EnumSwitchMapping$0[it.getType().ordinal()]) {
                case 1: {
                    this.addWelcomeMessage(it, this.controller.getSession().getMessages().size() == 1);
                    break;
                }
                case 2: {
                    this.addUserMessage(it);
                    break;
                }
                case 3: {
                    this.addCopilotMessage(it);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        this.followUpPanel.setVisible(false);
        JPanel followUpAndInfoCombinedPanel = new JPanel((LayoutManager)new VerticalLayout(12));
        followUpAndInfoCombinedPanel.add(this.followUpPanel);
        ContentExclusionInfoPanel contentExclusionInfoPanel = new ContentExclusionInfoPanel();
        followUpAndInfoCombinedPanel.add(contentExclusionInfoPanel);
        JPanel $this$_init__u24lambda_u245 = jPanel = new JPanel(new BorderLayout());
        boolean bl5 = false;
        $this$_init__u24lambda_u245.add((Component)followUpAndInfoCombinedPanel, "North");
        $this$_init__u24lambda_u245.add((Component)this.chatInputPanel, "Center");
        JPanel textInputPanel = jPanel;
        this.add((Component)this.scrollPane, "Center");
        this.replaceToolbarForController(this.controller);
        this.add((Component)textInputPanel, "South");
        this.addMouseListener(new FocusMouseListener((JComponent)((Object)this.chatInputPanel.getTextInputArea())));
        this.scrollPane.addMouseListener((MouseListener)new FocusMouseListener((JComponent)((Object)this.chatInputPanel.getTextInputArea())));
    }

    public /* synthetic */ ChatSessionComponent(ChatSessionController chatSessionController, RemoteAgentService remoteAgentService, CopilotModelService copilotModelService, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(ChatSessionComponent.class);
        }
        this(chatSessionController, remoteAgentService, copilotModelService, logger);
    }

    @NotNull
    public final ChatSessionController getController() {
        return this.controller;
    }

    @NotNull
    public final VerticalStackWrappingPanel getMessagePanel() {
        return this.messagePanel;
    }

    @NotNull
    public final CopilotChatInputPanel getChatInputPanel() {
        return this.chatInputPanel;
    }

    @Nullable
    public final ChatSessionToolBarComponent getToolBarComponent() {
        return this.toolBarComponent;
    }

    public final void setToolBarComponent(@Nullable ChatSessionToolBarComponent chatSessionToolBarComponent) {
        this.toolBarComponent = chatSessionToolBarComponent;
    }

    @NotNull
    public final DragAndDropFileListener getDragAndDropFileListener() {
        return this.dragAndDropFileListener;
    }

    @Nullable
    public final Timer getMessagePanelScrollWorker() {
        return this.messagePanelScrollWorker;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return new Dimension(Math.max(UiSizeUtilKt.getPreferredWidth((JComponent)((JComponent)this.scrollPane)), UiSizeUtilKt.getPreferredWidth((JComponent)this.chatInputPanel)), super.getPreferredSize().height);
    }

    public final void replaceToolbarForController(@NotNull ChatSessionController chatSessionController) {
        ChatSessionToolBarComponent newToolBarComponent;
        AnAction[] anActionArray;
        Intrinsics.checkNotNullParameter((Object)chatSessionController, (String)"chatSessionController");
        List actions = new ArrayList();
        actions.add(new ConversationHistoryAction(chatSessionController, this, null, 4, null));
        actions.add(new NewConversationAction(chatSessionController, false, 2, null));
        AnAction[] anActionArray2 = new AnAction[]{new RenameAction(chatSessionController), new DeleteAction(ProjectKt.getProject(), chatSessionController)};
        actions.add(new PopupActionGroup("More Options", null, anActionArray2, 2, null));
        ChatSessionToolBarComponent chatSessionToolBarComponent = this.toolBarComponent;
        if (chatSessionToolBarComponent != null) {
            ChatSessionToolBarComponent it = chatSessionToolBarComponent;
            boolean bl = false;
            this.remove(this.toolBarComponent);
        }
        AnAction[] $this$replaceToolbarForController_u24lambda_u247 = anActionArray = new SecondaryTextLabel(this.controller.getSession().getName().getValue());
        boolean bl = false;
        $this$replaceToolbarForController_u24lambda_u247.setForeground((Color)Style.Colors.INSTANCE.getSECONDARY_TEXT());
        Component component2 = (Component)anActionArray;
        Collection $this$toTypedArray$iv = actions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        anActionArray = thisCollection$iv.toArray(new AnAction[0]);
        AnAction[] anActionArray3 = Arrays.copyOf(anActionArray, anActionArray.length);
        Component component3 = component2;
        this.toolBarComponent = newToolBarComponent = new ChatSessionToolBarComponent(component3, anActionArray3);
        this.add((Component)newToolBarComponent, "North");
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateToolBar() {
        block2: {
            void $this$filterIsInstanceTo$iv$iv;
            ChatSessionToolBarComponent chatSessionToolBarComponent = this.toolBarComponent;
            if (chatSessionToolBarComponent == null) break block2;
            ChatSessionToolBarComponent it = chatSessionToolBarComponent;
            boolean bl = false;
            Component[] componentArray = it.getToolbarActionSection().getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            Object[] $this$filterIsInstance$iv = componentArray;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ActionButton)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ActionButton actionButton = (ActionButton)element$iv;
                boolean bl2 = false;
                actionButton.update();
            }
        }
    }

    public final void updateFollowUps(@NotNull List<ChatFollowUp> followUps) {
        Intrinsics.checkNotNullParameter(followUps, (String)"followUps");
        this.controller.getSession().setFollowUps(followUps);
        ApplicationManager.getApplication().invokeLater(() -> ChatSessionComponent.updateFollowUps$lambda$12(this, followUps));
    }

    private final void addWelcomeMessage(ChatMessage message, boolean animate) {
        if (animate) {
            ConversationService conversationService = this.controller.getConversationService();
            Project project = this.controller.getChatSessionManager().getProject();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            this.addMessageAndTriggerUpdate((MessageComponent)AnimationDslKt.animate((JComponent)new MessageComponent(message, conversationService, project, true, false, null, null, locale, 112, null), new EaseOut(16), 180));
        } else {
            ConversationService conversationService = this.controller.getConversationService();
            Project project = this.controller.getChatSessionManager().getProject();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            this.addMessageAndTriggerUpdate(new MessageComponent(message, conversationService, project, true, false, null, null, locale, 112, null));
        }
    }

    static /* synthetic */ void addWelcomeMessage$default(ChatSessionComponent chatSessionComponent, ChatMessage chatMessage, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        chatSessionComponent.addWelcomeMessage(chatMessage, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void addCopilotMessage(ChatMessage message) {
        void $this$addCopilotMessage_u24lambda_u2414;
        CopilotMessageComponent copilotMessageComponent;
        CopilotMessageComponent copilotMessageComponent2 = copilotMessageComponent = new CopilotMessageComponent(message, arg_0 -> ChatSessionComponent.addCopilotMessage$lambda$13(this, arg_0), this.controller.getConversationService(), this.controller.getChatSessionManager().getProject(), false, null, false, this.messagePanel.getComponents().length == 0, 112, null);
        ChatSessionComponent chatSessionComponent = this;
        boolean bl = false;
        $this$addCopilotMessage_u24lambda_u2414.setReferences(message.getReferences());
        chatSessionComponent.addMessageAndTriggerUpdate(copilotMessageComponent);
    }

    private final void addUserMessage(ChatMessage message) {
        this.addMessageAndTriggerUpdate(new UserMessageComponent(message, arg_0 -> ChatSessionComponent.addUserMessage$lambda$15(this, arg_0), this.controller.getConversationService(), this.controller.getChatSessionManager().getProject()));
    }

    private final void addMessageAndTriggerUpdate(MessageComponent messageComponent) {
        Component[] componentArray = this.messagePanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Component component2 = (Component)ArraysKt.lastOrNull((Object[])componentArray);
        if (component2 != null) {
            Component it = component2;
            boolean bl = false;
            if (it instanceof CopilotMessageComponent) {
                ((CopilotMessageComponent)it).setLast(false);
            }
        }
        this.messagePanel.add(messageComponent);
        if (messageComponent instanceof CopilotMessageComponent) {
            ((CopilotMessageComponent)messageComponent).setLast(true);
        }
        this.updateToolBar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object removeUserMessage(MessageComponent message) {
        Unit unit;
        try {
            Object object;
            Component[] componentArray = this.messagePanel.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            int index = ArraysKt.indexOf((Object[])componentArray, (Object)message);
            if (index + 1 < this.messagePanel.getComponents().length) {
                CharSequence charSequence;
                Component component2 = this.messagePanel.getComponents()[index + 1];
                Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type com.github.copilot.chat.message.MessageComponent");
                MessageComponent responseMessage = (MessageComponent)component2;
                String conversationId = this.controller.getSession().getConversationId();
                String turnId = responseMessage.getChatMessage().getTurnId();
                if (index + 2 == this.messagePanel.getComponents().length) {
                    SessionController.stopActiveResponses$default(this.controller, false, 1, null);
                }
                String string = turnId;
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    ChatSessionPersistenceService.DefaultImpls.softDeleteTurn$default(this.controller.getPersistenceService(), this.controller.getSession().getId(), it, null, 4, null);
                }
                if (StringsKt.isBlank((CharSequence)conversationId) || (charSequence = (CharSequence)turnId) == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    this.log.warn("Cannot delete message with empty conversation id or turn id");
                    object = Unit.INSTANCE;
                } else {
                    object = this.controller.getConversationService().deleteTurn(new DeleteTurnCommand(conversationId, turnId));
                }
            } else {
                this.log.warn("Cannot delete message");
                object = Unit.INSTANCE;
            }
            unit = object;
        }
        catch (Exception e) {
            this.log.warn("Failed to remove user message", e);
            unit = Unit.INSTANCE;
        }
        finally {
            this.messagePanel.removeComponentAndNext(message);
            Component[] componentArray = this.messagePanel.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            Component component3 = (Component)ArraysKt.lastOrNull((Object[])componentArray);
            if (component3 != null) {
                Component it = component3;
                boolean bl = false;
                if (it instanceof CopilotMessageComponent) {
                    ((CopilotMessageComponent)it).setLast(true);
                }
            }
        }
        return unit;
    }

    private final void retryUserMessage(MessageComponent message) {
        block7: {
            try {
                Component[] componentArray = this.messagePanel.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                int index = ArraysKt.indexOf((Object[])componentArray, (Object)message) - 1;
                if (index == this.messagePanel.getComponents().length - 2 && index >= 0) {
                    CharSequence charSequence;
                    Component component2 = this.messagePanel.getComponents()[index + 1];
                    Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type com.github.copilot.chat.message.MessageComponent");
                    MessageComponent responseMessage = (MessageComponent)component2;
                    String conversationId = this.controller.getSession().getConversationId();
                    String turnId = responseMessage.getChatMessage().getTurnId();
                    Component component3 = this.messagePanel.getComponents()[index];
                    Intrinsics.checkNotNull((Object)component3, (String)"null cannot be cast to non-null type com.github.copilot.chat.message.MessageComponent");
                    MessageComponent userMessage = (MessageComponent)component3;
                    String originalMessage = userMessage.getChatMessage().getContent();
                    if (index + 2 == this.messagePanel.getComponents().length) {
                        SessionController.stopActiveResponses$default(this.controller, false, 1, null);
                    }
                    String string = turnId;
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        ChatSessionPersistenceService.DefaultImpls.softDeleteTurn$default(this.controller.getPersistenceService(), this.controller.getSession().getId(), it, null, 4, null);
                    }
                    if (StringsKt.isBlank((CharSequence)conversationId) || (charSequence = (CharSequence)turnId) == null || StringsKt.isBlank((CharSequence)charSequence)) {
                        this.log.warn("Cannot delete message with empty conversation id or turn id");
                    } else {
                        this.log.debug("Deleting turn with conversationId: " + conversationId + " and turnId: " + turnId);
                        this.controller.getConversationService().deleteTurn(new DeleteTurnCommand(conversationId, turnId));
                    }
                    this.messagePanel.removeComponentAndNext(userMessage);
                    UserMessageListener.Companion.onUserMessage(originalMessage, this.controller.getSession(), null, null, null, null);
                    break block7;
                }
                this.log.warn("Cannot retry message - not the last message");
            }
            catch (Exception e) {
                this.log.warn("Failed to retry user message", e);
            }
        }
    }

    @NotNull
    public final CopilotMessageComponent addUserMessageWithResponsePlaceholder$core(@NotNull ChatMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.addUserMessage(message);
        GitHubUser gitHubUser = Users.INSTANCE.getCopilotUser();
        ChatMessageType chatMessageType = ChatMessageType.RESPONSE;
        RemoteAgent remoteAgent = message.getAgent();
        CopilotMessageComponent copilotMessageComponent = new CopilotMessageComponent(new ChatMessage(chatMessageType, gitHubUser, null, null, null, null, null, null, null, null, null, null, null, null, remoteAgent, null, null, null, null, null, null, 2080764, null), arg_0 -> ChatSessionComponent.addUserMessageWithResponsePlaceholder$lambda$20(this, arg_0), this.controller.getConversationService(), ProjectKt.getProject(), false, null, false, true, 112, null);
        this.addMessageAndTriggerUpdate(copilotMessageComponent);
        this.stickyScrollingManager.scrollToBottom();
        this.controller.lockSession();
        return copilotMessageComponent;
    }

    public final void focusInputPanel() {
        this.chatInputPanel.getTextInputArea().requestFocusInWindow();
    }

    private static final void _init_$lambda$1(ChatSessionComponent this$0, PropertyChangeEvent evt) {
        if (Intrinsics.areEqual((Object)"lookAndFeel", (Object)evt.getPropertyName())) {
            this$0.scrollPane.setBorder(Style.Borders.INSTANCE.getChatMessageScrollPaneBorder());
        }
    }

    private static final Unit updateFollowUps$lambda$12$lambda$11$lambda$10(ChatFollowUp $it, ChatSessionComponent this$0) {
        UserMessageListener.Companion.onUserMessage($it.getMessage(), this$0.controller.getSession(), $it, null, null, null);
        return Unit.INSTANCE;
    }

    private static final void updateFollowUps$lambda$12(ChatSessionComponent this$0, List $followUps) {
        this$0.followUpPanel.removeAll();
        if ($followUps.isEmpty()) {
            this$0.followUpPanel.setVisible(false);
        } else {
            this$0.followUpPanel.setVisible(true);
            Iterable $this$forEach$iv = $followUps;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChatFollowUp it = (ChatFollowUp)element$iv;
                boolean bl = false;
                this$0.followUpPanel.add(new FollowUpComponent(it, (Function0<Unit>)((Function0)() -> ChatSessionComponent.updateFollowUps$lambda$12$lambda$11$lambda$10(it, this$0))));
            }
        }
        this$0.followUpPanel.invalidate();
        this$0.followUpPanel.repaint();
    }

    private static final void addCopilotMessage$lambda$13(ChatSessionComponent this$0, MessageComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.retryUserMessage(it);
    }

    private static final void addUserMessage$lambda$15(ChatSessionComponent this$0, MessageComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.removeUserMessage(it);
    }

    private static final void addUserMessageWithResponsePlaceholder$lambda$20(ChatSessionComponent this$0, MessageComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.retryUserMessage(it);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChatMessageType.values().length];
            try {
                nArray[ChatMessageType.WELCOME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatMessageType.QUERY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatMessageType.RESPONSE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

