/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.session.component;

import com.github.copilot.chat.session.component.ChatSessionOption;
import com.github.copilot.style.Style;
import com.github.copilot.ui.component.JComponentKt;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Q\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003*\u00012\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u000206H\u0014J\u0006\u00107\u001a\u00020\u000bJ\u0006\u00108\u001a\u00020\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R(\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010(\"\u0004\b-\u0010*R\u001a\u0010.\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010(\"\u0004\b0\u0010*R\u0010\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00103\u00a8\u00069"}, d2={"Lcom/github/copilot/chat/session/component/ChatSessionOption;", "Ljavax/swing/JPanel;", "icon", "Ljavax/swing/Icon;", "text", "", "secondaryText", "contextMenu", "Ljavax/swing/JPopupMenu;", "onClick", "Lkotlin/Function0;", "", "<init>", "(Ljavax/swing/Icon;Ljava/lang/String;Ljava/lang/String;Ljavax/swing/JPopupMenu;Lkotlin/jvm/functions/Function0;)V", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "getContextMenu", "()Ljavax/swing/JPopupMenu;", "setContextMenu", "(Ljavax/swing/JPopupMenu;)V", "getOnClick", "()Lkotlin/jvm/functions/Function0;", "value", "Ljava/awt/Color;", "backgroundColor", "getBackgroundColor", "()Ljava/awt/Color;", "setBackgroundColor", "(Ljava/awt/Color;)V", "hoverColor", "getHoverColor", "setHoverColor", "textComponent", "Ljavax/swing/JLabel;", "getTextComponent", "()Ljavax/swing/JLabel;", "isSelected", "", "()Z", "setSelected", "(Z)V", "hasKeyboardFocus", "getHasKeyboardFocus", "setHasKeyboardFocus", "hasHover", "getHasHover", "setHasHover", "mouseAdapter", "com/github/copilot/chat/session/component/ChatSessionOption$mouseAdapter$1", "Lcom/github/copilot/chat/session/component/ChatSessionOption$mouseAdapter$1;", "paintComponent", "g", "Ljava/awt/Graphics;", "applyKeyboardFocus", "removeKeyboardFocus", "core"})
public final class ChatSessionOption
extends JPanel {
    @NotNull
    private String text;
    @Nullable
    private JPopupMenu contextMenu;
    @NotNull
    private final Function0<Unit> onClick;
    @Nullable
    private Color backgroundColor;
    @Nullable
    private Color hoverColor;
    @NotNull
    private final JLabel textComponent;
    private boolean isSelected;
    private boolean hasKeyboardFocus;
    private boolean hasHover;
    @NotNull
    private final mouseAdapter.1 mouseAdapter;

    /*
     * WARNING - void declaration
     */
    public ChatSessionOption(@NotNull Icon icon, @NotNull String text, @NotNull String secondaryText, @Nullable JPopupMenu contextMenu, @NotNull Function0<Unit> onClick) {
        JLabel $this$_init__u24lambda_u241;
        JLabel jLabel;
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)secondaryText, (String)"secondaryText");
        Intrinsics.checkNotNullParameter(onClick, (String)"onClick");
        super(new BorderLayout());
        this.text = text;
        this.contextMenu = contextMenu;
        this.onClick = onClick;
        this.hoverColor = JBUI.CurrentTheme.List.Hover.background((boolean)true);
        this.textComponent = new JLabel(this.text);
        this.mouseAdapter = new MouseAdapter(this){
            final /* synthetic */ ChatSessionOption this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseEntered(MouseEvent e) {
                this.this$0.setHasHover(true);
                if (this.this$0.getHasKeyboardFocus()) {
                    return;
                }
                this.this$0.setBackground(this.this$0.getHoverColor());
                this.this$0.revalidate();
                this.this$0.repaint();
            }

            public void mouseExited(MouseEvent e) {
                this.this$0.setHasHover(false);
                if (this.this$0.getHasKeyboardFocus()) {
                    return;
                }
                this.this$0.setBackground(this.this$0.getBackgroundColor());
                this.this$0.revalidate();
                this.this$0.repaint();
            }

            /*
             * Enabled aggressive block sorting
             */
            public void mouseClicked(MouseEvent e) {
                if (this.this$0.getContextMenu() != null) {
                    MouseEvent mouseEvent = e;
                    boolean bl = mouseEvent != null ? mouseEvent.getButton() == 3 : false;
                    if (bl) {
                        JPopupMenu jPopupMenu = this.this$0.getContextMenu();
                        Intrinsics.checkNotNull((Object)jPopupMenu);
                        jPopupMenu.show(this.this$0, e.getX(), e.getY());
                        return;
                    }
                }
                this.this$0.getOnClick().invoke();
            }
        };
        this.setOpaque(false);
        JLabel jLabel2 = jLabel = new JLabel(icon);
        ChatSessionOption chatSessionOption = this;
        boolean bl = false;
        $this$_init__u24lambda_u241.setBorder(Style.Borders.INSTANCE.getChatSessionOptionIconBorder());
        chatSessionOption.add((Component)jLabel, "West");
        this.add((Component)this.textComponent, "Center");
        if (((CharSequence)secondaryText).length() > 0) {
            void $this$_init__u24lambda_u242;
            $this$_init__u24lambda_u241 = jLabel = new JLabel(secondaryText);
            chatSessionOption = this;
            boolean bl2 = false;
            $this$_init__u24lambda_u242.setForeground((Color)Style.Colors.INSTANCE.getSECONDARY_TEXT());
            $this$_init__u24lambda_u242.setBorder(Style.Borders.INSTANCE.getChatSessionOptionSecondaryTextBorder());
            chatSessionOption.add((Component)jLabel, "East");
        }
        this.addMouseListener(this.mouseAdapter);
        JComponentKt.inAllChildren(this, (Function1<? super JComponent, Unit>)((Function1)arg_0 -> ChatSessionOption._init_$lambda$3(this, arg_0)));
        this.setFocusable(true);
        this.setBorder(Style.Borders.INSTANCE.getChatSessionOptionBorder());
    }

    public /* synthetic */ ChatSessionOption(Icon icon, String string, String string2, JPopupMenu jPopupMenu, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            jPopupMenu = null;
        }
        if ((n & 0x10) != 0) {
            function0 = ChatSessionOption::_init_$lambda$0;
        }
        this(icon, string, string2, jPopupMenu, (Function0<Unit>)function0);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.text = string;
    }

    @Nullable
    public final JPopupMenu getContextMenu() {
        return this.contextMenu;
    }

    public final void setContextMenu(@Nullable JPopupMenu jPopupMenu) {
        this.contextMenu = jPopupMenu;
    }

    @NotNull
    public final Function0<Unit> getOnClick() {
        return this.onClick;
    }

    @Nullable
    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public final void setBackgroundColor(@Nullable Color value) {
        this.backgroundColor = value;
        this.setBackground(value);
    }

    @Nullable
    public final Color getHoverColor() {
        return this.hoverColor;
    }

    public final void setHoverColor(@Nullable Color color) {
        this.hoverColor = color;
    }

    @NotNull
    public final JLabel getTextComponent() {
        return this.textComponent;
    }

    public final boolean isSelected() {
        return this.isSelected;
    }

    public final void setSelected(boolean bl) {
        this.isSelected = bl;
    }

    public final boolean getHasKeyboardFocus() {
        return this.hasKeyboardFocus;
    }

    public final void setHasKeyboardFocus(boolean bl) {
        this.hasKeyboardFocus = bl;
    }

    public final boolean getHasHover() {
        return this.hasHover;
    }

    public final void setHasHover(boolean bl) {
        this.hasHover = bl;
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.getBackground());
        g2.fillRoundRect(8, 0, this.getWidth() - 8, this.getHeight(), 6, 6);
        if (this.isSelected) {
            g2.setColor((Color)Style.Colors.INSTANCE.getSELECTED_CONVERSATION());
            g2.fillRoundRect(1, 0, 5, this.getHeight(), 4, 4);
        }
        g2.dispose();
    }

    public final void applyKeyboardFocus() {
        this.hasKeyboardFocus = true;
        this.setBackground(JBUI.CurrentTheme.Focus.focusColor());
        this.revalidate();
        this.repaint();
    }

    public final void removeKeyboardFocus() {
        this.hasKeyboardFocus = false;
        this.setBackground(this.backgroundColor);
        if (this.hasHover) {
            this.setBackground(this.hoverColor);
        }
        this.revalidate();
        this.repaint();
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(ChatSessionOption this$0, JComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addMouseListener(this$0.mouseAdapter);
        return Unit.INSTANCE;
    }
}

