/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.session.component;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotIcons;
import com.github.copilot.chat.session.ChatSession;
import com.github.copilot.chat.session.ChatSessionController;
import com.github.copilot.chat.session.component.ChatSessionOption;
import com.github.copilot.chat.session.component.RecentConversationsPanel;
import com.github.copilot.chat.session.component.Separator;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.github.copilot.style.Style;
import com.intellij.openapi.project.Project;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdesktop.swingx.VerticalLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001Bc\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/github/copilot/chat/session/component/ChatSessionPopupComponent;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "chatSessionController", "Lcom/github/copilot/chat/session/ChatSessionController;", "onViewAll", "Lkotlin/Function0;", "", "onDelete", "onConversationSelect", "onRename", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/github/copilot/chat/session/ChatSessionController;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lcom/github/copilot/platform/utils/observability/Logger;)V", "createKeyListener", "Ljava/awt/event/KeyAdapter;", "optionList", "", "Lcom/github/copilot/chat/session/component/ChatSessionOption;", "core"})
@SourceDebugExtension(value={"SMAP\nChatSessionPopupComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatSessionPopupComponent.kt\ncom/github/copilot/chat/session/component/ChatSessionPopupComponent\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,281:1\n39#2:282\n*S KotlinDebug\n*F\n+ 1 ChatSessionPopupComponent.kt\ncom/github/copilot/chat/session/component/ChatSessionPopupComponent\n*L\n34#1:282\n*E\n"})
public final class ChatSessionPopupComponent
extends JPanel {
    public ChatSessionPopupComponent(@Nullable Project project, @NotNull ChatSessionController chatSessionController, @NotNull Function0<Unit> onViewAll, @NotNull Function0<Unit> onDelete, @NotNull Function0<Unit> onConversationSelect, @NotNull Function0<Unit> onRename, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)chatSessionController, (String)"chatSessionController");
        Intrinsics.checkNotNullParameter(onViewAll, (String)"onViewAll");
        Intrinsics.checkNotNullParameter(onDelete, (String)"onDelete");
        Intrinsics.checkNotNullParameter(onConversationSelect, (String)"onConversationSelect");
        Intrinsics.checkNotNullParameter(onRename, (String)"onRename");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        super((LayoutManager)new VerticalLayout());
        log.trace("Fetching recent chat sessions excluding session with id " + chatSessionController.getSession().getId() + ".");
        List<ChatSession> recentChatSessions = chatSessionController.getChatSessionManager().getChatSessions(5);
        List optionList = new ArrayList();
        if (!((Collection)recentChatSessions).isEmpty()) {
            this.add(new RecentConversationsPanel(project, chatSessionController.getSession(), recentChatSessions, onConversationSelect, onDelete, onRename, optionList));
            this.add(new Separator());
        }
        Icon icon = CopilotIcons.Archive;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Archive");
        String string = CopilotBundle.get("copilot.chat.session.action.view.all.conversations");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        ChatSessionOption viewAllOption = new ChatSessionOption(icon, string, null, null, () -> ChatSessionPopupComponent._init_$lambda$4(onViewAll, chatSessionController), 12, null);
        this.add(viewAllOption);
        optionList.add(viewAllOption);
        this.setBorder(Style.Borders.INSTANCE.getChatSessionPopupBorder());
        this.setFocusable(true);
        this.addKeyListener(this.createKeyListener(optionList));
    }

    public /* synthetic */ ChatSessionPopupComponent(Project project, ChatSessionController chatSessionController, Function0 function0, Function0 function02, Function0 function03, Function0 function04, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = ChatSessionPopupComponent::_init_$lambda$0;
        }
        if ((n & 8) != 0) {
            function02 = ChatSessionPopupComponent::_init_$lambda$1;
        }
        if ((n & 0x10) != 0) {
            function03 = ChatSessionPopupComponent::_init_$lambda$2;
        }
        if ((n & 0x20) != 0) {
            function04 = ChatSessionPopupComponent::_init_$lambda$3;
        }
        if ((n & 0x40) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(ChatSessionPopupComponent.class);
        }
        this(project, chatSessionController, (Function0<Unit>)function0, (Function0<Unit>)function02, (Function0<Unit>)function03, (Function0<Unit>)function04, logger);
    }

    private final KeyAdapter createKeyListener(List<ChatSessionOption> optionList) {
        return new KeyAdapter(optionList){
            private int currentlyFocusedIndex;
            final /* synthetic */ List<ChatSessionOption> $optionList;
            {
                this.$optionList = $optionList;
            }

            public final int getCurrentlyFocusedIndex() {
                return this.currentlyFocusedIndex;
            }

            public final void setCurrentlyFocusedIndex(int n) {
                this.currentlyFocusedIndex = n;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                switch (e.getKeyCode()) {
                    case 38: {
                        this.$optionList.get(this.currentlyFocusedIndex).removeKeyboardFocus();
                        this.currentlyFocusedIndex = this.currentlyFocusedIndex == 0 ? this.$optionList.size() - 1 : this.currentlyFocusedIndex - 1;
                        this.$optionList.get(this.currentlyFocusedIndex).applyKeyboardFocus();
                        break;
                    }
                    case 40: {
                        this.$optionList.get(this.currentlyFocusedIndex).removeKeyboardFocus();
                        this.currentlyFocusedIndex = this.currentlyFocusedIndex == this.$optionList.size() - 1 ? 0 : this.currentlyFocusedIndex + 1;
                        this.$optionList.get(this.currentlyFocusedIndex).applyKeyboardFocus();
                        break;
                    }
                    case 10: {
                        this.$optionList.get(this.currentlyFocusedIndex).getOnClick().invoke();
                    }
                }
            }
        };
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1() {
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2() {
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3() {
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(Function0 $onViewAll, ChatSessionController $chatSessionController) {
        $onViewAll.invoke();
        $chatSessionController.getComponent().setViewAll();
        return Unit.INSTANCE;
    }
}

