/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.session.persistence;

import com.github.copilot.chat.session.persistence.PersistedAgent;
import com.github.copilot.chat.session.persistence.PersistedConfirmationRequest;
import com.github.copilot.chat.session.persistence.PersistedConfirmationResponse;
import com.github.copilot.chat.session.persistence.PersistedMessage;
import com.github.copilot.chat.session.persistence.PersistedMessageAnnotation;
import com.github.copilot.chat.session.persistence.PersistedMessageStatus;
import com.github.copilot.chat.session.persistence.PersistedMessageType;
import com.github.copilot.chat.session.persistence.PersistedNotification;
import com.github.copilot.chat.session.persistence.PersistedReference;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001cJ\u000e\u0010\r\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0014\u0010\u0012\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010J\u000e\u0010\u0015\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0018J\u0014\u0010\u0019\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0010J\u0006\u0010%\u001a\u00020&J\t\u0010'\u001a\u00020\u0003H\u00c2\u0003J\t\u0010(\u001a\u00020\u0005H\u00c2\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0007H\u00c2\u0003J)\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010+\u001a\u00020\u001f2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020\u001cH\u00d6\u0001J\t\u0010.\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001d\u00a8\u0006/"}, d2={"Lcom/github/copilot/chat/session/persistence/PersistedMessageBuilder;", "", "user", "", "type", "Lcom/github/copilot/chat/session/persistence/PersistedMessageType;", "agent", "Lcom/github/copilot/chat/session/persistence/PersistedAgent;", "<init>", "(Ljava/lang/String;Lcom/github/copilot/chat/session/persistence/PersistedMessageType;Lcom/github/copilot/chat/session/persistence/PersistedAgent;)V", "contentBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "status", "Lcom/github/copilot/chat/session/persistence/PersistedMessageStatus;", "references", "", "Lcom/github/copilot/chat/session/persistence/PersistedReference;", "annotations", "", "Lcom/github/copilot/chat/session/persistence/PersistedMessageAnnotation;", "confirmationRequest", "Lcom/github/copilot/chat/session/persistence/PersistedConfirmationRequest;", "confirmationResponse", "Lcom/github/copilot/chat/session/persistence/PersistedConfirmationResponse;", "notifications", "Lcom/github/copilot/chat/session/persistence/PersistedNotification;", "errorCode", "", "Ljava/lang/Integer;", "hasBeenCancelled", "", "hasNotBeenCancelled", "appendContent", "", "value", "setContent", "build", "Lcom/github/copilot/chat/session/persistence/PersistedMessage;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "core"})
public final class PersistedMessageBuilder {
    @NotNull
    private final String user;
    @NotNull
    private final PersistedMessageType type;
    @Nullable
    private final PersistedAgent agent;
    @NotNull
    private final StringBuilder contentBuilder;
    @NotNull
    private PersistedMessageStatus status;
    @NotNull
    private Set<? extends PersistedReference> references;
    @NotNull
    private final Set<PersistedMessageAnnotation> annotations;
    @Nullable
    private PersistedConfirmationRequest confirmationRequest;
    @Nullable
    private PersistedConfirmationResponse confirmationResponse;
    @NotNull
    private Set<PersistedNotification> notifications;
    @Nullable
    private Integer errorCode;

    public PersistedMessageBuilder(@NotNull String user, @NotNull PersistedMessageType type, @Nullable PersistedAgent agent) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.user = user;
        this.type = type;
        this.agent = agent;
        this.contentBuilder = new StringBuilder();
        this.status = PersistedMessageStatus.OK;
        this.references = SetsKt.emptySet();
        this.annotations = new LinkedHashSet();
        this.notifications = SetsKt.emptySet();
        this.errorCode = 0;
    }

    public final boolean hasBeenCancelled() {
        return this.status == PersistedMessageStatus.CANCELLED;
    }

    public final boolean hasNotBeenCancelled() {
        return !this.hasBeenCancelled();
    }

    public final void appendContent(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.contentBuilder.append(value);
    }

    public final void setContent(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        StringsKt.clear((StringBuilder)this.contentBuilder);
        this.contentBuilder.append(value);
    }

    public final void errorCode(int value) {
        this.errorCode = value;
    }

    public final void status(@NotNull PersistedMessageStatus value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.status = value;
    }

    public final void references(@NotNull Set<? extends PersistedReference> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.references = value;
    }

    public final void annotations(@NotNull Set<PersistedMessageAnnotation> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.annotations.addAll((Collection<PersistedMessageAnnotation>)value);
    }

    public final void confirmationRequest(@NotNull PersistedConfirmationRequest value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.confirmationRequest = value;
    }

    public final void confirmationResponse(@NotNull PersistedConfirmationResponse value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.confirmationResponse = value;
    }

    public final void notifications(@NotNull Set<PersistedNotification> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.notifications = value;
    }

    @NotNull
    public final PersistedMessage build() {
        String string = this.user;
        PersistedMessageType persistedMessageType = this.type;
        PersistedMessageStatus persistedMessageStatus = this.status;
        String string2 = this.contentBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = string2;
        Set<? extends PersistedReference> set = this.references;
        Set<PersistedMessageAnnotation> set2 = this.annotations;
        PersistedAgent persistedAgent = this.agent;
        PersistedConfirmationRequest persistedConfirmationRequest = this.confirmationRequest;
        PersistedConfirmationResponse persistedConfirmationResponse = this.confirmationResponse;
        Set<PersistedNotification> set3 = this.notifications;
        Integer n = this.errorCode;
        return new PersistedMessage(string, persistedMessageType, persistedMessageStatus, string3, set, set2, persistedAgent, persistedConfirmationResponse, persistedConfirmationRequest, set3, n);
    }

    private final String component1() {
        return this.user;
    }

    private final PersistedMessageType component2() {
        return this.type;
    }

    private final PersistedAgent component3() {
        return this.agent;
    }

    @NotNull
    public final PersistedMessageBuilder copy(@NotNull String user, @NotNull PersistedMessageType type, @Nullable PersistedAgent agent) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return new PersistedMessageBuilder(user, type, agent);
    }

    public static /* synthetic */ PersistedMessageBuilder copy$default(PersistedMessageBuilder persistedMessageBuilder, String string, PersistedMessageType persistedMessageType, PersistedAgent persistedAgent, int n, Object object) {
        if ((n & 1) != 0) {
            string = persistedMessageBuilder.user;
        }
        if ((n & 2) != 0) {
            persistedMessageType = persistedMessageBuilder.type;
        }
        if ((n & 4) != 0) {
            persistedAgent = persistedMessageBuilder.agent;
        }
        return persistedMessageBuilder.copy(string, persistedMessageType, persistedAgent);
    }

    @NotNull
    public String toString() {
        return "PersistedMessageBuilder(user=" + this.user + ", type=" + this.type + ", agent=" + this.agent + ")";
    }

    public int hashCode() {
        int result = this.user.hashCode();
        result = result * 31 + this.type.hashCode();
        result = result * 31 + (this.agent == null ? 0 : this.agent.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PersistedMessageBuilder)) {
            return false;
        }
        PersistedMessageBuilder persistedMessageBuilder = (PersistedMessageBuilder)other;
        if (!Intrinsics.areEqual((Object)this.user, (Object)persistedMessageBuilder.user)) {
            return false;
        }
        if (this.type != persistedMessageBuilder.type) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.agent, (Object)persistedMessageBuilder.agent);
    }
}

