/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.session.persistence;

import com.github.copilot.chat.agent.RemoteAgent;
import com.github.copilot.chat.conversation.agent.rpc.ChatAnnotation;
import com.github.copilot.chat.conversation.agent.rpc.ChatAnnotationDetails;
import com.github.copilot.chat.conversation.agent.rpc.ChatNotification;
import com.github.copilot.chat.conversation.agent.rpc.ConfirmationRequest;
import com.github.copilot.chat.conversation.agent.rpc.ConfirmationResponse;
import com.github.copilot.chat.conversation.agent.rpc.message.Step;
import com.github.copilot.chat.conversation.agent.rpc.message.StepError;
import com.github.copilot.chat.message.ChatMessage;
import com.github.copilot.chat.message.ChatMessageRating;
import com.github.copilot.chat.message.ChatMessageStatus;
import com.github.copilot.chat.message.ChatMessageType;
import com.github.copilot.chat.message.references.ChatReference;
import com.github.copilot.chat.message.references.FileChatReference;
import com.github.copilot.chat.message.references.FileChatReferencePosition;
import com.github.copilot.chat.message.references.FileChatReferenceRange;
import com.github.copilot.chat.message.references.WebSearchChatReference;
import com.github.copilot.chat.session.ChatSession;
import com.github.copilot.chat.session.ChatSessionName;
import com.github.copilot.chat.session.ChatSessionNameSource;
import com.github.copilot.chat.session.InputHistory;
import com.github.copilot.chat.session.persistence.Client;
import com.github.copilot.chat.session.persistence.PersistedAgent;
import com.github.copilot.chat.session.persistence.PersistedChatSession;
import com.github.copilot.chat.session.persistence.PersistedChatSessionName;
import com.github.copilot.chat.session.persistence.PersistedChatSessionNameSource;
import com.github.copilot.chat.session.persistence.PersistedConfirmationRequest;
import com.github.copilot.chat.session.persistence.PersistedConfirmationResponse;
import com.github.copilot.chat.session.persistence.PersistedFileReference;
import com.github.copilot.chat.session.persistence.PersistedFileReferencePosition;
import com.github.copilot.chat.session.persistence.PersistedFileReferenceRange;
import com.github.copilot.chat.session.persistence.PersistedMessage;
import com.github.copilot.chat.session.persistence.PersistedMessageAnnotation;
import com.github.copilot.chat.session.persistence.PersistedMessageAnnotationDetails;
import com.github.copilot.chat.session.persistence.PersistedMessageStatus;
import com.github.copilot.chat.session.persistence.PersistedMessageType;
import com.github.copilot.chat.session.persistence.PersistedNotification;
import com.github.copilot.chat.session.persistence.PersistedReference;
import com.github.copilot.chat.session.persistence.PersistedStep;
import com.github.copilot.chat.session.persistence.PersistedStepError;
import com.github.copilot.chat.session.persistence.PersistedTurn;
import com.github.copilot.chat.session.persistence.PersistedWebSearchReference;
import com.github.copilot.chat.session.persistence.SortOrder;
import com.github.copilot.chat.session.persistence.TurnsBuilder;
import com.github.copilot.chat.user.GitHubUser;
import com.github.copilot.chat.user.Users;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u00a0\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\b\b\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u001a\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000f\u001a\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\b\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u0007\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0013\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0019\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u001c\u001a\u001e\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u001f0\u001ej\u0002` *\f\u0012\u0004\u0012\u00020!0\u0011j\u0002`\"\u001a\n\u0010#\u001a\u00020\u001f*\u00020!\u001a\n\u0010$\u001a\u00020%*\u00020&\u001a\n\u0010'\u001a\u00020(*\u00020)\u001a\n\u0010*\u001a\u00020+*\u00020,\u001a\n\u0010-\u001a\u00020.*\u00020/\u001a3\u00100\u001a\b\u0012\u0004\u0012\u0002010\u001e*\b\u0012\u0004\u0012\u0002020\u00112\n\b\u0002\u00103\u001a\u0004\u0018\u0001042\n\b\u0002\u00105\u001a\u0004\u0018\u000104\u00a2\u0006\u0002\u00106\u001a\n\u00107\u001a\u000208*\u000209\u001a\n\u0010:\u001a\u00020;*\u00020<\u001a\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u001e*\b\u0012\u0004\u0012\u00020?0\u0011\u001a\n\u0010@\u001a\u00020>*\u00020?\u001a\u001e\u0010A\u001a\u000201*\u0002022\b\b\u0002\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u000204\u001a\n\u0010B\u001a\u00020C*\u00020D\u001a\n\u0010E\u001a\u00020F*\u00020G\u001a\u0012\u0010H\u001a\u00020\u0005*\u00020\u00042\u0006\u0010I\u001a\u00020J\u001a\n\u0010K\u001a\u00020\f*\u00020\u000b\u001a\n\u0010L\u001a\u00020\u000f*\u00020\u000e\u001a\u0010\u0010M\u001a\u00020N*\b\u0012\u0004\u0012\u00020\u00120\u0011\u001a(\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00130\u0011*\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010I\u001a\u00020J2\b\b\u0002\u0010P\u001a\u00020J\u001aH\u0010Q\u001a\u00020\u0013*\u00020\u00162\u0006\u0010I\u001a\u00020J2\b\u0010R\u001a\u0004\u0018\u00010\u00072\u0006\u0010S\u001a\u00020T2\b\u0010U\u001a\u0004\u0018\u00010T2\b\b\u0002\u0010V\u001a\u0002042\u000e\b\u0002\u0010W\u001a\b\u0012\u0004\u0012\u00020X0\u0011\u001a\n\u0010Y\u001a\u00020Z*\u00020X\u001a\n\u0010[\u001a\u00020\\*\u00020]\u001a\n\u0010^\u001a\u00020\u0019*\u00020\u0018\u001a\n\u0010_\u001a\u00020\u001c*\u00020\u001b\u001a\u001e\u0010`\u001a\f\u0012\u0004\u0012\u00020!0\u0011j\u0002`\"*\f\u0012\u0004\u0012\u00020\u001f0\u001ej\u0002` \u001a\n\u0010a\u001a\u00020!*\u00020\u001f\u001a\n\u0010b\u001a\u00020&*\u00020%\u001a\n\u0010c\u001a\u00020)*\u00020(\u001a\n\u0010d\u001a\u00020,*\u00020+\u001a\n\u0010e\u001a\u00020/*\u00020.\u001a\u0016\u0010f\u001a\b\u0012\u0004\u0012\u0002020g*\b\u0012\u0004\u0012\u0002010\u001e\u001a\u0016\u0010h\u001a\b\u0012\u0004\u0012\u00020?0g*\b\u0012\u0004\u0012\u00020>0\u001e\u001a\n\u0010i\u001a\u000202*\u000201\u001a\n\u0010j\u001a\u00020D*\u00020C\u001a\n\u0010k\u001a\u00020?*\u00020>\u001a\n\u0010l\u001a\u00020G*\u00020F\u001a\n\u0010m\u001a\u00020<*\u00020;\u001a\n\u0010n\u001a\u000209*\u000208\u00a8\u0006o"}, d2={"isAscending", "", "Lcom/github/copilot/chat/session/persistence/SortOrder;", "toPersistedChatSession", "Lcom/github/copilot/chat/session/persistence/PersistedChatSession;", "Lcom/github/copilot/chat/session/ChatSession;", "projectName", "", "client", "Lcom/github/copilot/chat/session/persistence/Client;", "toPersistedChatSessionName", "Lcom/github/copilot/chat/session/persistence/PersistedChatSessionName;", "Lcom/github/copilot/chat/session/ChatSessionName;", "toPersistedChatSessionNameSource", "Lcom/github/copilot/chat/session/persistence/PersistedChatSessionNameSource;", "Lcom/github/copilot/chat/session/ChatSessionNameSource;", "toPersistedTurns", "", "Lcom/github/copilot/chat/session/persistence/PersistedTurn;", "Lcom/github/copilot/chat/message/ChatMessage;", "sessionId", "toPersistedMessage", "Lcom/github/copilot/chat/session/persistence/PersistedMessage;", "toPersistedMessageType", "Lcom/github/copilot/chat/session/persistence/PersistedMessageType;", "Lcom/github/copilot/chat/message/ChatMessageType;", "toPersistedMessageStatus", "Lcom/github/copilot/chat/session/persistence/PersistedMessageStatus;", "Lcom/github/copilot/chat/message/ChatMessageStatus;", "toPersistedReferences", "", "Lcom/github/copilot/chat/session/persistence/PersistedReference;", "Lcom/github/copilot/chat/session/persistence/PersistedReferences;", "Lcom/github/copilot/chat/message/references/ChatReference;", "Lcom/github/copilot/chat/message/references/ChatReferences;", "toPersistedReference", "toPersistedFileReference", "Lcom/github/copilot/chat/session/persistence/PersistedFileReference;", "Lcom/github/copilot/chat/message/references/FileChatReference;", "toPersistedFileReferenceRange", "Lcom/github/copilot/chat/session/persistence/PersistedFileReferenceRange;", "Lcom/github/copilot/chat/message/references/FileChatReferenceRange;", "toPersistedFileReferencePosition", "Lcom/github/copilot/chat/session/persistence/PersistedFileReferencePosition;", "Lcom/github/copilot/chat/message/references/FileChatReferencePosition;", "toPersistedWebSearchReference", "Lcom/github/copilot/chat/session/persistence/PersistedWebSearchReference;", "Lcom/github/copilot/chat/message/references/WebSearchChatReference;", "toPersistedMessageAnnotations", "Lcom/github/copilot/chat/session/persistence/PersistedMessageAnnotation;", "Lcom/github/copilot/chat/conversation/agent/rpc/ChatAnnotation;", "startOffset", "", "stopOffset", "(Ljava/util/List;Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/util/Set;", "toPersistedConfirmationResponse", "Lcom/github/copilot/chat/session/persistence/PersistedConfirmationResponse;", "Lcom/github/copilot/chat/conversation/agent/rpc/ConfirmationResponse;", "toPersistedConfirmationRequest", "Lcom/github/copilot/chat/session/persistence/PersistedConfirmationRequest;", "Lcom/github/copilot/chat/conversation/agent/rpc/ConfirmationRequest;", "toPersistedNotifications", "Lcom/github/copilot/chat/session/persistence/PersistedNotification;", "Lcom/github/copilot/chat/conversation/agent/rpc/ChatNotification;", "toPersistedNotification", "toPersistedMessageAnnotation", "toPersistedMessageAnnotationDetails", "Lcom/github/copilot/chat/session/persistence/PersistedMessageAnnotationDetails;", "Lcom/github/copilot/chat/conversation/agent/rpc/ChatAnnotationDetails;", "toPersistedAgent", "Lcom/github/copilot/chat/session/persistence/PersistedAgent;", "Lcom/github/copilot/chat/agent/RemoteAgent;", "toChatSession", "user", "Lcom/github/copilot/chat/user/GitHubUser;", "toChatSessionName", "toChatSessionNameSource", "toHistory", "Lcom/github/copilot/chat/session/InputHistory;", "toChatMessages", "copilotUser", "toChatMessage", "turnId", "createdAt", "Lkotlinx/datetime/Instant;", "deletedAt", "rating", "steps", "Lcom/github/copilot/chat/session/persistence/PersistedStep;", "toChatStep", "Lcom/github/copilot/chat/conversation/agent/rpc/message/Step;", "toChatStepError", "Lcom/github/copilot/chat/conversation/agent/rpc/message/StepError;", "Lcom/github/copilot/chat/session/persistence/PersistedStepError;", "toChatMessageType", "toChatMessageStatus", "toChatReferences", "toChatReference", "toFileChatReference", "toFileChatReferenceRange", "toFileChatReferencePosition", "toWebSearchChatReference", "toChatAnnotations", "", "toChatNotifications", "toChatAnnotation", "toChatAnnotationDetails", "toChatNotification", "toRemoteAgent", "toConfirmationRequest", "toConfirmationResponse", "core"})
@SourceDebugExtension(value={"SMAP\nPersistenceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistenceUtils.kt\ncom/github/copilot/chat/session/persistence/PersistenceUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,403:1\n1855#2,2:404\n1549#2:406\n1620#2,3:407\n1549#2:410\n1620#2,3:411\n1549#2:414\n1620#2,3:415\n1549#2:419\n1620#2,3:420\n1855#2,2:423\n1549#2:425\n1620#2,3:426\n1194#2,2:429\n1222#2,4:431\n1549#2:435\n1620#2,3:436\n1549#2:439\n1620#2,3:440\n1549#2:443\n1620#2,3:444\n1#3:418\n*S KotlinDebug\n*F\n+ 1 PersistenceUtils.kt\ncom/github/copilot/chat/session/persistence/PersistenceUtilsKt\n*L\n60#1:404,2\n98#1:406\n98#1:407,3\n125#1:410\n125#1:411,3\n146#1:414\n146#1:415,3\n250#1:419\n250#1:420,3\n256#1:423,2\n302#1:425\n302#1:426,3\n302#1:429,2\n302#1:431,4\n335#1:435\n335#1:436,3\n359#1:439\n359#1:440,3\n361#1:443\n361#1:444,3\n*E\n"})
public final class PersistenceUtilsKt {
    public static final boolean isAscending(@NotNull SortOrder $this$isAscending) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isAscending), (String)"<this>");
        return $this$isAscending == SortOrder.ASCENDING;
    }

    @NotNull
    public static final PersistedChatSession toPersistedChatSession(@NotNull ChatSession $this$toPersistedChatSession, @NotNull String projectName, @NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)$this$toPersistedChatSession, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return new PersistedChatSession($this$toPersistedChatSession.getId(), PersistenceUtilsKt.toPersistedChatSessionName($this$toPersistedChatSession.getName()), projectName, $this$toPersistedChatSession.getUser().getName(), $this$toPersistedChatSession.getCreatedAt(), $this$toPersistedChatSession.getActiveAt(), $this$toPersistedChatSession.getModifiedAt(), client, $this$toPersistedChatSession.getInput(), PersistenceUtilsKt.toPersistedTurns($this$toPersistedChatSession.getMessages(), $this$toPersistedChatSession.getId()));
    }

    @NotNull
    public static final PersistedChatSessionName toPersistedChatSessionName(@NotNull ChatSessionName $this$toPersistedChatSessionName) {
        Intrinsics.checkNotNullParameter((Object)$this$toPersistedChatSessionName, (String)"<this>");
        return new PersistedChatSessionName($this$toPersistedChatSessionName.getValue(), PersistenceUtilsKt.toPersistedChatSessionNameSource($this$toPersistedChatSessionName.getSource()));
    }

    @NotNull
    public static final PersistedChatSessionNameSource toPersistedChatSessionNameSource(@NotNull ChatSessionNameSource $this$toPersistedChatSessionNameSource) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toPersistedChatSessionNameSource), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toPersistedChatSessionNameSource.ordinal()]) {
            case 1 -> PersistedChatSessionNameSource.USER;
            case 2 -> PersistedChatSessionNameSource.COPILOT;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final List<PersistedTurn> toPersistedTurns(@NotNull List<ChatMessage> $this$toPersistedTurns, @NotNull String sessionId) {
        Intrinsics.checkNotNullParameter($this$toPersistedTurns, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        TurnsBuilder turnsBuilder = new TurnsBuilder(sessionId);
        Iterable $this$forEach$iv = $this$toPersistedTurns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatMessage msg = (ChatMessage)element$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$1[msg.getType().ordinal()]) {
                case 1: {
                    turnsBuilder.addRequest(msg);
                    break;
                }
                case 2: {
                    turnsBuilder.addResponse(msg);
                    break;
                }
                default: {
                }
            }
        }
        return turnsBuilder.build();
    }

    @NotNull
    public static final PersistedMessage toPersistedMessage(@NotNull ChatMessage $this$toPersistedMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$toPersistedMessage, (String)"<this>");
        Object object = $this$toPersistedMessage.getUser();
        if (object == null || (object = ((GitHubUser)object).getName()) == null) {
            object = "";
        }
        RemoteAgent remoteAgent = $this$toPersistedMessage.getAgent();
        ConfirmationResponse confirmationResponse = $this$toPersistedMessage.getConfirmationResponse();
        ConfirmationRequest confirmationRequest = $this$toPersistedMessage.getConfirmationRequest();
        Integer n = $this$toPersistedMessage.getErrorCode();
        return new PersistedMessage((String)object, PersistenceUtilsKt.toPersistedMessageType($this$toPersistedMessage.getType()), PersistenceUtilsKt.toPersistedMessageStatus($this$toPersistedMessage.getStatus()), $this$toPersistedMessage.getContent(), PersistenceUtilsKt.toPersistedReferences($this$toPersistedMessage.getReferences()), PersistenceUtilsKt.toPersistedMessageAnnotations$default($this$toPersistedMessage.getAnnotations(), null, null, 3, null), remoteAgent != null ? PersistenceUtilsKt.toPersistedAgent(remoteAgent) : null, confirmationResponse != null ? PersistenceUtilsKt.toPersistedConfirmationResponse(confirmationResponse) : null, confirmationRequest != null ? PersistenceUtilsKt.toPersistedConfirmationRequest(confirmationRequest) : null, PersistenceUtilsKt.toPersistedNotifications($this$toPersistedMessage.getNotifications()), n != null ? n : 0);
    }

    @NotNull
    public static final PersistedMessageType toPersistedMessageType(@NotNull ChatMessageType $this$toPersistedMessageType) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toPersistedMessageType), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$toPersistedMessageType.ordinal()]) {
            case 3 -> PersistedMessageType.WELCOME;
            case 1 -> PersistedMessageType.QUERY;
            case 2 -> PersistedMessageType.RESPONSE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final PersistedMessageStatus toPersistedMessageStatus(@NotNull ChatMessageStatus $this$toPersistedMessageStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toPersistedMessageStatus), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$2[$this$toPersistedMessageStatus.ordinal()]) {
            case 1 -> PersistedMessageStatus.OK;
            case 2 -> PersistedMessageStatus.ERROR;
            case 3 -> PersistedMessageStatus.FILTERED;
            case 4 -> PersistedMessageStatus.CANCELLED;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<PersistedReference> toPersistedReferences(@NotNull List<? extends ChatReference> $this$toPersistedReferences) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toPersistedReferences, (String)"<this>");
        Iterable $this$map$iv = $this$toPersistedReferences;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChatReference chatReference = (ChatReference)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PersistenceUtilsKt.toPersistedReference((ChatReference)it));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final PersistedReference toPersistedReference(@NotNull ChatReference $this$toPersistedReference) {
        PersistedReference persistedReference;
        Intrinsics.checkNotNullParameter((Object)$this$toPersistedReference, (String)"<this>");
        ChatReference chatReference = $this$toPersistedReference;
        if (chatReference instanceof FileChatReference) {
            persistedReference = PersistenceUtilsKt.toPersistedFileReference((FileChatReference)$this$toPersistedReference);
        } else if (chatReference instanceof WebSearchChatReference) {
            persistedReference = PersistenceUtilsKt.toPersistedWebSearchReference((WebSearchChatReference)$this$toPersistedReference);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return persistedReference;
    }

    @NotNull
    public static final PersistedFileReference toPersistedFileReference(@NotNull FileChatReference $this$toPersistedFileReference) {
        Intrinsics.checkNotNullParameter((Object)$this$toPersistedFileReference, (String)"<this>");
        FileChatReferenceRange fileChatReferenceRange = $this$toPersistedFileReference.getRange();
        return new PersistedFileReference($this$toPersistedFileReference.getUri(), fileChatReferenceRange != null ? PersistenceUtilsKt.toPersistedFileReferenceRange(fileChatReferenceRange) : null);
    }

    @NotNull
    public static final PersistedFileReferenceRange toPersistedFileReferenceRange(@NotNull FileChatReferenceRange $this$toPersistedFileReferenceRange) {
        Intrinsics.checkNotNullParameter((Object)$this$toPersistedFileReferenceRange, (String)"<this>");
        return new PersistedFileReferenceRange(PersistenceUtilsKt.toPersistedFileReferencePosition($this$toPersistedFileReferenceRange.getStart()), PersistenceUtilsKt.toPersistedFileReferencePosition($this$toPersistedFileReferenceRange.getEnd()));
    }

    @NotNull
    public static final PersistedFileReferencePosition toPersistedFileReferencePosition(@NotNull FileChatReferencePosition $this$toPersistedFileReferencePosition) {
        Intrinsics.checkNotNullParameter((Object)$this$toPersistedFileReferencePosition, (String)"<this>");
        return new PersistedFileReferencePosition($this$toPersistedFileReferencePosition.getLine(), $this$toPersistedFileReferencePosition.getCharacter());
    }

    @NotNull
    public static final PersistedWebSearchReference toPersistedWebSearchReference(@NotNull WebSearchChatReference $this$toPersistedWebSearchReference) {
        Intrinsics.checkNotNullParameter((Object)$this$toPersistedWebSearchReference, (String)"<this>");
        return new PersistedWebSearchReference($this$toPersistedWebSearchReference.getUrl());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<PersistedMessageAnnotation> toPersistedMessageAnnotations(@NotNull List<ChatAnnotation> $this$toPersistedMessageAnnotations, @Nullable Integer startOffset, @Nullable Integer stopOffset) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toPersistedMessageAnnotations, (String)"<this>");
        Iterable $this$map$iv = $this$toPersistedMessageAnnotations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChatAnnotation chatAnnotation = (ChatAnnotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = startOffset;
            Integer n2 = stopOffset;
            collection.add(PersistenceUtilsKt.toPersistedMessageAnnotation((ChatAnnotation)it, n != null ? n.intValue() : it.getStartOffset(), n2 != null ? n2.intValue() : it.getStopOffset()));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public static /* synthetic */ Set toPersistedMessageAnnotations$default(List list, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = null;
        }
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        return PersistenceUtilsKt.toPersistedMessageAnnotations(list, n, n2);
    }

    @NotNull
    public static final PersistedConfirmationResponse toPersistedConfirmationResponse(@NotNull ConfirmationResponse $this$toPersistedConfirmationResponse) {
        Intrinsics.checkNotNullParameter((Object)$this$toPersistedConfirmationResponse, (String)"<this>");
        String string = $this$toPersistedConfirmationResponse.getAgentSlug();
        String string2 = $this$toPersistedConfirmationResponse.getState();
        String string3 = new Gson().toJson($this$toPersistedConfirmationResponse.getConfirmation());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toJson(...)");
        return new PersistedConfirmationResponse(string, string2, string3);
    }

    @NotNull
    public static final PersistedConfirmationRequest toPersistedConfirmationRequest(@NotNull ConfirmationRequest $this$toPersistedConfirmationRequest) {
        Intrinsics.checkNotNullParameter((Object)$this$toPersistedConfirmationRequest, (String)"<this>");
        String string = $this$toPersistedConfirmationRequest.getAgentSlug();
        String string2 = $this$toPersistedConfirmationRequest.getType();
        String string3 = $this$toPersistedConfirmationRequest.getTitle();
        String string4 = $this$toPersistedConfirmationRequest.getMessage();
        String string5 = new Gson().toJson($this$toPersistedConfirmationRequest.getConfirmation());
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toJson(...)");
        return new PersistedConfirmationRequest(string, string2, string3, string4, string5);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<PersistedNotification> toPersistedNotifications(@NotNull List<ChatNotification> $this$toPersistedNotifications) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toPersistedNotifications, (String)"<this>");
        Iterable $this$map$iv = $this$toPersistedNotifications;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChatNotification chatNotification = (ChatNotification)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PersistenceUtilsKt.toPersistedNotification((ChatNotification)it));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final PersistedNotification toPersistedNotification(@NotNull ChatNotification $this$toPersistedNotification) {
        Intrinsics.checkNotNullParameter((Object)$this$toPersistedNotification, (String)"<this>");
        return new PersistedNotification($this$toPersistedNotification.getSeverity(), $this$toPersistedNotification.getMessage());
    }

    @NotNull
    public static final PersistedMessageAnnotation toPersistedMessageAnnotation(@NotNull ChatAnnotation $this$toPersistedMessageAnnotation, int startOffset, int stopOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$toPersistedMessageAnnotation, (String)"<this>");
        ChatAnnotationDetails chatAnnotationDetails = $this$toPersistedMessageAnnotation.getDetails();
        return new PersistedMessageAnnotation($this$toPersistedMessageAnnotation.getType(), $this$toPersistedMessageAnnotation.getId(), startOffset, stopOffset, chatAnnotationDetails != null ? PersistenceUtilsKt.toPersistedMessageAnnotationDetails(chatAnnotationDetails) : null);
    }

    public static /* synthetic */ PersistedMessageAnnotation toPersistedMessageAnnotation$default(ChatAnnotation chatAnnotation, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = chatAnnotation.getStartOffset();
        }
        if ((n3 & 2) != 0) {
            n2 = chatAnnotation.getStopOffset();
        }
        return PersistenceUtilsKt.toPersistedMessageAnnotation(chatAnnotation, n, n2);
    }

    @NotNull
    public static final PersistedMessageAnnotationDetails toPersistedMessageAnnotationDetails(@NotNull ChatAnnotationDetails $this$toPersistedMessageAnnotationDetails) {
        Intrinsics.checkNotNullParameter((Object)$this$toPersistedMessageAnnotationDetails, (String)"<this>");
        return new PersistedMessageAnnotationDetails($this$toPersistedMessageAnnotationDetails.getType(), $this$toPersistedMessageAnnotationDetails.getDescription(), $this$toPersistedMessageAnnotationDetails.getUiType(), $this$toPersistedMessageAnnotationDetails.getUiDescription());
    }

    @NotNull
    public static final PersistedAgent toPersistedAgent(@NotNull RemoteAgent $this$toPersistedAgent) {
        Intrinsics.checkNotNullParameter((Object)$this$toPersistedAgent, (String)"<this>");
        return new PersistedAgent($this$toPersistedAgent.getSlug(), $this$toPersistedAgent.getName(), $this$toPersistedAgent.getDescription(), $this$toPersistedAgent.getAvatarUrl());
    }

    @NotNull
    public static final ChatSession toChatSession(@NotNull PersistedChatSession $this$toChatSession, @NotNull GitHubUser user) {
        Intrinsics.checkNotNullParameter((Object)$this$toChatSession, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Object object = $this$toChatSession.getId();
        ChatSessionName chatSessionName = PersistenceUtilsKt.toChatSessionName($this$toChatSession.getName());
        Instant instant = $this$toChatSession.getCreatedAt();
        Instant instant2 = $this$toChatSession.getActiveAt();
        Instant instant3 = $this$toChatSession.getModifiedAt();
        String string = $this$toChatSession.getInput();
        InputHistory inputHistory = PersistenceUtilsKt.toHistory($this$toChatSession.getTurns());
        Object $this$toChatSession_u24lambda_u244 = object = new ChatSession((String)object, null, user, instant, instant2, instant3, chatSessionName, null, string, inputHistory, null, false, 3202, null);
        boolean bl = false;
        ((ChatSession)$this$toChatSession_u24lambda_u244).getMessages().addAll(PersistenceUtilsKt.toChatMessages$default($this$toChatSession.getTurns(), user, null, 2, null));
        return object;
    }

    @NotNull
    public static final ChatSessionName toChatSessionName(@NotNull PersistedChatSessionName $this$toChatSessionName) {
        Intrinsics.checkNotNullParameter((Object)$this$toChatSessionName, (String)"<this>");
        return new ChatSessionName($this$toChatSessionName.getValue(), PersistenceUtilsKt.toChatSessionNameSource($this$toChatSessionName.getSource()));
    }

    @NotNull
    public static final ChatSessionNameSource toChatSessionNameSource(@NotNull PersistedChatSessionNameSource $this$toChatSessionNameSource) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toChatSessionNameSource), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$3[$this$toChatSessionNameSource.ordinal()]) {
            case 1 -> ChatSessionNameSource.USER;
            case 2 -> ChatSessionNameSource.COPILOT;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final InputHistory toHistory(@NotNull List<PersistedTurn> $this$toHistory) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toHistory, (String)"<this>");
        Iterable $this$map$iv = $this$toHistory;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PersistedTurn persistedTurn = (PersistedTurn)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getRequest().getContent());
        }
        List list = (List)destination$iv$iv;
        return new InputHistory(list);
    }

    @NotNull
    public static final List<ChatMessage> toChatMessages(@NotNull List<PersistedTurn> $this$toChatMessages, @NotNull GitHubUser user, @NotNull GitHubUser copilotUser) {
        Intrinsics.checkNotNullParameter($this$toChatMessages, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)copilotUser, (String)"copilotUser");
        List messages = new ArrayList();
        Iterable $this$forEach$iv = $this$toChatMessages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PersistedTurn turn = (PersistedTurn)element$iv;
            boolean bl = false;
            messages.add(PersistenceUtilsKt.toChatMessage$default(turn.getRequest(), user, turn.getId(), turn.getCreatedAt(), turn.getDeletedAt(), 0, null, 48, null));
            if (turn.getResponse() == null) continue;
            boolean bl2 = false;
            messages.add(PersistenceUtilsKt.toChatMessage(turn.getResponse(), copilotUser, turn.getId(), turn.getCreatedAt(), turn.getDeletedAt(), turn.getRating(), turn.getSteps()));
        }
        return messages;
    }

    public static /* synthetic */ List toChatMessages$default(List list, GitHubUser gitHubUser, GitHubUser gitHubUser2, int n, Object object) {
        if ((n & 2) != 0) {
            gitHubUser2 = Users.INSTANCE.getCopilotUser();
        }
        return PersistenceUtilsKt.toChatMessages(list, gitHubUser, gitHubUser2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ChatMessage toChatMessage(@NotNull PersistedMessage $this$toChatMessage, @NotNull GitHubUser user, @Nullable String turnId, @NotNull Instant createdAt, @Nullable Instant deletedAt, int rating, @NotNull List<PersistedStep> steps) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toChatMessage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
        Intrinsics.checkNotNullParameter(steps, (String)"steps");
        ChatMessageType chatMessageType = PersistenceUtilsKt.toChatMessageType($this$toChatMessage.getType());
        ChatMessageStatus chatMessageStatus = PersistenceUtilsKt.toChatMessageStatus($this$toChatMessage.getStatus());
        String string = $this$toChatMessage.getContent();
        List<ChatReference> list = PersistenceUtilsKt.toChatReferences($this$toChatMessage.getReferences());
        List<ChatAnnotation> list2 = PersistenceUtilsKt.toChatAnnotations($this$toChatMessage.getAnnotations());
        ChatMessageRating chatMessageRating = ChatMessageRating.Companion.fromValue(rating);
        Iterable $this$map$iv = steps;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PersistedStep persistedStep = (PersistedStep)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(PersistenceUtilsKt.toChatStep((PersistedStep)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Step bl = (Step)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.put(it.getId(), element$iv$iv);
        }
        Map map = MapsKt.toMutableMap((Map)destination$iv$iv2);
        PersistedAgent persistedAgent = $this$toChatMessage.getAgent();
        RemoteAgent remoteAgent = persistedAgent != null ? PersistenceUtilsKt.toRemoteAgent(persistedAgent) : null;
        PersistedConfirmationRequest persistedConfirmationRequest = $this$toChatMessage.getConfirmationRequest();
        ConfirmationRequest confirmationRequest = persistedConfirmationRequest != null ? PersistenceUtilsKt.toConfirmationRequest(persistedConfirmationRequest) : null;
        PersistedConfirmationResponse persistedConfirmationResponse = $this$toChatMessage.getConfirmationResponse();
        ConfirmationResponse confirmationResponse = persistedConfirmationResponse != null ? PersistenceUtilsKt.toConfirmationResponse(persistedConfirmationResponse) : null;
        List<ChatNotification> list3 = PersistenceUtilsKt.toChatNotifications($this$toChatMessage.getNotifications());
        Integer n = $this$toChatMessage.getErrorCode();
        int n2 = n != null ? n : 0;
        return new ChatMessage(chatMessageType, user, string, n2, createdAt, deletedAt, chatMessageRating, null, list, list2, null, map, turnId, chatMessageStatus, remoteAgent, null, null, confirmationRequest, confirmationResponse, null, list3, 623744, null);
    }

    public static /* synthetic */ ChatMessage toChatMessage$default(PersistedMessage persistedMessage, GitHubUser gitHubUser, String string, Instant instant, Instant instant2, int n, List list, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        if ((n2 & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        return PersistenceUtilsKt.toChatMessage(persistedMessage, gitHubUser, string, instant, instant2, n, list);
    }

    @NotNull
    public static final Step toChatStep(@NotNull PersistedStep $this$toChatStep) {
        Intrinsics.checkNotNullParameter((Object)$this$toChatStep, (String)"<this>");
        String string = $this$toChatStep.getId();
        String string2 = $this$toChatStep.getStatus();
        String string3 = $this$toChatStep.getTitle();
        String string4 = $this$toChatStep.getDescription();
        PersistedStepError persistedStepError = $this$toChatStep.getError();
        StepError stepError = persistedStepError != null ? PersistenceUtilsKt.toChatStepError(persistedStepError) : null;
        return new Step(string, string3, string4, string2, stepError);
    }

    @NotNull
    public static final StepError toChatStepError(@NotNull PersistedStepError $this$toChatStepError) {
        Intrinsics.checkNotNullParameter((Object)$this$toChatStepError, (String)"<this>");
        return new StepError($this$toChatStepError.getMessage());
    }

    @NotNull
    public static final ChatMessageType toChatMessageType(@NotNull PersistedMessageType $this$toChatMessageType) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toChatMessageType), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$4[$this$toChatMessageType.ordinal()]) {
            case 1 -> ChatMessageType.WELCOME;
            case 2 -> ChatMessageType.QUERY;
            case 3 -> ChatMessageType.RESPONSE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final ChatMessageStatus toChatMessageStatus(@NotNull PersistedMessageStatus $this$toChatMessageStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toChatMessageStatus), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$5[$this$toChatMessageStatus.ordinal()]) {
            case 1 -> ChatMessageStatus.OK;
            case 2 -> ChatMessageStatus.ERROR;
            case 3 -> ChatMessageStatus.FILTERED;
            case 4 -> ChatMessageStatus.CANCELLED;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ChatReference> toChatReferences(@NotNull Set<? extends PersistedReference> $this$toChatReferences) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toChatReferences, (String)"<this>");
        Iterable $this$map$iv = $this$toChatReferences;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PersistedReference persistedReference = (PersistedReference)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PersistenceUtilsKt.toChatReference((PersistedReference)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final ChatReference toChatReference(@NotNull PersistedReference $this$toChatReference) {
        ChatReference chatReference;
        Intrinsics.checkNotNullParameter((Object)$this$toChatReference, (String)"<this>");
        PersistedReference persistedReference = $this$toChatReference;
        if (persistedReference instanceof PersistedFileReference) {
            chatReference = PersistenceUtilsKt.toFileChatReference((PersistedFileReference)$this$toChatReference);
        } else if (persistedReference instanceof PersistedWebSearchReference) {
            chatReference = PersistenceUtilsKt.toWebSearchChatReference((PersistedWebSearchReference)$this$toChatReference);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return chatReference;
    }

    @NotNull
    public static final FileChatReference toFileChatReference(@NotNull PersistedFileReference $this$toFileChatReference) {
        Intrinsics.checkNotNullParameter((Object)$this$toFileChatReference, (String)"<this>");
        PersistedFileReferenceRange persistedFileReferenceRange = $this$toFileChatReference.getRange();
        return new FileChatReference($this$toFileChatReference.getUri(), persistedFileReferenceRange != null ? PersistenceUtilsKt.toFileChatReferenceRange(persistedFileReferenceRange) : null);
    }

    @NotNull
    public static final FileChatReferenceRange toFileChatReferenceRange(@NotNull PersistedFileReferenceRange $this$toFileChatReferenceRange) {
        Intrinsics.checkNotNullParameter((Object)$this$toFileChatReferenceRange, (String)"<this>");
        return new FileChatReferenceRange(PersistenceUtilsKt.toFileChatReferencePosition($this$toFileChatReferenceRange.getStart()), PersistenceUtilsKt.toFileChatReferencePosition($this$toFileChatReferenceRange.getEnd()));
    }

    @NotNull
    public static final FileChatReferencePosition toFileChatReferencePosition(@NotNull PersistedFileReferencePosition $this$toFileChatReferencePosition) {
        Intrinsics.checkNotNullParameter((Object)$this$toFileChatReferencePosition, (String)"<this>");
        return new FileChatReferencePosition($this$toFileChatReferencePosition.getLine(), $this$toFileChatReferencePosition.getCharacter());
    }

    @NotNull
    public static final WebSearchChatReference toWebSearchChatReference(@NotNull PersistedWebSearchReference $this$toWebSearchChatReference) {
        Intrinsics.checkNotNullParameter((Object)$this$toWebSearchChatReference, (String)"<this>");
        return new WebSearchChatReference($this$toWebSearchChatReference.getUrl());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ChatAnnotation> toChatAnnotations(@NotNull Set<PersistedMessageAnnotation> $this$toChatAnnotations) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toChatAnnotations, (String)"<this>");
        Iterable $this$map$iv = $this$toChatAnnotations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PersistedMessageAnnotation persistedMessageAnnotation = (PersistedMessageAnnotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PersistenceUtilsKt.toChatAnnotation((PersistedMessageAnnotation)it));
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ChatNotification> toChatNotifications(@NotNull Set<PersistedNotification> $this$toChatNotifications) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toChatNotifications, (String)"<this>");
        Iterable $this$map$iv = $this$toChatNotifications;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PersistedNotification persistedNotification = (PersistedNotification)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PersistenceUtilsKt.toChatNotification((PersistedNotification)it));
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    @NotNull
    public static final ChatAnnotation toChatAnnotation(@NotNull PersistedMessageAnnotation $this$toChatAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$toChatAnnotation, (String)"<this>");
        PersistedMessageAnnotationDetails persistedMessageAnnotationDetails = $this$toChatAnnotation.getDetails();
        return new ChatAnnotation($this$toChatAnnotation.getType(), $this$toChatAnnotation.getId(), $this$toChatAnnotation.getStartOffset(), $this$toChatAnnotation.getStopOffset(), persistedMessageAnnotationDetails != null ? PersistenceUtilsKt.toChatAnnotationDetails(persistedMessageAnnotationDetails) : null);
    }

    @NotNull
    public static final ChatAnnotationDetails toChatAnnotationDetails(@NotNull PersistedMessageAnnotationDetails $this$toChatAnnotationDetails) {
        Intrinsics.checkNotNullParameter((Object)$this$toChatAnnotationDetails, (String)"<this>");
        return new ChatAnnotationDetails($this$toChatAnnotationDetails.getType(), $this$toChatAnnotationDetails.getDescription(), $this$toChatAnnotationDetails.getUiType(), $this$toChatAnnotationDetails.getUiDescription());
    }

    @NotNull
    public static final ChatNotification toChatNotification(@NotNull PersistedNotification $this$toChatNotification) {
        Intrinsics.checkNotNullParameter((Object)$this$toChatNotification, (String)"<this>");
        return new ChatNotification($this$toChatNotification.getSeverity(), $this$toChatNotification.getMessage());
    }

    @NotNull
    public static final RemoteAgent toRemoteAgent(@NotNull PersistedAgent $this$toRemoteAgent) {
        Intrinsics.checkNotNullParameter((Object)$this$toRemoteAgent, (String)"<this>");
        return new RemoteAgent($this$toRemoteAgent.getSlug(), $this$toRemoteAgent.getName(), $this$toRemoteAgent.getDescription(), $this$toRemoteAgent.getAvatarUrl());
    }

    @NotNull
    public static final ConfirmationRequest toConfirmationRequest(@NotNull PersistedConfirmationRequest $this$toConfirmationRequest) {
        Intrinsics.checkNotNullParameter((Object)$this$toConfirmationRequest, (String)"<this>");
        String string = $this$toConfirmationRequest.getAgentSlug();
        String string2 = $this$toConfirmationRequest.getType();
        String string3 = $this$toConfirmationRequest.getTitle();
        String string4 = $this$toConfirmationRequest.getMessage();
        Object object = new Gson().fromJson($this$toConfirmationRequest.getConfirmation(), Map.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return new ConfirmationRequest(string, string2, string3, string4, (Map)object);
    }

    @NotNull
    public static final ConfirmationResponse toConfirmationResponse(@NotNull PersistedConfirmationResponse $this$toConfirmationResponse) {
        Intrinsics.checkNotNullParameter((Object)$this$toConfirmationResponse, (String)"<this>");
        String string = $this$toConfirmationResponse.getAgentSlug();
        String string2 = $this$toConfirmationResponse.getState();
        Object object = new Gson().fromJson($this$toConfirmationResponse.getConfirmation(), Map.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return new ConfirmationResponse(string, string2, (Map)object);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;
        public static final /* synthetic */ int[] $EnumSwitchMapping$5;

        static {
            int[] nArray = new int[ChatSessionNameSource.values().length];
            try {
                nArray[ChatSessionNameSource.USER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatSessionNameSource.COPILOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ChatMessageType.values().length];
            try {
                nArray[ChatMessageType.QUERY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatMessageType.RESPONSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatMessageType.WELCOME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ChatMessageStatus.values().length];
            try {
                nArray[ChatMessageStatus.OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatMessageStatus.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatMessageStatus.FILTERED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatMessageStatus.CANCELLED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[PersistedChatSessionNameSource.values().length];
            try {
                nArray[PersistedChatSessionNameSource.USER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PersistedChatSessionNameSource.COPILOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[PersistedMessageType.values().length];
            try {
                nArray[PersistedMessageType.WELCOME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PersistedMessageType.QUERY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PersistedMessageType.RESPONSE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$4 = nArray;
            nArray = new int[PersistedMessageStatus.values().length];
            try {
                nArray[PersistedMessageStatus.OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PersistedMessageStatus.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PersistedMessageStatus.FILTERED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PersistedMessageStatus.CANCELLED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$5 = nArray;
        }
    }
}

