/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.session.persistence;

import com.github.copilot.chat.conversation.agent.CopilotAgentConversationClientKt;
import com.github.copilot.chat.conversation.agent.rpc.command.ConversationPersistenceResponse;
import com.github.copilot.chat.session.persistence.Project;
import com.github.copilot.chat.session.persistence.ProjectClosedSubscription;
import com.github.copilot.chat.session.persistence.ProjectKt;
import com.github.copilot.platform.utils.ApplicationKt;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.util.messages.MessageBusConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a|\u0010\u0000\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000e2\u0010\b\u0002\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\f2 \b\u0002\u0010\u0010\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110\u000e\u0012\u0004\u0012\u00020\u00120\u000e\u001a\r\u0010\u0013\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0014H\u0002\u001a\u001d\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\n0\n2\u0006\u0010\u0017\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0018\u001a\u001c\u0010\u0019\u001a\u00020\u00122\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110\u000eH\u0002\u001a\n\u0010\u001b\u001a\u0004\u0018\u00010\nH\u0002\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Project", "Lcom/github/copilot/chat/session/persistence/Project;", "platformProject", "Lcom/intellij/openapi/project/Project;", "log", "Lcom/github/copilot/platform/utils/observability/GitHubLogger;", "projectId", "", "projectName", "projectStoragePath", "Ljava/nio/file/Path;", "ideCode", "Lkotlin/Function0;", "createDirs", "Lkotlin/Function1;", "persistenceBasePath", "projectCloseListener", "", "Lcom/github/copilot/chat/session/persistence/ProjectClosedSubscription;", "defaultIdeCode", "Lorg/jetbrains/annotations/NotNull;", "defaultCreateDirs", "kotlin.jvm.PlatformType", "path", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;", "defaultProjectClosedListener", "onClose", "defaultPersistenceBasePath", "core"})
@SourceDebugExtension(value={"SMAP\nProject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Project.kt\ncom/github/copilot/chat/session/persistence/ProjectKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,121:1\n1#2:122\n39#3:123\n*S KotlinDebug\n*F\n+ 1 Project.kt\ncom/github/copilot/chat/session/persistence/ProjectKt\n*L\n40#1:123\n*E\n"})
public final class ProjectKt {
    @NotNull
    private static final GitHubLogger log;

    @NotNull
    public static final Project Project(@NotNull com.intellij.openapi.project.Project platformProject) {
        Intrinsics.checkNotNullParameter((Object)platformProject, (String)"platformProject");
        String string = com.github.copilot.platform.utils.ProjectKt.getId(platformProject);
        String string2 = platformProject.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return ProjectKt.Project$default(string, string2, com.github.copilot.platform.utils.ProjectKt.getIdeaDir(platformProject), null, null, null, null, 120, null);
    }

    @NotNull
    public static final Project Project(@Nullable String projectId, @NotNull String projectName, @Nullable Path projectStoragePath, @NotNull Function0<String> ideCode, @NotNull Function1<? super Path, ? extends Path> createDirs, @NotNull Function0<? extends Path> persistenceBasePath, @NotNull Function1<? super Function1<? super com.intellij.openapi.project.Project, Unit>, ? extends ProjectClosedSubscription> projectCloseListener) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter(ideCode, (String)"ideCode");
        Intrinsics.checkNotNullParameter(createDirs, (String)"createDirs");
        Intrinsics.checkNotNullParameter(persistenceBasePath, (String)"persistenceBasePath");
        Intrinsics.checkNotNullParameter(projectCloseListener, (String)"projectCloseListener");
        return new Project(projectId, projectName, projectStoragePath, projectCloseListener, persistenceBasePath, ideCode, createDirs){
            private final String id;
            private final String name;
            private final String persistenceId;
            private final Path oldPersistencePath;
            private final List<Function0<Unit>> projectCloseListeners;
            final /* synthetic */ Function0<Path> $persistenceBasePath;
            final /* synthetic */ Function0<String> $ideCode;
            final /* synthetic */ Function1<Path, Path> $createDirs;
            {
                Path path;
                this.$persistenceBasePath = $persistenceBasePath;
                this.$ideCode = $ideCode;
                this.$createDirs = $createDirs;
                this.id = $projectId;
                this.name = $projectName;
                String string = this.getId();
                if (string == null) {
                    string = this.getName();
                }
                this.persistenceId = string;
                Project.5 v1 = this;
                Path path2 = $projectStoragePath;
                if (path2 != null) {
                    void it;
                    Path path3 = path2;
                    Project.5 var12_9 = v1;
                    boolean bl = false;
                    String[] stringArray = new String[]{"copilot", "chatSessions"};
                    path = Paths.get(it.toString(), stringArray);
                    v1 = var12_9;
                } else {
                    path = null;
                }
                v1.oldPersistencePath = path;
                this.projectCloseListeners = new ArrayList<E>();
                Ref.ObjectRef projectClosedSubscription = new Ref.ObjectRef();
                projectClosedSubscription.element = $projectCloseListener.invoke(arg_0 -> Project.5._init_$lambda$2(this, projectClosedSubscription, arg_0));
            }

            public String getId() {
                return this.id;
            }

            public String getName() {
                return this.name;
            }

            public String getPersistenceId() {
                return this.persistenceId;
            }

            public Path getOldPersistencePath() {
                return this.oldPersistencePath;
            }

            public Path persistencePath(boolean create) {
                Path path = (Path)this.$persistenceBasePath.invoke();
                if (path == null) {
                    return null;
                }
                Path basePath = path;
                String string = ((Object)basePath).toString();
                Object object = new String[3];
                Intrinsics.checkNotNullExpressionValue((Object)((String)this.$ideCode.invoke()).toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                object[1] = "chat-sessions";
                object[2] = this.getPersistenceId();
                Object persistencePath = object = Paths.get(string, object);
                boolean bl = false;
                if (create) {
                    Intrinsics.checkNotNull((Object)persistencePath);
                    this.createDirs((Path)persistencePath);
                }
                return object;
            }

            public void onClose(Function0<Unit> listener2) {
                Intrinsics.checkNotNullParameter(listener2, (String)"listener");
                this.projectCloseListeners.add(listener2);
            }

            private final Path createDirs(Path $this$createDirs) {
                return (Path)this.$createDirs.invoke((Object)$this$createDirs);
            }

            private static final Unit _init_$lambda$2(Project.5 this$0, Ref.ObjectRef $projectClosedSubscription, com.intellij.openapi.project.Project platformProject) {
                Intrinsics.checkNotNullParameter((Object)platformProject, (String)"platformProject");
                Iterable $this$forEach$iv = this$0.projectCloseListeners;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Function0 listener2 = (Function0)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)this$0.getName(), (Object)platformProject.getName())) continue;
                    listener2.invoke();
                    ProjectClosedSubscription projectClosedSubscription = (ProjectClosedSubscription)$projectClosedSubscription.element;
                    if (projectClosedSubscription == null) continue;
                    projectClosedSubscription.unsubscribe();
                }
                return Unit.INSTANCE;
            }
        };
    }

    public static /* synthetic */ Project Project$default(String string, String string2, Path path, Function0 function0, Function1 function1, Function0 function02, Function1 function12, int n, Object object) {
        if ((n & 8) != 0) {
            function0 = Project.1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function1 = Project.2.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            function02 = Project.3.INSTANCE;
        }
        if ((n & 0x40) != 0) {
            function12 = Project.4.INSTANCE;
        }
        return ProjectKt.Project(string, string2, path, (Function0<String>)function0, (Function1<? super Path, ? extends Path>)function1, (Function0<? extends Path>)function02, (Function1<? super Function1<? super com.intellij.openapi.project.Project, Unit>, ? extends ProjectClosedSubscription>)function12);
    }

    private static final String defaultIdeCode() {
        String string = ApplicationInfo.getInstance().getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        return string;
    }

    private static final Path defaultCreateDirs(Path path) {
        return Files.createDirectories(path, new FileAttribute[0]);
    }

    private static final ProjectClosedSubscription defaultProjectClosedListener(Function1<? super com.intellij.openapi.project.Project, Unit> onClose) {
        MessageBusConnection subscription2 = ApplicationKt.subscribe(ApplicationKt.application(), ProjectCloseListener.TOPIC, new ProjectCloseListener(onClose){
            final /* synthetic */ Function1<com.intellij.openapi.project.Project, Unit> $onClose;
            {
                this.$onClose = $onClose;
            }

            public void projectClosed(com.intellij.openapi.project.Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                this.$onClose.invoke((Object)project);
            }
        });
        return new ProjectClosedSubscription(subscription2){
            final /* synthetic */ MessageBusConnection $subscription;
            {
                this.$subscription = $subscription;
            }

            public void unsubscribe() {
                this.$subscription.disconnect();
            }
        };
    }

    private static final Path defaultPersistenceBasePath() {
        Path path;
        try {
            Path path2;
            Object object = (ConversationPersistenceResponse)CopilotAgentConversationClientKt.CopilotAgentConversationClient().persistencePath().blockingGet(1000);
            if (object != null && (object = ((ConversationPersistenceResponse)object).getPath()) != null) {
                Object it = object;
                boolean bl = false;
                path2 = Paths.get((String)it, new String[0]);
            } else {
                path2 = null;
            }
            path = path2;
        }
        catch (Exception ex) {
            log.warn("failed to retrieve persistence path from agent", ex);
            path = null;
        }
        return path;
    }

    public static final /* synthetic */ String access$defaultIdeCode() {
        return ProjectKt.defaultIdeCode();
    }

    public static final /* synthetic */ Path access$defaultCreateDirs(Path path) {
        return ProjectKt.defaultCreateDirs(path);
    }

    public static final /* synthetic */ Path access$defaultPersistenceBasePath() {
        return ProjectKt.defaultPersistenceBasePath();
    }

    public static final /* synthetic */ ProjectClosedSubscription access$defaultProjectClosedListener(Function1 onClose) {
        return ProjectKt.defaultProjectClosedListener((Function1<? super com.intellij.openapi.project.Project, Unit>)onClose);
    }

    static {
        boolean $i$f$Logger = false;
        log = new GitHubLogger(Project.class);
    }
}

