/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.session.persistence;

import com.github.copilot.chat.message.ChatMessage;
import com.github.copilot.chat.session.persistence.PersistedMessage;
import com.github.copilot.chat.session.persistence.PersistedTurn;
import com.github.copilot.chat.session.persistence.PersistenceUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nJ\b\u0010\f\u001a\u0004\u0018\u00010\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\nH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/copilot/chat/session/persistence/TurnBuilder;", "", "sessionId", "", "request", "Lcom/github/copilot/chat/message/ChatMessage;", "<init>", "(Ljava/lang/String;Lcom/github/copilot/chat/message/ChatMessage;)V", "response", "rating", "", "value", "build", "Lcom/github/copilot/chat/session/persistence/PersistedTurn;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "core"})
final class TurnBuilder {
    @NotNull
    private final String sessionId;
    @NotNull
    private final ChatMessage request;
    @Nullable
    private ChatMessage response;
    private int rating;

    public TurnBuilder(@NotNull String sessionId, @NotNull ChatMessage request) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.sessionId = sessionId;
        this.request = request;
    }

    @NotNull
    public final TurnBuilder response(@NotNull ChatMessage value) {
        TurnBuilder turnBuilder;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        TurnBuilder $this$response_u24lambda_u240 = turnBuilder = this;
        boolean bl = false;
        $this$response_u24lambda_u240.response = value;
        return turnBuilder;
    }

    @NotNull
    public final TurnBuilder rating(int value) {
        TurnBuilder turnBuilder;
        TurnBuilder $this$rating_u24lambda_u241 = turnBuilder = this;
        boolean bl = false;
        $this$rating_u24lambda_u241.rating = value;
        return turnBuilder;
    }

    @Nullable
    public final PersistedTurn build() {
        String string = this.request.getTurnId();
        if (string == null) {
            return null;
        }
        Object object = this.response;
        if (object == null || (object = PersistenceUtilsKt.toPersistedMessage((ChatMessage)object)) == null) {
            return null;
        }
        return new PersistedTurn(string, this.sessionId, this.request.getCreatedAt(), null, null, PersistenceUtilsKt.toPersistedMessage(this.request), (PersistedMessage)object, this.rating, 24, null);
    }

    private final String component1() {
        return this.sessionId;
    }

    private final ChatMessage component2() {
        return this.request;
    }

    @NotNull
    public final TurnBuilder copy(@NotNull String sessionId, @NotNull ChatMessage request) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new TurnBuilder(sessionId, request);
    }

    public static /* synthetic */ TurnBuilder copy$default(TurnBuilder turnBuilder, String string, ChatMessage chatMessage, int n, Object object) {
        if ((n & 1) != 0) {
            string = turnBuilder.sessionId;
        }
        if ((n & 2) != 0) {
            chatMessage = turnBuilder.request;
        }
        return turnBuilder.copy(string, chatMessage);
    }

    @NotNull
    public String toString() {
        return "TurnBuilder(sessionId=" + this.sessionId + ", request=" + this.request + ")";
    }

    public int hashCode() {
        int result = this.sessionId.hashCode();
        result = result * 31 + this.request.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TurnBuilder)) {
            return false;
        }
        TurnBuilder turnBuilder = (TurnBuilder)other;
        if (!Intrinsics.areEqual((Object)this.sessionId, (Object)turnBuilder.sessionId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.request, (Object)turnBuilder.request);
    }
}

