/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.session.persistence.xodus;

import com.github.copilot.chat.input.ModelScope;
import com.github.copilot.chat.session.persistence.ChatSessionPersistenceService;
import com.github.copilot.chat.session.persistence.PersistedChatSession;
import com.github.copilot.chat.session.persistence.PersistedChatSessionNameSource;
import com.github.copilot.chat.session.persistence.PersistedTurn;
import com.github.copilot.chat.session.persistence.Project;
import com.github.copilot.chat.session.persistence.SortOrder;
import com.github.copilot.chat.session.persistence.xodus.XdUtilsKt;
import com.github.copilot.chat.session.persistence.xodus.entity.XdAgent;
import com.github.copilot.chat.session.persistence.xodus.entity.XdAnnotation;
import com.github.copilot.chat.session.persistence.xodus.entity.XdAnnotationDetails;
import com.github.copilot.chat.session.persistence.xodus.entity.XdChatSession;
import com.github.copilot.chat.session.persistence.xodus.entity.XdClient;
import com.github.copilot.chat.session.persistence.xodus.entity.XdConfirmationRequest;
import com.github.copilot.chat.session.persistence.xodus.entity.XdConfirmationResponse;
import com.github.copilot.chat.session.persistence.xodus.entity.XdFileReference;
import com.github.copilot.chat.session.persistence.xodus.entity.XdFileReferenceRange;
import com.github.copilot.chat.session.persistence.xodus.entity.XdMessage;
import com.github.copilot.chat.session.persistence.xodus.entity.XdMigration;
import com.github.copilot.chat.session.persistence.xodus.entity.XdNotification;
import com.github.copilot.chat.session.persistence.xodus.entity.XdReference;
import com.github.copilot.chat.session.persistence.xodus.entity.XdSelectedModel;
import com.github.copilot.chat.session.persistence.xodus.entity.XdStep;
import com.github.copilot.chat.session.persistence.xodus.entity.XdStepError;
import com.github.copilot.chat.session.persistence.xodus.entity.XdTurn;
import com.github.copilot.chat.session.persistence.xodus.entity.XdWebSearchReference;
import com.github.copilot.chat.session.persistence.xodus.migration.MigrationsKt;
import com.github.copilot.chat.session.persistence.xodus.migration.XdStoreMigrationService;
import com.github.copilot.chat.session.persistence.xodus.migration.XdStoreMigrationServiceKt;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.jetbrains.teamsys.dnq.database.TransientEntityStoreImpl;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.QueryCancellingPolicy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Instant;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdModel;
import kotlinx.dnq.query.XdMutableQuery;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.store.container.EntityStoreHelperKt;
import kotlinx.dnq.util.DNQMetaDataUtilKt;
import kotlinx.dnq.util.XdHierarchyNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 J2\u00020\u0001:\u0001JB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u0016J \u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020\u000fH\u0016J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#H\u0016J%\u0010$\u001a\b\u0012\u0004\u0012\u00020#0%2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0005H\u0016J\u0012\u00101\u001a\u0004\u0018\u00010\u00052\u0006\u0010.\u001a\u00020/H\u0016J \u00102\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u0012H\u0016J\b\u00104\u001a\u00020\u000fH\u0016J\n\u00105\u001a\u0004\u0018\u00010\rH\u0002J\f\u00106\u001a\u00020\u000f*\u00020\rH\u0002J\u000e\u00107\u001a\b\u0012\u0004\u0012\u0002080%H\u0002JM\u00109\u001a\u0004\u0018\u0001H:\"\u0004\b\u0000\u0010:2\b\b\u0002\u0010;\u001a\u00020<2\n\b\u0002\u0010=\u001a\u0004\u0018\u00010>2\b\b\u0002\u0010?\u001a\u00020<2\u0016\u0010@\u001a\u0012\u0012\b\u0012\u00060Bj\u0002`C\u0012\u0004\u0012\u0002H:0AH\u0002\u00a2\u0006\u0002\u0010DJ)\u0010E\u001a\b\u0012\u0004\u0012\u00020F0%2\b\b\u0002\u0010&\u001a\u00020'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u0010)J\u0012\u0010G\u001a\u0004\u0018\u00010F2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0012\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u001a\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/github/copilot/chat/session/persistence/xodus/XdChatSessionPersistenceService;", "Lcom/github/copilot/chat/session/persistence/ChatSessionPersistenceService;", "project", "Lcom/github/copilot/chat/session/persistence/Project;", "user", "", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "storeMigrationService", "Lcom/github/copilot/chat/session/persistence/xodus/migration/XdStoreMigrationService;", "<init>", "(Lcom/github/copilot/chat/session/persistence/Project;Ljava/lang/String;Lcom/github/copilot/platform/utils/observability/Logger;Lcom/github/copilot/chat/session/persistence/xodus/migration/XdStoreMigrationService;)V", "store", "Ljetbrains/exodus/database/TransientEntityStore;", "updateActiveAt", "", "sessionId", "activeAt", "Lkotlinx/datetime/Instant;", "updateModifiedAt", "modifiedAt", "updateRating", "turnId", "rating", "", "updateInput", "input", "renameSession", "newName", "source", "Lcom/github/copilot/chat/session/persistence/PersistedChatSessionNameSource;", "deleteSession", "deleteAllSessions", "persistSession", "session", "Lcom/github/copilot/chat/session/persistence/PersistedChatSession;", "getSessions", "", "sortOrder", "Lcom/github/copilot/chat/session/persistence/SortOrder;", "limit", "(Lcom/github/copilot/chat/session/persistence/SortOrder;Ljava/lang/Integer;)Ljava/util/List;", "persistTurn", "turn", "Lcom/github/copilot/chat/session/persistence/PersistedTurn;", "updateSelectedModel", "scope", "Lcom/github/copilot/chat/input/ModelScope;", "model", "getSelectedModel", "softDeleteTurn", "deletedAt", "dispose", "initStore", "runMigrations", "registerXdEntities", "Lkotlinx/dnq/util/XdHierarchyNode;", "tx", "T", "readonly", "", "queryCancellingPolicy", "Ljetbrains/exodus/entitystore/QueryCancellingPolicy;", "isNew", "block", "Lkotlin/Function1;", "Ljetbrains/exodus/database/TransientStoreSession;", "Lcom/github/copilot/chat/session/persistence/xodus/XdSession;", "(ZLjetbrains/exodus/entitystore/QueryCancellingPolicy;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getXdSessions", "Lcom/github/copilot/chat/session/persistence/xodus/entity/XdChatSession;", "getXdSession", "getXdTurn", "Lcom/github/copilot/chat/session/persistence/xodus/entity/XdTurn;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nXdChatSessionPersistenceService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XdChatSessionPersistenceService.kt\ncom/github/copilot/chat/session/persistence/xodus/XdChatSessionPersistenceService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,233:1\n1855#2,2:234\n1549#2:236\n1620#2,3:237\n*S KotlinDebug\n*F\n+ 1 XdChatSessionPersistenceService.kt\ncom/github/copilot/chat/session/persistence/xodus/XdChatSessionPersistenceService\n*L\n80#1:234,2\n91#1:236\n91#1:237,3\n*E\n"})
public final class XdChatSessionPersistenceService
implements ChatSessionPersistenceService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String user;
    @NotNull
    private final Logger log;
    @NotNull
    private final XdStoreMigrationService storeMigrationService;
    @Nullable
    private final TransientEntityStore store;
    @NotNull
    private static final String ENTITY_STORE_NAME = "copilot-chat";

    public XdChatSessionPersistenceService(@NotNull Project project, @NotNull String user, @NotNull Logger log, @NotNull XdStoreMigrationService storeMigrationService) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)storeMigrationService, (String)"storeMigrationService");
        this.project = project;
        this.user = user;
        this.log = log;
        this.storeMigrationService = storeMigrationService;
        this.store = this.initStore();
        this.project.onClose((Function0<Unit>)((Function0)() -> XdChatSessionPersistenceService._init_$lambda$0(this)));
    }

    public /* synthetic */ XdChatSessionPersistenceService(Project project, String string, Logger logger, XdStoreMigrationService xdStoreMigrationService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            logger = XdChatSessionPersistenceService.Companion.getDEFAULT_LOGGER();
        }
        if ((n & 8) != 0) {
            xdStoreMigrationService = XdChatSessionPersistenceService.Companion.getDEFAULT_STORE_MIGRATION_SERVICE();
        }
        this(project, string, logger, xdStoreMigrationService);
    }

    @Override
    public void updateActiveAt(@NotNull String sessionId, @NotNull Instant activeAt) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)activeAt, (String)"activeAt");
        XdChatSessionPersistenceService.tx$default(this, false, null, false, arg_0 -> XdChatSessionPersistenceService.updateActiveAt$lambda$2(this, sessionId, activeAt, arg_0), 7, null);
    }

    @Override
    public void updateModifiedAt(@NotNull String sessionId, @NotNull Instant modifiedAt) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)modifiedAt, (String)"modifiedAt");
        XdChatSessionPersistenceService.tx$default(this, false, null, false, arg_0 -> XdChatSessionPersistenceService.updateModifiedAt$lambda$4(this, sessionId, modifiedAt, arg_0), 7, null);
    }

    @Override
    public void updateRating(@NotNull String turnId, int rating) {
        Intrinsics.checkNotNullParameter((Object)turnId, (String)"turnId");
        XdChatSessionPersistenceService.tx$default(this, false, null, false, arg_0 -> XdChatSessionPersistenceService.updateRating$lambda$6(this, turnId, rating, arg_0), 7, null);
    }

    @Override
    public void updateInput(@NotNull String sessionId, @Nullable String input) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        XdChatSessionPersistenceService.tx$default(this, false, null, false, arg_0 -> XdChatSessionPersistenceService.updateInput$lambda$8(this, sessionId, input, arg_0), 7, null);
    }

    @Override
    public void renameSession(@NotNull String sessionId, @NotNull String newName, @NotNull PersistedChatSessionNameSource source) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        XdChatSessionPersistenceService.tx$default(this, false, null, false, arg_0 -> XdChatSessionPersistenceService.renameSession$lambda$10(this, sessionId, newName, source, arg_0), 7, null);
    }

    @Override
    public void deleteSession(@NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        XdChatSessionPersistenceService.tx$default(this, false, null, false, arg_0 -> XdChatSessionPersistenceService.deleteSession$lambda$11(this, sessionId, arg_0), 7, null);
    }

    @Override
    public void deleteAllSessions() {
        XdChatSessionPersistenceService.tx$default(this, false, null, false, XdChatSessionPersistenceService::deleteAllSessions$lambda$13, 7, null);
    }

    @Override
    public void persistSession(@NotNull PersistedChatSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        XdChatSessionPersistenceService.tx$default(this, false, null, false, arg_0 -> XdChatSessionPersistenceService.persistSession$lambda$14(session, arg_0), 7, null);
    }

    @Override
    @NotNull
    public List<PersistedChatSession> getSessions(@NotNull SortOrder sortOrder, @Nullable Integer limit) {
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        List list = (List)XdChatSessionPersistenceService.tx$default(this, false, null, false, arg_0 -> XdChatSessionPersistenceService.getSessions$lambda$16(this, sortOrder, limit, arg_0), 7, null);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public void persistTurn(@NotNull PersistedTurn turn) {
        Intrinsics.checkNotNullParameter((Object)turn, (String)"turn");
        XdChatSessionPersistenceService.tx$default(this, false, null, false, arg_0 -> XdChatSessionPersistenceService.persistTurn$lambda$17(this, turn, arg_0), 7, null);
    }

    @Override
    public void updateSelectedModel(@NotNull ModelScope scope, @NotNull String model) {
        Intrinsics.checkNotNullParameter((Object)((Object)scope), (String)"scope");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        XdChatSessionPersistenceService.tx$default(this, false, null, false, arg_0 -> XdChatSessionPersistenceService.updateSelectedModel$lambda$19(scope, model, arg_0), 7, null);
    }

    @Override
    @Nullable
    public String getSelectedModel(@NotNull ModelScope scope) {
        Intrinsics.checkNotNullParameter((Object)((Object)scope), (String)"scope");
        XdChatSessionPersistenceService.tx$default(this, false, null, false, arg_0 -> XdChatSessionPersistenceService.getSelectedModel$lambda$20(scope, arg_0), 7, null);
        return null;
    }

    @Override
    public void softDeleteTurn(@NotNull String sessionId, @NotNull String turnId, @NotNull Instant deletedAt) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)turnId, (String)"turnId");
        Intrinsics.checkNotNullParameter((Object)deletedAt, (String)"deletedAt");
        XdChatSessionPersistenceService.tx$default(this, false, null, false, arg_0 -> XdChatSessionPersistenceService.softDeleteTurn$lambda$22(this, sessionId, turnId, deletedAt, arg_0), 7, null);
    }

    @Override
    public void dispose() {
        block0: {
            TransientEntityStore transientEntityStore = this.store;
            if (transientEntityStore == null) break block0;
            transientEntityStore.close();
        }
    }

    private final TransientEntityStore initStore() {
        try {
            Path path = this.project.persistencePath(true);
            if (path == null) {
                throw new RuntimeException("failed to get persistence path");
            }
            Path persistencePath = path;
            Path path2 = this.project.getOldPersistencePath();
            if (path2 != null) {
                Path oldPersistencePath = path2;
                boolean bl = false;
                this.storeMigrationService.migrateStore(oldPersistencePath, persistencePath, true);
            }
            this.registerXdEntities();
            File file = persistencePath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            TransientEntityStoreImpl store = EntityStoreHelperKt.createTransientEntityStore$default((File)file, (String)ENTITY_STORE_NAME, null, (int)4, null);
            DNQMetaDataUtilKt.initMetaData((Map)XdModel.INSTANCE.getHierarchy(), (TransientEntityStoreImpl)store);
            this.runMigrations((TransientEntityStore)store);
            return (TransientEntityStore)store;
        }
        catch (Throwable ex) {
            this.log.info("failed to initialize xodus store with exception: " + ex);
            return null;
        }
    }

    private final void runMigrations(TransientEntityStore $this$runMigrations) {
        MigrationsKt.getMigrateReferences().invoke((Object)$this$runMigrations);
    }

    private final List<XdHierarchyNode> registerXdEntities() {
        XdEntityType[] xdEntityTypeArray = new XdEntityType[]{XdMigration.Companion, XdChatSession.Companion, XdClient.Companion, XdTurn.Companion, XdMessage.Companion, XdAnnotation.Companion, XdAnnotationDetails.Companion, XdStep.Companion, XdStepError.Companion, XdReference.Companion, XdFileReference.Companion, XdFileReferenceRange.Companion, XdWebSearchReference.Companion, XdAgent.Companion, XdConfirmationRequest.Companion, XdConfirmationResponse.Companion, XdNotification.Companion, XdSelectedModel.Companion};
        return XdModel.INSTANCE.registerNodes(xdEntityTypeArray);
    }

    private final <T> T tx(boolean readonly, QueryCancellingPolicy queryCancellingPolicy, boolean isNew, Function1<? super TransientStoreSession, ? extends T> block) {
        T t;
        try {
            TransientEntityStore transientEntityStore = this.store;
            t = transientEntityStore != null ? (T)XdUtilsKt.tx(transientEntityStore, readonly, queryCancellingPolicy, isNew, block) : null;
        }
        catch (Throwable ex) {
            this.log.info("transaction failed with exception: " + ex);
            t = null;
        }
        return t;
    }

    static /* synthetic */ Object tx$default(XdChatSessionPersistenceService xdChatSessionPersistenceService, boolean bl, QueryCancellingPolicy queryCancellingPolicy, boolean bl2, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            queryCancellingPolicy = null;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return xdChatSessionPersistenceService.tx(bl, queryCancellingPolicy, bl2, function1);
    }

    private final List<XdChatSession> getXdSessions(SortOrder sortOrder, Integer limit) {
        return XdChatSession.Companion.getSessions(this.user, sortOrder, limit);
    }

    static /* synthetic */ List getXdSessions$default(XdChatSessionPersistenceService xdChatSessionPersistenceService, SortOrder sortOrder, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            sortOrder = SortOrder.DESCENDING;
        }
        if ((n2 & 2) != 0) {
            n = null;
        }
        return xdChatSessionPersistenceService.getXdSessions(sortOrder, n);
    }

    private final XdChatSession getXdSession(String sessionId) {
        return XdChatSession.Companion.getSession(this.user, sessionId);
    }

    private final XdTurn getXdTurn(String turnId) {
        return XdTurn.Companion.getTurn(turnId);
    }

    private final XdTurn getXdTurn(String sessionId, String turnId) {
        return XdChatSession.Companion.getTurn(this.user, sessionId, turnId);
    }

    private static final Unit _init_$lambda$0(XdChatSessionPersistenceService this$0) {
        this$0.dispose();
        return Unit.INSTANCE;
    }

    private static final XdChatSession updateActiveAt$lambda$2(XdChatSessionPersistenceService this$0, String $sessionId, Instant $activeAt, TransientStoreSession it) {
        XdChatSession xdChatSession;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        XdChatSession xdChatSession2 = this$0.getXdSession($sessionId);
        if (xdChatSession2 != null) {
            XdChatSession xdChatSession3;
            XdChatSession $this$updateActiveAt_u24lambda_u242_u24lambda_u241 = xdChatSession3 = xdChatSession2;
            boolean bl = false;
            $this$updateActiveAt_u24lambda_u242_u24lambda_u241.setActiveAt($activeAt.toEpochMilliseconds());
            xdChatSession = xdChatSession3;
        } else {
            xdChatSession = null;
        }
        return xdChatSession;
    }

    private static final XdChatSession updateModifiedAt$lambda$4(XdChatSessionPersistenceService this$0, String $sessionId, Instant $modifiedAt, TransientStoreSession it) {
        XdChatSession xdChatSession;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        XdChatSession xdChatSession2 = this$0.getXdSession($sessionId);
        if (xdChatSession2 != null) {
            XdChatSession xdChatSession3;
            XdChatSession $this$updateModifiedAt_u24lambda_u244_u24lambda_u243 = xdChatSession3 = xdChatSession2;
            boolean bl = false;
            $this$updateModifiedAt_u24lambda_u244_u24lambda_u243.setModifiedAt($modifiedAt.toEpochMilliseconds());
            xdChatSession = xdChatSession3;
        } else {
            xdChatSession = null;
        }
        return xdChatSession;
    }

    private static final XdTurn updateRating$lambda$6(XdChatSessionPersistenceService this$0, String $turnId, int $rating, TransientStoreSession it) {
        XdTurn xdTurn;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        XdTurn xdTurn2 = this$0.getXdTurn($turnId);
        if (xdTurn2 != null) {
            XdTurn xdTurn3;
            XdTurn $this$updateRating_u24lambda_u246_u24lambda_u245 = xdTurn3 = xdTurn2;
            boolean bl = false;
            $this$updateRating_u24lambda_u246_u24lambda_u245.setRating($rating);
            xdTurn = xdTurn3;
        } else {
            xdTurn = null;
        }
        return xdTurn;
    }

    private static final XdChatSession updateInput$lambda$8(XdChatSessionPersistenceService this$0, String $sessionId, String $input, TransientStoreSession it) {
        XdChatSession xdChatSession;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        XdChatSession xdChatSession2 = this$0.getXdSession($sessionId);
        if (xdChatSession2 != null) {
            XdChatSession xdChatSession3;
            XdChatSession $this$updateInput_u24lambda_u248_u24lambda_u247 = xdChatSession3 = xdChatSession2;
            boolean bl = false;
            $this$updateInput_u24lambda_u248_u24lambda_u247.setInput($input);
            xdChatSession = xdChatSession3;
        } else {
            xdChatSession = null;
        }
        return xdChatSession;
    }

    private static final XdChatSession renameSession$lambda$10(XdChatSessionPersistenceService this$0, String $sessionId, String $newName, PersistedChatSessionNameSource $source, TransientStoreSession it) {
        XdChatSession xdChatSession;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        XdChatSession xdChatSession2 = this$0.getXdSession($sessionId);
        if (xdChatSession2 != null) {
            XdChatSession xdChatSession3;
            XdChatSession $this$renameSession_u24lambda_u2410_u24lambda_u249 = xdChatSession3 = xdChatSession2;
            boolean bl = false;
            $this$renameSession_u24lambda_u2410_u24lambda_u249.setName($newName);
            $this$renameSession_u24lambda_u2410_u24lambda_u249.setNameSource($source.getValue());
            xdChatSession = xdChatSession3;
        } else {
            xdChatSession = null;
        }
        return xdChatSession;
    }

    private static final Unit deleteSession$lambda$11(XdChatSessionPersistenceService this$0, String $sessionId, TransientStoreSession it) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        XdChatSession xdChatSession = this$0.getXdSession($sessionId);
        if (xdChatSession != null) {
            xdChatSession.delete();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final Unit deleteAllSessions$lambda$13(TransientStoreSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$forEach$iv = XdQueryKt.toList((XdQuery)XdChatSession.Companion.all());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XdChatSession it2 = (XdChatSession)((Object)element$iv);
            boolean bl = false;
            it2.delete();
        }
        return Unit.INSTANCE;
    }

    private static final XdChatSession persistSession$lambda$14(PersistedChatSession $session, TransientStoreSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return XdUtilsKt.toXdChatSession($session);
    }

    /*
     * WARNING - void declaration
     */
    private static final List getSessions$lambda$16(XdChatSessionPersistenceService this$0, SortOrder $sortOrder, Integer $limit, TransientStoreSession it) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$map$iv = this$0.getXdSessions($sortOrder, $limit);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            XdChatSession xdChatSession = (XdChatSession)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(XdUtilsKt.toPersistedChatSession((XdChatSession)it2));
        }
        return (List)destination$iv$iv;
    }

    private static final Unit persistTurn$lambda$17(XdChatSessionPersistenceService this$0, PersistedTurn $turn, TransientStoreSession it) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        XdMutableQuery<XdTurn> xdMutableQuery = this$0.getXdSession($turn.getSessionId());
        if (xdMutableQuery != null && (xdMutableQuery = xdMutableQuery.getTurns()) != null) {
            xdMutableQuery.add((XdEntity)XdUtilsKt.toXdTurn($turn));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final XdSelectedModel updateSelectedModel$lambda$19(ModelScope $scope, String $model, TransientStoreSession it) {
        XdSelectedModel xdSelectedModel;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        XdSelectedModel xdSelectedModel2 = XdSelectedModel.Companion.getSelectedModelEntity($scope);
        if (xdSelectedModel2 != null) {
            XdSelectedModel xdSelectedModel3;
            XdSelectedModel $this$updateSelectedModel_u24lambda_u2419_u24lambda_u2418 = xdSelectedModel3 = xdSelectedModel2;
            boolean bl = false;
            $this$updateSelectedModel_u24lambda_u2419_u24lambda_u2418.setModelFamily($model);
            xdSelectedModel = xdSelectedModel3;
        } else {
            xdSelectedModel = null;
        }
        return xdSelectedModel;
    }

    private static final String getSelectedModel$lambda$20(ModelScope $scope, TransientStoreSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return XdSelectedModel.Companion.getSelectedModel($scope);
    }

    private static final XdTurn softDeleteTurn$lambda$22(XdChatSessionPersistenceService this$0, String $sessionId, String $turnId, Instant $deletedAt, TransientStoreSession it) {
        XdTurn xdTurn;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        XdTurn xdTurn2 = this$0.getXdTurn($sessionId, $turnId);
        if (xdTurn2 != null) {
            XdTurn xdTurn3;
            XdTurn $this$softDeleteTurn_u24lambda_u2422_u24lambda_u2421 = xdTurn3 = xdTurn2;
            boolean bl = false;
            $this$softDeleteTurn_u24lambda_u2422_u24lambda_u2421.setDeletedAt($deletedAt.toEpochMilliseconds());
            xdTurn = xdTurn3;
        } else {
            xdTurn = null;
        }
        return xdTurn;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/github/copilot/chat/session/persistence/xodus/XdChatSessionPersistenceService$Companion;", "", "<init>", "()V", "ENTITY_STORE_NAME", "", "DEFAULT_LOGGER", "Lcom/github/copilot/platform/utils/observability/GitHubLogger;", "getDEFAULT_LOGGER", "()Lcom/github/copilot/platform/utils/observability/GitHubLogger;", "DEFAULT_STORE_MIGRATION_SERVICE", "Lcom/github/copilot/chat/session/persistence/xodus/migration/XdStoreMigrationService;", "getDEFAULT_STORE_MIGRATION_SERVICE", "()Lcom/github/copilot/chat/session/persistence/xodus/migration/XdStoreMigrationService;", "core"})
    @SourceDebugExtension(value={"SMAP\nXdChatSessionPersistenceService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XdChatSessionPersistenceService.kt\ncom/github/copilot/chat/session/persistence/xodus/XdChatSessionPersistenceService$Companion\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,233:1\n39#2:234\n*S KotlinDebug\n*F\n+ 1 XdChatSessionPersistenceService.kt\ncom/github/copilot/chat/session/persistence/xodus/XdChatSessionPersistenceService$Companion\n*L\n228#1:234\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final GitHubLogger getDEFAULT_LOGGER() {
            boolean $i$f$Logger = false;
            return new GitHubLogger(XdChatSessionPersistenceService.class);
        }

        private final XdStoreMigrationService getDEFAULT_STORE_MIGRATION_SERVICE() {
            return XdStoreMigrationServiceKt.XdStoreMigrationService$default(null, null, null, null, null, 31, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

