/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.session.persistence.xodus.migration;

import com.github.copilot.chat.session.persistence.xodus.migration.XdStoreMigrationService;
import com.github.copilot.chat.session.persistence.xodus.migration.XdStoreMigrationServiceKt;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\u001a\u0098\u0001\u0010\u0000\u001a\u00020\u00012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u000328\b\u0002\u0010\b\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\t2\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\u0003\u001a\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002\u00a8\u0006\u0016"}, d2={"XdStoreMigrationService", "Lcom/github/copilot/chat/session/persistence/xodus/migration/XdStoreMigrationService;", "doesExist", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "", "isDirectory", "isDirectoryEmpty", "copy", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "source", "target", "", "delete", "defaultDoesExist", "path", "defaultIsDirectory", "defaultIsDirectoryEmpty", "defaultCopy", "defaultDelete", "core"})
@SourceDebugExtension(value={"SMAP\nXdStoreMigrationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XdStoreMigrationService.kt\ncom/github/copilot/chat/session/persistence/xodus/migration/XdStoreMigrationServiceKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class XdStoreMigrationServiceKt {
    @NotNull
    public static final XdStoreMigrationService XdStoreMigrationService(@NotNull Function1<? super Path, Boolean> doesExist, @NotNull Function1<? super Path, Boolean> isDirectory, @NotNull Function1<? super Path, Boolean> isDirectoryEmpty, @NotNull Function2<? super Path, ? super Path, Unit> copy, @NotNull Function1<? super Path, Unit> delete) {
        Intrinsics.checkNotNullParameter(doesExist, (String)"doesExist");
        Intrinsics.checkNotNullParameter(isDirectory, (String)"isDirectory");
        Intrinsics.checkNotNullParameter(isDirectoryEmpty, (String)"isDirectoryEmpty");
        Intrinsics.checkNotNullParameter(copy, (String)"copy");
        Intrinsics.checkNotNullParameter(delete, (String)"delete");
        return new XdStoreMigrationService(copy, delete, doesExist, isDirectory, isDirectoryEmpty){
            private final GitHubLogger log;
            final /* synthetic */ Function2<Path, Path, Unit> $copy;
            final /* synthetic */ Function1<Path, Unit> $delete;
            final /* synthetic */ Function1<Path, Boolean> $doesExist;
            final /* synthetic */ Function1<Path, Boolean> $isDirectory;
            final /* synthetic */ Function1<Path, Boolean> $isDirectoryEmpty;
            {
                this.$copy = $copy;
                this.$delete = $delete;
                this.$doesExist = $doesExist;
                this.$isDirectory = $isDirectory;
                this.$isDirectoryEmpty = $isDirectoryEmpty;
                boolean $i$f$Logger = false;
                this.log = new GitHubLogger(XdStoreMigrationService.class);
            }

            public boolean migrateStore(Path oldLocation, Path newLocation, boolean deleteOldStore) {
                Intrinsics.checkNotNullParameter((Object)oldLocation, (String)"oldLocation");
                Intrinsics.checkNotNullParameter((Object)newLocation, (String)"newLocation");
                try {
                    if (!this.isMigratable(oldLocation) || !this.isValidMigrationTarget(newLocation)) {
                        return false;
                    }
                    this.$copy.invoke((Object)oldLocation, (Object)newLocation);
                    if (deleteOldStore) {
                        Path path = oldLocation.getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
                        this.$delete.invoke((Object)path);
                    }
                    return true;
                }
                catch (Exception ex) {
                    this.log.warn("error attempting to migrate store", ex);
                    return false;
                }
            }

            private final boolean isMigratable(Path $this$isMigratable) {
                return (Boolean)this.$doesExist.invoke((Object)$this$isMigratable) != false && (Boolean)this.$isDirectory.invoke((Object)$this$isMigratable) != false && (Boolean)this.$isDirectoryEmpty.invoke((Object)$this$isMigratable) == false;
            }

            private final boolean isValidMigrationTarget(Path $this$isValidMigrationTarget) {
                if (!((Boolean)this.$doesExist.invoke((Object)$this$isValidMigrationTarget)).booleanValue()) {
                    return true;
                }
                return (Boolean)this.$isDirectory.invoke((Object)$this$isValidMigrationTarget) != false && (Boolean)this.$isDirectoryEmpty.invoke((Object)$this$isValidMigrationTarget) != false;
            }
        };
    }

    public static /* synthetic */ XdStoreMigrationService XdStoreMigrationService$default(Function1 function1, Function1 function12, Function1 function13, Function2 function2, Function1 function14, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = XdStoreMigrationService.1.INSTANCE;
        }
        if ((n & 2) != 0) {
            function12 = XdStoreMigrationService.2.INSTANCE;
        }
        if ((n & 4) != 0) {
            function13 = XdStoreMigrationService.3.INSTANCE;
        }
        if ((n & 8) != 0) {
            function2 = XdStoreMigrationService.4.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function14 = XdStoreMigrationService.5.INSTANCE;
        }
        return XdStoreMigrationServiceKt.XdStoreMigrationService((Function1<? super Path, Boolean>)function1, (Function1<? super Path, Boolean>)function12, (Function1<? super Path, Boolean>)function13, (Function2<? super Path, ? super Path, Unit>)function2, (Function1<? super Path, Unit>)function14);
    }

    private static final boolean defaultDoesExist(Path path) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final boolean defaultIsDirectory(Path path) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean defaultIsDirectoryEmpty(Path path) {
        boolean bl;
        AutoCloseable autoCloseable = Files.list(path);
        Throwable throwable = null;
        try {
            Stream it = (Stream)autoCloseable;
            boolean bl2 = false;
            bl = it.findAny().isEmpty();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return bl;
    }

    private static final void defaultCopy(Path source, Path target) {
        File file = source.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        File file2 = target.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        FilesKt.copyRecursively$default((File)file, (File)file2, (boolean)false, null, (int)4, null);
    }

    private static final void defaultDelete(Path path) {
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        FilesKt.deleteRecursively((File)file);
    }

    public static final /* synthetic */ boolean access$defaultDoesExist(Path path) {
        return XdStoreMigrationServiceKt.defaultDoesExist(path);
    }

    public static final /* synthetic */ boolean access$defaultIsDirectory(Path path) {
        return XdStoreMigrationServiceKt.defaultIsDirectory(path);
    }

    public static final /* synthetic */ boolean access$defaultIsDirectoryEmpty(Path path) {
        return XdStoreMigrationServiceKt.defaultIsDirectoryEmpty(path);
    }

    public static final /* synthetic */ void access$defaultCopy(Path source, Path target) {
        XdStoreMigrationServiceKt.defaultCopy(source, target);
    }

    public static final /* synthetic */ void access$defaultDelete(Path path) {
        XdStoreMigrationServiceKt.defaultDelete(path);
    }
}

