/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.user;

import com.github.copilot.chat.user.AutoScaledIcon;
import com.github.copilot.chat.user.GitHubUser;
import com.github.copilot.chat.user.GitHubUserIcon;
import com.github.copilot.chat.user.UserIcon;
import com.github.copilot.platform.utils.ApplicationKt;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\b\u0010\r\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/copilot/chat/user/GitHubUserIconService;", "", "<init>", "()V", "log", "Lcom/github/copilot/platform/utils/observability/GitHubLogger;", "userIcons", "", "", "Lcom/github/copilot/chat/user/UserIcon;", "getUserIcon", "Lcom/github/copilot/chat/user/GitHubUserIcon;", "user", "placeholder", "downloadUserIcon", "Ljavax/swing/Icon;", "core"})
@SourceDebugExtension(value={"SMAP\nGitHubUserIconService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHubUserIconService.kt\ncom/github/copilot/chat/user/GitHubUserIconService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,97:1\n1855#2,2:98\n39#3:100\n*S KotlinDebug\n*F\n+ 1 GitHubUserIconService.kt\ncom/github/copilot/chat/user/GitHubUserIconService\n*L\n58#1:98,2\n14#1:100\n*E\n"})
public final class GitHubUserIconService {
    @NotNull
    public static final GitHubUserIconService INSTANCE = new GitHubUserIconService();
    @NotNull
    private static final GitHubLogger log;
    @NotNull
    private static final Map<String, UserIcon> userIcons;

    private GitHubUserIconService() {
    }

    @NotNull
    public final GitHubUserIcon getUserIcon(@NotNull String user) {
        UserIcon userIcon;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        UserIcon userIcon2 = userIcons.get(user);
        if (userIcon2 != null) {
            GitHubUserIcon gitHubUserIcon;
            UserIcon userIcon3 = userIcon2;
            boolean bl = false;
            if (!userIcon3.isDownloadInProgress()) {
                if (userIcon3.getIcon() != null) {
                    Icon icon = userIcon3.getIcon();
                    Intrinsics.checkNotNull((Object)icon);
                    gitHubUserIcon = new GitHubUserIcon(icon);
                } else {
                    gitHubUserIcon = INSTANCE.placeholder();
                }
            } else {
                GitHubUserIcon gitHubUserIcon2;
                GitHubUserIcon $this$getUserIcon_u24lambda_u241_u24lambda_u240 = gitHubUserIcon2 = INSTANCE.placeholder();
                boolean bl2 = false;
                userIcon3.getPlaceholders().add($this$getUserIcon_u24lambda_u241_u24lambda_u240);
                gitHubUserIcon = gitHubUserIcon2;
            }
            return gitHubUserIcon;
        }
        GitHubUserIcon placeholder = this.placeholder();
        UserIcon $this$getUserIcon_u24lambda_u242 = userIcon = new UserIcon(true);
        boolean bl = false;
        userIcons.put(user, $this$getUserIcon_u24lambda_u242);
        $this$getUserIcon_u24lambda_u242.getPlaceholders().add(placeholder);
        UserIcon userIcon4 = userIcon;
        ApplicationKt.runOnPooledThread(() -> GitHubUserIconService.getUserIcon$lambda$5(userIcon4, user));
        return placeholder;
    }

    private final GitHubUserIcon placeholder() {
        return new GitHubUserIcon(GitHubUser.Companion.getDEFAULT_ICON());
    }

    private final Icon downloadUserIcon(String user) {
        Icon icon;
        try {
            URL imageUrl = URI.create("https://github.com/" + user + ".png").toURL();
            BufferedImage image = ImageIO.read(imageUrl);
            Intrinsics.checkNotNull((Object)image);
            icon = new AutoScaledIcon(image, 24, 1.0);
        }
        catch (Exception ex) {
            log.warn("failed to download user icon", ex);
            icon = GitHubUser.Companion.getDEFAULT_ICON();
        }
        return icon;
    }

    private static final void getUserIcon$lambda$5(UserIcon $userIcon, String $user) {
        UserIcon userIcon;
        UserIcon $this$getUserIcon_u24lambda_u245_u24lambda_u244 = userIcon = $userIcon;
        boolean bl = false;
        $this$getUserIcon_u24lambda_u245_u24lambda_u244.setIcon(INSTANCE.downloadUserIcon($user));
        $this$getUserIcon_u24lambda_u245_u24lambda_u244.setDownloadInProgress(false);
        Iterable $this$forEach$iv = $this$getUserIcon_u24lambda_u245_u24lambda_u244.getPlaceholders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GitHubUserIcon placeholder = (GitHubUserIcon)element$iv;
            boolean bl2 = false;
            placeholder.setIcon($userIcon.getIcon());
            placeholder.revalidate();
            placeholder.repaint();
        }
    }

    static {
        boolean $i$f$Logger = false;
        log = new GitHubLogger(GitHubUserIconService.class);
        userIcons = new ConcurrentHashMap();
    }
}

