/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.utils;

import com.github.copilot.chat.utils.Time;
import java.time.format.TextStyle;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import kotlinx.datetime.DateTimePeriod;
import kotlinx.datetime.Instant;
import kotlinx.datetime.InstantJvmKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\n\"\u0015\u0010\u0004\u001a\u00020\u0003*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"timeAgo", "", "Lkotlinx/datetime/DateTimePeriod;", "Lkotlinx/datetime/Instant;", "now", "Lkotlinx/datetime/Instant$Companion;", "getNow", "(Lkotlinx/datetime/Instant$Companion;)Lkotlinx/datetime/Instant;", "toFormattedTimestamp", "timeZone", "Lkotlinx/datetime/TimeZone;", "core"})
public final class TimeUtilKt {
    private static final String timeAgo(DateTimePeriod $this$timeAgo) {
        Time years = new Time($this$timeAgo.getYears(), "year");
        Time months = new Time($this$timeAgo.getMonths(), "month");
        Time days = new Time($this$timeAgo.getDays(), "day");
        Time hours = new Time($this$timeAgo.getHours(), "hour");
        Time minutes = new Time($this$timeAgo.getMinutes(), "minute");
        String period = years.isSet() ? years.plus(months) : (months.isSet() ? months.plus(days) : (days.isSet() ? days.plus(hours) : (hours.isSet() ? hours.plus(minutes) : (minutes.isSet() ? minutes.toString() : "moments"))));
        return period + " ago";
    }

    @NotNull
    public static final String timeAgo(@NotNull Instant $this$timeAgo) {
        Intrinsics.checkNotNullParameter((Object)$this$timeAgo, (String)"<this>");
        return TimeUtilKt.timeAgo(InstantJvmKt.periodUntil((Instant)$this$timeAgo, (Instant)Clock.System.INSTANCE.now(), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())));
    }

    @NotNull
    public static final Instant getNow(@NotNull Instant.Companion $this$now) {
        Intrinsics.checkNotNullParameter((Object)$this$now, (String)"<this>");
        return Clock.System.INSTANCE.now();
    }

    @NotNull
    public static final String toFormattedTimestamp(@NotNull Instant $this$toFormattedTimestamp, @NotNull TimeZone timeZone) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toFormattedTimestamp, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        LocalDateTime localized = TimeZoneKt.toLocalDateTime((Instant)$this$toFormattedTimestamp, (TimeZone)timeZone);
        StringBuilder $this$toFormattedTimestamp_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toFormattedTimestamp_u24lambda_u240.append(localized.getMonth().getDisplayName(TextStyle.FULL, Locale.getDefault()));
        $this$toFormattedTimestamp_u24lambda_u240.append(" " + localized.getDayOfMonth() + ",");
        $this$toFormattedTimestamp_u24lambda_u240.append(" " + localized.getYear());
        String string = "%02d";
        Object[] objectArray = new Object[]{localized.getTime().getHour()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        string = "%02d";
        objectArray = new Object[]{localized.getTime().getMinute()};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        $this$toFormattedTimestamp_u24lambda_u240.append(" " + string2 + ":" + string3);
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        return string4;
    }

    public static /* synthetic */ String toFormattedTimestamp$default(Instant instant, TimeZone timeZone, int n, Object object) {
        if ((n & 1) != 0) {
            timeZone = TimeZone.Companion.currentSystemDefault();
        }
        return TimeUtilKt.toFormattedTimestamp(instant, timeZone);
    }
}

