/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.window;

import com.github.copilot.chat.auth.ChatInformationalPanelKt;
import com.github.copilot.chat.auth.PanelType;
import com.github.copilot.chat.conversation.agent.rpc.ConfirmationResponse;
import com.github.copilot.chat.input.CopilotChatInputPanel;
import com.github.copilot.chat.input.EntryPointListener;
import com.github.copilot.chat.input.UserMessageListener;
import com.github.copilot.chat.message.ChatFollowUp;
import com.github.copilot.chat.precondition.ChatPreconditions;
import com.github.copilot.chat.precondition.ChatPreconditionsPanel;
import com.github.copilot.chat.precondition.ChatPreconditionsService;
import com.github.copilot.chat.precondition.ChatPreconditionsServiceKt;
import com.github.copilot.chat.precondition.ChatPreconditionsSubscription;
import com.github.copilot.chat.session.ChatSession;
import com.github.copilot.chat.session.ChatSessionController;
import com.github.copilot.chat.session.ChatSessionManager;
import com.github.copilot.chat.session.SessionController;
import com.github.copilot.chat.session.SessionManager;
import com.github.copilot.chat.session.component.ChatSessionComponent;
import com.github.copilot.chat.session.component.ChatSessionTransitionalComponent;
import com.github.copilot.chat.session.listener.ChatSessionCreateRequestListener;
import com.github.copilot.chat.session.listener.ChatSessionLoadRequestListener;
import com.github.copilot.chat.session.persistence.ChatSessionPersistenceService;
import com.github.copilot.chat.user.GitHubUser;
import com.github.copilot.chat.window.ContentType;
import com.github.copilot.chat.window.FocusToolWindowManagerListener;
import com.github.copilot.chat.window.actions.NewConversationAction;
import com.github.copilot.platform.utils.ProjectKt;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.github.copilot.status.CopilotAuthStatus;
import com.github.copilot.status.CopilotAuthStatusKt;
import com.github.copilot.util.ApplicationUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 B2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006:\u0001BB#\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJF\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0012\u0010)\u001a\u00020\u001a2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u001a\u0010*\u001a\u00020\u001a2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001a\u0010+\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020\u001aH\u0002J\b\u0010/\u001a\u00020\u001aH\u0002J\u0010\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u000202H\u0002J\u000f\u00103\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0002\u00104J\r\u00105\u001a\u00070(\u00a2\u0006\u0002\b6H\u0002J\b\u00107\u001a\u00020\u001aH\u0002J\u000f\u00108\u001a\t\u0018\u000109\u00a2\u0006\u0002\b6H\u0002J\u0010\u0010:\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020\u001a2\u0006\u0010>\u001a\u000209H\u0002J\u0016\u0010?\u001a\u00020\u001a2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001a0AH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/github/copilot/chat/window/CopilotChatToolWindow;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/github/copilot/chat/session/listener/ChatSessionCreateRequestListener;", "Lcom/github/copilot/chat/session/listener/ChatSessionLoadRequestListener;", "Lcom/github/copilot/chat/input/UserMessageListener;", "Lcom/github/copilot/chat/input/EntryPointListener;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "preconditionService", "Lcom/github/copilot/chat/precondition/ChatPreconditionsService;", "<init>", "(Lcom/intellij/openapi/wm/ToolWindow;Lcom/github/copilot/platform/utils/observability/Logger;Lcom/github/copilot/chat/precondition/ChatPreconditionsService;)V", "preconditions", "Lcom/github/copilot/chat/precondition/ChatPreconditions;", "authStatus", "Lcom/github/copilot/status/CopilotAuthStatus;", "currentContentType", "Lcom/github/copilot/chat/window/ContentType;", "chatSessionManager", "Lcom/github/copilot/chat/session/ChatSessionManager;", "focusToolWindowSubscription", "Lcom/intellij/util/messages/MessageBusConnection;", "onUserMessage", "", "content", "", "chatSession", "Lcom/github/copilot/chat/session/ChatSession;", "followUp", "Lcom/github/copilot/chat/message/ChatFollowUp;", "confirmation", "Lcom/github/copilot/chat/conversation/agent/rpc/ConfirmationResponse;", "ignoredSkills", "", "model", "onEntryPoint", "project", "Lcom/intellij/openapi/project/Project;", "onSessionCreateRequest", "onSessionLoadRequest", "loadChatSession", "reset", "", "subscribeToPreconditions", "subscribeToAuthStatus", "onCopilotReady", "user", "Lcom/github/copilot/chat/user/GitHubUser;", "updateUi", "()Lkotlin/Unit;", "getProject", "Lorg/jetbrains/annotations/NotNull;", "showToolWindow", "currentContent", "Ljavax/swing/JComponent;", "setCurrentChatSession", "chatSessionController", "Lcom/github/copilot/chat/session/ChatSessionController;", "replaceContent", "component", "onProjectDisposed", "block", "Lkotlin/Function0;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCopilotChatToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopilotChatToolWindow.kt\ncom/github/copilot/chat/window/CopilotChatToolWindow\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,278:1\n39#2:279\n288#3,2:280\n1#4:282\n*S KotlinDebug\n*F\n+ 1 CopilotChatToolWindow.kt\ncom/github/copilot/chat/window/CopilotChatToolWindow\n*L\n41#1:279\n91#1:280,2\n*E\n"})
public final class CopilotChatToolWindow
extends SimpleToolWindowPanel
implements DumbAware,
ChatSessionCreateRequestListener,
ChatSessionLoadRequestListener,
UserMessageListener,
EntryPointListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ToolWindow toolWindow;
    @NotNull
    private final Logger log;
    @NotNull
    private final ChatPreconditionsService preconditionService;
    @NotNull
    private ChatPreconditions preconditions;
    @NotNull
    private CopilotAuthStatus authStatus;
    @Nullable
    private ContentType currentContentType;
    @Nullable
    private ChatSessionManager chatSessionManager;
    @Nullable
    private MessageBusConnection focusToolWindowSubscription;
    @NotNull
    public static final String ID = "GitHub Copilot Chat";

    public CopilotChatToolWindow(@NotNull ToolWindow toolWindow, @NotNull Logger log, @NotNull ChatPreconditionsService preconditionService) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)preconditionService, (String)"preconditionService");
        super(true);
        this.toolWindow = toolWindow;
        this.log = log;
        this.preconditionService = preconditionService;
        this.preconditions = ChatPreconditions.Companion.getUNKNOWN();
        this.authStatus = CopilotAuthStatus.NotSignedIn.INSTANCE;
        this.subscribeToPreconditions();
        this.subscribeToAuthStatus();
        ChatSessionCreateRequestListener.Companion.register(this);
        ChatSessionLoadRequestListener.Companion.register(this);
        UserMessageListener.Companion.register(this);
        EntryPointListener.Companion.register(this);
        ChatSessionManager chatSessionManager = this.chatSessionManager;
        ActionManager.getInstance().replaceAction("copilot.newChatSession", (AnAction)new NewConversationAction(chatSessionManager != null ? chatSessionManager.getCurrentChatSessionController() : null, false, 2, null));
    }

    public /* synthetic */ CopilotChatToolWindow(ToolWindow toolWindow, Logger logger, ChatPreconditionsService chatPreconditionsService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(CopilotChatToolWindow.class);
        }
        if ((n & 4) != 0) {
            chatPreconditionsService = ChatPreconditionsServiceKt.ChatPreconditionsService();
        }
        this(toolWindow, logger, chatPreconditionsService);
    }

    @Override
    public void onUserMessage(@NotNull String content, @NotNull ChatSession chatSession, @Nullable ChatFollowUp followUp, @Nullable ConfirmationResponse confirmation, @Nullable List<String> ignoredSkills, @Nullable String model) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        Object object = chatSession.getController();
        if (Intrinsics.areEqual((Object)(object != null && (object = ((SessionController)object).getChatSessionManager()) != null ? object.getProject() : null), (Object)this.toolWindow.getProject())) {
            this.showToolWindow();
        }
    }

    @Override
    public void onEntryPoint(@NotNull String content, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (Intrinsics.areEqual((Object)project, (Object)this.toolWindow.getProject())) {
            this.showToolWindow();
        }
    }

    @Override
    public void onSessionCreateRequest(@Nullable Project project) {
        if (Intrinsics.areEqual((Object)this.toolWindow.getProject(), (Object)project)) {
            ChatSession existingEmptyConversation;
            Object object = this.chatSessionManager;
            if (object != null && (object = SessionManager.DefaultImpls.getChatSessions$default((SessionManager)object, null, 1, null)) != null) {
                Object v1;
                block8: {
                    Iterable $this$firstOrNull$iv = (Iterable)object;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ChatSession it = (ChatSession)element$iv;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it.getName().getValue(), (Object)"New Conversation") && it.getMessages().size() == 1)) continue;
                        v1 = element$iv;
                        break block8;
                    }
                    v1 = null;
                }
                v2 = v1;
            } else {
                v2 = existingEmptyConversation = null;
            }
            if (existingEmptyConversation == null) {
                ChatSessionManager chatSessionManager = this.chatSessionManager;
                if (chatSessionManager != null) {
                    ChatSessionManager it = chatSessionManager;
                    boolean bl = false;
                    this.setCurrentChatSession(it.newChatSession());
                }
            } else {
                if (existingEmptyConversation.getController() != null) {
                    SessionController sessionController = existingEmptyConversation.getController();
                    Intrinsics.checkNotNull((Object)sessionController, (String)"null cannot be cast to non-null type com.github.copilot.chat.session.ChatSessionController");
                    ((ChatSessionController)sessionController).reset();
                }
                this.loadChatSession(existingEmptyConversation, true);
            }
        }
    }

    @Override
    public void onSessionLoadRequest(@Nullable Project project, @NotNull ChatSession chatSession) {
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        if (Intrinsics.areEqual((Object)this.toolWindow.getProject(), (Object)project)) {
            this.log.trace("Loading chat session: " + chatSession.getId());
            CopilotChatToolWindow.loadChatSession$default(this, chatSession, false, 2, null);
        }
    }

    private final void loadChatSession(ChatSession chatSession, boolean reset) {
        block8: {
            ChatSessionController controller;
            ChatSessionManager chatSessionManager = this.chatSessionManager;
            if (chatSessionManager == null) break block8;
            ChatSessionManager it = chatSessionManager;
            boolean bl = false;
            ChatSessionManager chatSessionManager2 = this.chatSessionManager;
            ChatSessionController chatSessionController = controller = chatSessionManager2 != null ? chatSessionManager2.getControllerForChatSession(chatSession) : null;
            if (controller != null) {
                Object object = this.chatSessionManager;
                if (!Intrinsics.areEqual(object != null && (object = ((ChatSessionManager)object).getCurrentChatSessionController()) != null && (object = ((ChatSessionController)object).getSession()) != null ? ((ChatSession)object).getId() : null, (Object)controller.getSession().getId())) {
                    this.log.trace("Setting current chat session to: " + chatSession.getId());
                    ChatSessionManager chatSessionManager3 = this.chatSessionManager;
                    if (chatSessionManager3 != null) {
                        Object object2;
                        ChatSessionManager it2 = chatSessionManager3;
                        boolean bl2 = false;
                        ChatSessionManager chatSessionManager4 = this.chatSessionManager;
                        if (chatSessionManager4 != null) {
                            chatSessionManager4.setCurrentChatSessionController(controller);
                        }
                        if ((object2 = this.chatSessionManager) != null && (object2 = ((ChatSessionManager)object2).getCurrentChatSessionController()) != null && (object2 = ((ChatSessionController)object2).getComponent()) != null && (object2 = ((ChatSessionTransitionalComponent)object2).getChatSessionComponent()) != null) {
                            ((ChatSessionComponent)object2).replaceToolbarForController(controller);
                        }
                        this.setCurrentChatSession(controller);
                        Object object3 = this.chatSessionManager;
                        if (object3 != null && (object3 = ((ChatSessionManager)object3).getCurrentChatSessionController()) != null && (object3 = ((ChatSessionController)object3).getComponent()) != null && (object3 = ((ChatSessionTransitionalComponent)object3).getChatSessionComponent()) != null && (object3 = ((ChatSessionComponent)object3).getChatInputPanel()) != null) {
                            ((CopilotChatInputPanel)object3).loadModel();
                        }
                    }
                }
                controller.getComponent().setChatSession();
            }
            if (reset) {
                ChatSessionController chatSessionController2 = controller;
                if (chatSessionController2 != null) {
                    chatSessionController2.reset();
                }
            }
        }
    }

    static /* synthetic */ void loadChatSession$default(CopilotChatToolWindow copilotChatToolWindow, ChatSession chatSession, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        copilotChatToolWindow.loadChatSession(chatSession, bl);
    }

    private final void subscribeToPreconditions() {
        ChatPreconditionsSubscription subscription2 = this.preconditionService.subscribeToPreconditions((Function1<? super ChatPreconditions, Unit>)((Function1)arg_0 -> CopilotChatToolWindow.subscribeToPreconditions$lambda$4(this, arg_0)));
        this.onProjectDisposed((Function0<Unit>)((Function0)() -> CopilotChatToolWindow.subscribeToPreconditions$lambda$5(subscription2)));
    }

    private final void subscribeToAuthStatus() {
        CopilotAuthStatusKt.subscribeToCopilotAuthStatus((Function1<? super CopilotAuthStatus, Unit>)((Function1)arg_0 -> CopilotChatToolWindow.subscribeToAuthStatus$lambda$6(this, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final void onCopilotReady(GitHubUser user) {
        void $this$onCopilotReady_u24lambda_u247;
        ChatSessionManager chatSessionManager;
        Project currentProject = this.getProject();
        ChatSessionManager chatSessionManager2 = this.chatSessionManager;
        if (chatSessionManager2 != null) {
            chatSessionManager2.dispose();
        }
        ChatSessionManager chatSessionManager3 = chatSessionManager = new ChatSessionManager(currentProject, user, null, null, null, null, 60, null);
        CopilotChatToolWindow copilotChatToolWindow = this;
        boolean bl = false;
        this.setCurrentChatSession($this$onCopilotReady_u24lambda_u247.getCurrentChatSessionController());
        MessageBusConnection messageBusConnection = this.focusToolWindowSubscription;
        if (messageBusConnection != null) {
            messageBusConnection.disconnect();
        }
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        this.focusToolWindowSubscription = ProjectKt.subscribe(currentProject, topic, new FocusToolWindowManagerListener((ChatSessionManager)$this$onCopilotReady_u24lambda_u247));
        Object object = this.chatSessionManager;
        if (object != null && (object = ((ChatSessionManager)object).getCurrentChatSessionController()) != null && (object = ((ChatSessionController)object).getComponent()) != null && (object = ((ChatSessionTransitionalComponent)object).getChatSessionComponent()) != null && (object = ((ChatSessionComponent)object).getChatInputPanel()) != null) {
            ((CopilotChatInputPanel)object).loadModel();
        }
        copilotChatToolWindow.chatSessionManager = chatSessionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Unit updateUi() {
        Unit unit;
        CopilotChatToolWindow copilotChatToolWindow = this;
        synchronized (copilotChatToolWindow) {
            Unit unit2;
            JPanel newContent;
            JPanel jPanel;
            boolean bl = false;
            ContentType newContentType = CopilotAuthStatusKt.isNotSignedIn(this.authStatus) || CopilotAuthStatusKt.isTokenInvalid(this.authStatus) || CopilotAuthStatusKt.isFailedToGetToken(this.authStatus) ? ContentType.SIGN_IN : (CopilotAuthStatusKt.isNotAuthorized(this.authStatus) ? ContentType.UNAUTHORIZED : (this.preconditions.status().isNotOk() ? ContentType.PRECONDITIONS : (CopilotAuthStatusKt.isUnknown(this.authStatus) ? ContentType.LOADING : (CopilotAuthStatusKt.isReady(this.authStatus) && this.preconditions.status().isOk() ? ContentType.CHAT : ContentType.LOADING))));
            if (newContentType.isPreconditions()) {
                jPanel = (JPanel)((Object)new ChatPreconditionsPanel(this.preconditions, this.preconditionService));
            } else if (newContentType.isChat()) {
                ChatSessionTransitionalComponent currentSessionComponent;
                Object object = this.chatSessionManager;
                ChatSessionTransitionalComponent chatSessionTransitionalComponent = object != null && (object = ((ChatSessionManager)object).getCurrentChatSessionController()) != null ? ((ChatSessionController)object).getComponent() : (currentSessionComponent = null);
                if (currentSessionComponent == null) {
                    jPanel = (JPanel)ChatInformationalPanelKt.chatInformationalPanel-6BmXuXk(PanelType.Companion.getLoadingPanel-fe9IJZ0());
                } else {
                    ChatSessionTransitionalComponent chatSessionTransitionalComponent2;
                    if (!Intrinsics.areEqual((Object)this.currentContent(), (Object)currentSessionComponent)) {
                        currentSessionComponent.getChatSessionComponent().getChatInputPanel().loadModel();
                        chatSessionTransitionalComponent2 = currentSessionComponent;
                    } else {
                        chatSessionTransitionalComponent2 = null;
                    }
                    jPanel = chatSessionTransitionalComponent2;
                }
            } else {
                jPanel = this.currentContentType == null || this.currentContentType != newContentType ? (JPanel)(newContentType.isLoading() ? ChatInformationalPanelKt.chatInformationalPanel-6BmXuXk(PanelType.Companion.getLoadingPanel-fe9IJZ0()) : (newContentType.isSignIn() ? ChatInformationalPanelKt.chatInformationalPanel-6BmXuXk(PanelType.Companion.getSignInPanel-fe9IJZ0()) : (newContentType.isUnauthorized() ? ChatInformationalPanelKt.chatInformationalPanel-6BmXuXk(PanelType.Companion.getUnauthorizedPanel-fe9IJZ0()) : null))) : null;
            }
            JPanel jPanel2 = newContent = jPanel;
            if (jPanel2 != null) {
                JPanel it = jPanel2;
                boolean bl2 = false;
                this.currentContentType = newContentType;
                this.replaceContent(newContent);
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            unit = unit2;
        }
        return unit;
    }

    private final Project getProject() {
        Project project;
        if (!this.toolWindow.getProject().isDisposed() && !this.toolWindow.getProject().isDefault()) {
            project = this.toolWindow.getProject();
        } else {
            project = ApplicationUtil.findCurrentProject();
            if (project == null) {
                project = ProjectKt.getProject();
            }
        }
        Project project2 = project;
        Intrinsics.checkNotNull((Object)project2);
        return project2;
    }

    private final void showToolWindow() {
        if (!(this.toolWindow.isDisposed() || this.toolWindow.getProject().isDisposed() || this.toolWindow.isVisible())) {
            this.toolWindow.show();
        }
    }

    private final JComponent currentContent() {
        Content[] contentArray = this.toolWindow.getContentManager().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        Content content = (Content)ArraysKt.firstOrNull((Object[])contentArray);
        return content != null ? content.getComponent() : null;
    }

    private final void setCurrentChatSession(ChatSessionController chatSessionController) {
        ChatSessionPersistenceService.DefaultImpls.updateActiveAt$default(chatSessionController.getPersistenceService(), chatSessionController.getSession().getId(), null, 2, null);
        this.updateUi();
    }

    private final void replaceContent(JComponent component2) {
        try {
            ContentFactory contentFactory = ContentFactory.getInstance();
            Content content = contentFactory.createContent(component2, "", false);
            Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
            Content copilotChatContent = content;
            if (this.toolWindow.isDisposed()) {
                this.log.debug("can not replace content, tool window has been disposed");
            } else if (this.toolWindow.getProject().isDisposed()) {
                this.log.debug("can not replace content, project has been disposed");
            } else {
                Project project = this.toolWindow.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                ToolWindowManager.Companion.getInstance(project).invokeLater(() -> CopilotChatToolWindow.replaceContent$lambda$10(this, copilotChatContent));
            }
        }
        catch (NullPointerException e) {
            this.log.warn("Failed to replace content in Copilot Chat tool window", e);
        }
    }

    private final void onProjectDisposed(Function0<Unit> block) {
        Project project = this.toolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ProjectKt.onDisposed(project, (Function0<Unit>)((Function0)() -> CopilotChatToolWindow.onProjectDisposed$lambda$11(block)));
    }

    private static final Unit subscribeToPreconditions$lambda$4(CopilotChatToolWindow this$0, ChatPreconditions it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.preconditions = it;
        this$0.updateUi();
        return Unit.INSTANCE;
    }

    private static final Unit subscribeToPreconditions$lambda$5(ChatPreconditionsSubscription $subscription) {
        $subscription.unsubscribe();
        return Unit.INSTANCE;
    }

    private static final Unit subscribeToAuthStatus$lambda$6(CopilotChatToolWindow this$0, CopilotAuthStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        this$0.preconditionService.refreshPreconditions((Function2<? super ChatPreconditions, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<ChatPreconditions, Continuation<? super Unit>, Object>(status, this$0, null){
            int label;
            final /* synthetic */ CopilotAuthStatus $status;
            final /* synthetic */ CopilotChatToolWindow this$0;
            {
                this.$status = $status;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (this.$status instanceof CopilotAuthStatus.Ready) {
                            CopilotChatToolWindow.access$onCopilotReady(this.this$0, ((CopilotAuthStatus.Ready)this.$status).getUser());
                        }
                        CopilotChatToolWindow.access$setAuthStatus$p(this.this$0, this.$status);
                        CopilotChatToolWindow.access$updateUi(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(ChatPreconditions p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final void replaceContent$lambda$10(CopilotChatToolWindow this$0, Content $copilotChatContent) {
        this$0.toolWindow.getContentManager().removeAllContents(true);
        this$0.toolWindow.getContentManager().addContent($copilotChatContent);
    }

    private static final Unit onProjectDisposed$lambda$11(Function0 $block) {
        $block.invoke();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$onCopilotReady(CopilotChatToolWindow $this, GitHubUser user) {
        $this.onCopilotReady(user);
    }

    public static final /* synthetic */ void access$setAuthStatus$p(CopilotChatToolWindow $this, CopilotAuthStatus copilotAuthStatus) {
        $this.authStatus = copilotAuthStatus;
    }

    public static final /* synthetic */ Unit access$updateUi(CopilotChatToolWindow $this) {
        return $this.updateUi();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/copilot/chat/window/CopilotChatToolWindow$Companion;", "", "<init>", "()V", "ID", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

