/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.window.actions;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotIcons;
import com.github.copilot.chat.session.ChatSessionController;
import com.github.copilot.chat.session.component.ChatSessionPopupComponent;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/github/copilot/chat/window/actions/ConversationHistoryAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "chatSessionController", "Lcom/github/copilot/chat/session/ChatSessionController;", "component", "Ljava/awt/Component;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "<init>", "(Lcom/github/copilot/chat/session/ChatSessionController;Ljava/awt/Component;Lcom/github/copilot/platform/utils/observability/Logger;)V", "getChatSessionController", "()Lcom/github/copilot/chat/session/ChatSessionController;", "getComponent", "()Ljava/awt/Component;", "horizontalMargin", "", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "core"})
@SourceDebugExtension(value={"SMAP\nConversationHistoryAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversationHistoryAction.kt\ncom/github/copilot/chat/window/actions/ConversationHistoryAction\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,55:1\n39#2:56\n*S KotlinDebug\n*F\n+ 1 ConversationHistoryAction.kt\ncom/github/copilot/chat/window/actions/ConversationHistoryAction\n*L\n20#1:56\n*E\n"})
public final class ConversationHistoryAction
extends AnAction {
    @NotNull
    private final ChatSessionController chatSessionController;
    @NotNull
    private final Component component;
    @NotNull
    private final Logger log;
    private final int horizontalMargin;
    @Nullable
    private JBPopup popup;

    public ConversationHistoryAction(@NotNull ChatSessionController chatSessionController, @NotNull Component component2, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)chatSessionController, (String)"chatSessionController");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        super(CopilotBundle.get("copilot.chat.session.action.conversation.history"), CopilotBundle.get("copilot.chat.session.action.conversation.history.description"), CopilotIcons.History);
        this.chatSessionController = chatSessionController;
        this.component = component2;
        this.log = log;
        this.horizontalMargin = 16;
    }

    public /* synthetic */ ConversationHistoryAction(ChatSessionController chatSessionController, Component component2, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(ConversationHistoryAction.class);
        }
        this(chatSessionController, component2, logger);
    }

    @NotNull
    public final ChatSessionController getChatSessionController() {
        return this.chatSessionController;
    }

    @NotNull
    public final Component getComponent() {
        return this.component;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.log.trace("Opening chat session history popup where the current session is " + this.chatSessionController.getSession().getName().getValue() + ".");
        ChatSessionPopupComponent popupComponent = new ChatSessionPopupComponent(event.getProject(), this.chatSessionController, () -> ConversationHistoryAction.actionPerformed$lambda$0(this), () -> ConversationHistoryAction.actionPerformed$lambda$1(this), () -> ConversationHistoryAction.actionPerformed$lambda$2(this), () -> ConversationHistoryAction.actionPerformed$lambda$3(this), null, 64, null);
        JBPopup jBPopup = this.popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)popupComponent, null).setFocusable(true).setRequestFocus(true).setCancelKeyEnabled(true).setMinSize(new Dimension(this.component.getWidth() - this.horizontalMargin * 2, 0)).createPopup();
        Intrinsics.checkNotNull((Object)jBPopup);
        jBPopup.showInScreenCoordinates(this.component, new Point(this.component.getLocationOnScreen().x + this.horizontalMargin, this.component.getLocationOnScreen().y + 28));
    }

    private static final Unit actionPerformed$lambda$0(ConversationHistoryAction this$0) {
        block0: {
            JBPopup jBPopup = this$0.popup;
            if (jBPopup == null) break block0;
            jBPopup.cancel();
        }
        return Unit.INSTANCE;
    }

    private static final Unit actionPerformed$lambda$1(ConversationHistoryAction this$0) {
        block0: {
            JBPopup jBPopup = this$0.popup;
            if (jBPopup == null) break block0;
            jBPopup.cancel();
        }
        return Unit.INSTANCE;
    }

    private static final Unit actionPerformed$lambda$2(ConversationHistoryAction this$0) {
        block0: {
            JBPopup jBPopup = this$0.popup;
            if (jBPopup == null) break block0;
            jBPopup.cancel();
        }
        return Unit.INSTANCE;
    }

    private static final Unit actionPerformed$lambda$3(ConversationHistoryAction this$0) {
        block0: {
            JBPopup jBPopup = this$0.popup;
            if (jBPopup == null) break block0;
            jBPopup.cancel();
        }
        return Unit.INSTANCE;
    }
}

