/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.completions;

import com.github.copilot.completions.CopilotInlayList;
import com.github.copilot.editor.CopilotApplyInlayStrategy;
import com.intellij.openapi.util.TextRange;

public class CompletionSplitter {
    private final CopilotApplyInlayStrategy applyStrategy;

    public CompletionSplitter(CopilotApplyInlayStrategy boundaryStrategy) {
        this.applyStrategy = boundaryStrategy;
    }

    public String split(CopilotInlayList completion) {
        TextRange range = completion.getReplacementRange();
        String fullCompletion = completion.getReplacementText();
        switch (this.applyStrategy) {
            case NEXT_WORD: {
                return this.splitNextWord(fullCompletion, range.getEndOffset() - range.getStartOffset());
            }
            case NEXT_LINE: {
                int nextNewline = fullCompletion.indexOf(10, range.getEndOffset() - range.getStartOffset());
                return fullCompletion.substring(0, nextNewline == -1 ? fullCompletion.length() : nextNewline + 1);
            }
        }
        return completion.getReplacementText();
    }

    private String splitNextWord(String fullCompletion, int offset) {
        if (offset >= fullCompletion.length()) {
            return fullCompletion;
        }
        int whitespaceBlock = this.findContinuousBlock(fullCompletion, offset, Character::isWhitespace);
        if (whitespaceBlock != -1) {
            return fullCompletion.substring(0, whitespaceBlock);
        }
        int symbolBlock = this.findContinuousBlock(fullCompletion, offset, this::isBoundaryCharacter);
        if (symbolBlock != -1) {
            return fullCompletion.substring(0, symbolBlock);
        }
        int otherBlock = this.findContinuousBlock(fullCompletion, offset, c -> !this.isBoundaryCharacter(c) && !Character.isWhitespace(c));
        if (otherBlock != -1) {
            return fullCompletion.substring(0, otherBlock);
        }
        return fullCompletion;
    }

    private int findContinuousBlock(String fullCompletion, int offset, BoundaryFinder isBoundaryCharacter) {
        int endIndex;
        if (!isBoundaryCharacter.isBoundaryCharacter(fullCompletion.charAt(offset))) {
            return -1;
        }
        for (endIndex = offset; endIndex < fullCompletion.length() && isBoundaryCharacter.isBoundaryCharacter(fullCompletion.charAt(endIndex)); ++endIndex) {
        }
        return endIndex;
    }

    private boolean isBoundaryCharacter(char c) {
        return "~!@#$%^&*()-=+[{]}\\|;:'\",.<>/?".indexOf(c) != -1;
    }

    static interface BoundaryFinder {
        public boolean isBoundaryCharacter(char var1);
    }
}

