/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.completions;

import com.github.copilot.completions.CopilotCompletion;
import com.github.copilot.completions.CopilotCompletionType;
import com.github.copilot.completions.CopilotEditorInlay;
import com.github.copilot.completions.CopilotInlayList;
import com.github.copilot.completions.DefaultCopilotEditorInlay;
import com.github.copilot.completions.DefaultInlayList;
import com.github.copilot.lang.CommonLanguageSupport;
import com.github.copilot.request.EditorRequest;
import com.github.copilot.request.LineInfo;
import com.github.copilot.util.CopilotStringUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionUtil {
    private static final Logger LOG = Logger.getInstance(CompletionUtil.class);

    static List<CopilotInlayList> createEditorCompletions(@NotNull EditorRequest request, @NotNull List<CopilotCompletion> items) {
        return items.stream().map(item -> CompletionUtil.createEditorCompletion(request, item, true)).collect(Collectors.toList());
    }

    @Nullable
    public static CopilotInlayList createEditorCompletion(@NotNull EditorRequest request, @NotNull CopilotCompletion copilotCompletion, boolean dropLinePrefix) {
        boolean replaceLinePrefix;
        ArrayList<String> lines = new ArrayList<String>(copilotCompletion.getCompletion());
        if (lines.isEmpty() || lines.size() == 1 && (lines.get(0).isEmpty() || lines.get(0).equals("\n"))) {
            LOG.debug("ignoring empty completion: " + String.valueOf(request));
            return null;
        }
        CompletionUtil.dropOverlappingTrailingLines(lines, request.getDocumentContent(), request.getOffset());
        if (lines.isEmpty()) {
            return null;
        }
        String replacementText = CompletionUtil.createReplacementText(request.getLineInfo(), lines);
        boolean bl = replaceLinePrefix = dropLinePrefix && CompletionUtil.adjustWhitespace(lines, request.getLineInfo());
        if (lines.isEmpty()) {
            return null;
        }
        return new DefaultInlayList(copilotCompletion, CompletionUtil.createReplacementRange(request, replaceLinePrefix), replacementText, CompletionUtil.createEditorInlays(request, lines));
    }

    @NotNull
    private static String createReplacementText(@NotNull LineInfo lineInfo, List<String> lines) {
        String ws;
        String text = StringUtil.join(lines, (String)"\n");
        if (!lineInfo.isBlankLine() && text.startsWith(ws = lineInfo.getWhitespaceBeforeCursor())) {
            return text.substring(ws.length());
        }
        return text;
    }

    @NotNull
    private static TextRange createReplacementRange(@NotNull EditorRequest request, boolean replaceLinePrefix) {
        LineInfo lineInfo = request.getLineInfo();
        int startOffset = replaceLinePrefix ? lineInfo.getLineStartOffset() : request.getOffset();
        int endOffset = CompletionUtil.isReplaceLineSuffix(request) ? lineInfo.getLineEndOffset() - CopilotStringUtil.trailingWhitespaceLength(lineInfo.getLineSuffix()) : request.getOffset();
        return TextRange.create((int)startOffset, (int)endOffset);
    }

    private static boolean isReplaceLineSuffix(@NotNull EditorRequest request) {
        String lineSuffix = request.getLineInfo().getLineSuffix();
        return CopilotStringUtil.isSpacesOrTabs(lineSuffix, false) || CommonLanguageSupport.isValidMiddleOfTheLinePosition(lineSuffix);
    }

    @NotNull
    private static List<CopilotEditorInlay> createEditorInlays(@NotNull EditorRequest request, @NotNull List<String> lines) {
        ArrayList<CopilotEditorInlay> inlays = new ArrayList<CopilotEditorInlay>();
        int offset = request.getOffset();
        if (lines.size() > 1 && request.getLineInfo().isBlankLine() && lines.get(0).isEmpty()) {
            inlays.add(new DefaultCopilotEditorInlay(CopilotCompletionType.Block, offset, lines.subList(1, lines.size())));
        } else {
            String completionLine;
            String editorLineSuffix = request.getLineInfo().getLineSuffix();
            List<Pair<Integer, String>> diffs = CopilotStringUtil.createDiffInlays(editorLineSuffix, completionLine = lines.get(0));
            if (diffs != null && !diffs.isEmpty()) {
                for (Pair<Integer, String> diff : diffs) {
                    Integer delta = (Integer)diff.getFirst();
                    inlays.add(new DefaultCopilotEditorInlay(CopilotCompletionType.Inline, offset + delta, List.of((String)diff.second)));
                }
            }
            if (lines.size() > 1) {
                inlays.add(new DefaultCopilotEditorInlay(CopilotCompletionType.Block, offset, lines.subList(1, lines.size())));
            }
        }
        return inlays;
    }

    private static boolean dropOverlappingTrailingLines(@NotNull List<String> lines, @NotNull String editorContent, int offset) {
        if (offset < editorContent.length() && editorContent.charAt(offset) == '\n') {
            ++offset;
        }
        if (offset >= editorContent.length()) {
            return false;
        }
        List<String> editorLines = CopilotStringUtil.getNextLines(editorContent, offset, lines.size());
        int overlap = CopilotStringUtil.findOverlappingLines(lines, editorLines);
        for (int i = 0; i < overlap; ++i) {
            lines.remove(lines.size() - 1);
        }
        return overlap >= 1;
    }

    public static String dropOverlappingTrailingLines(@NotNull String linesString, @NotNull String editorContent, int offset) {
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(CopilotStringUtil.splitLines(linesString)));
        return CompletionUtil.dropOverlappingTrailingLines(lines, editorContent, offset) ? StringUtil.join(lines, (String)"\n") : linesString;
    }

    private static boolean adjustWhitespace(@NotNull List<String> completionLines, @NotNull LineInfo lineInfo) {
        String firstLine;
        String editorWhitespacePrefix = lineInfo.getWhitespaceBeforeCursor();
        if (completionLines.isEmpty() || editorWhitespacePrefix.isEmpty()) {
            return false;
        }
        boolean isEditorEmptyLine = lineInfo.isBlankLine();
        boolean replacePrefixInEditor = false;
        String firstLineFixed = firstLine = completionLines.get(0);
        if (firstLine.startsWith(editorWhitespacePrefix)) {
            firstLineFixed = firstLine.substring(editorWhitespacePrefix.length());
            replacePrefixInEditor = isEditorEmptyLine;
        } else if (isEditorEmptyLine) {
            String lineLeadingWhitespace = CopilotStringUtil.leadingWhitespace(firstLine);
            firstLineFixed = firstLine.substring(lineLeadingWhitespace.length());
            replacePrefixInEditor = !firstLine.isEmpty() && !lineLeadingWhitespace.startsWith(editorWhitespacePrefix);
        }
        completionLines.set(0, firstLineFixed);
        return replacePrefixInEditor;
    }
}

