/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.editor;

import com.github.copilot.editor.CompletionRequestType;
import com.github.copilot.editor.CopilotEditorActionTracker;
import com.github.copilot.editor.CopilotEditorManager;
import com.github.copilot.editor.CopilotEditorUtil;
import com.github.copilot.editor.InlayDisposeContext;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class CopilotCommandListener
implements CommandListener {
    private static final Logger LOG = Logger.getInstance(CopilotCommandListener.class);
    private static final Key<CommandEditorState> COMMAND_STATE_KEY = Key.create((String)"copilot.commandState");
    private final Project project;
    private final AtomicInteger activeCommands = new AtomicInteger();
    private final AtomicBoolean startedWithEditor = new AtomicBoolean(false);
    private final AtomicReference<UndoTransparentActionState> undoTransparentActionStamp = new AtomicReference();

    public CopilotCommandListener(@NotNull Project project) {
        this.project = project;
    }

    public void commandStarted(@NotNull CommandEvent event) {
        if (this.activeCommands.getAndIncrement() > 0) {
            LOG.debug("Skipping nested commandStarted. Event: " + String.valueOf(event));
            return;
        }
        Editor editor = CopilotEditorUtil.getSelectedEditorSafely(this.project);
        if (editor != null) {
            this.startedWithEditor.set(true);
            COMMAND_STATE_KEY.set((UserDataHolder)editor, (Object)CopilotCommandListener.createCommandState(editor));
        } else {
            this.startedWithEditor.set(false);
        }
    }

    public void commandFinished(@NotNull CommandEvent event) {
        if (this.activeCommands.decrementAndGet() > 0) {
            LOG.debug("Skipping nested commandFinished. Event: " + String.valueOf(event));
            return;
        }
        if (CopilotEditorActionTracker.getInstance().isExecutingForcedCompletionAction()) {
            LOG.debug("Skipping command because editor action listener will enforce completion");
            return;
        }
        if (!this.startedWithEditor.get()) {
            return;
        }
        Editor editor = CopilotEditorUtil.getSelectedEditorSafely(this.project);
        if (editor == null) {
            return;
        }
        CopilotEditorManager editorManager = CopilotEditorManager.getInstance();
        if (!editorManager.isAvailable(editor)) {
            return;
        }
        CommandEditorState commandStartState = (CommandEditorState)COMMAND_STATE_KEY.get((UserDataHolder)editor);
        if (commandStartState != null) {
            CommandEditorState commandEndState = CopilotCommandListener.createCommandState(editor);
            if (CopilotCommandListener.isDocumentModification(commandStartState, commandEndState)) {
                LOG.debug("command modified document: " + event.getCommandName());
                editorManager.editorModified(editor, CompletionRequestType.Automatic);
            } else if (CopilotCommandListener.isCaretPositionChange(commandStartState, commandEndState)) {
                editorManager.disposeInlays(editor, InlayDisposeContext.CaretChange);
            }
        }
    }

    public void undoTransparentActionStarted() {
        Editor editor = CopilotEditorUtil.getSelectedEditorSafely(this.project);
        this.undoTransparentActionStamp.set(editor != null ? CopilotCommandListener.createUndoTransparentState(editor) : null);
    }

    public void undoTransparentActionFinished() {
        UndoTransparentActionState currentEditorStamp = this.undoTransparentActionStamp.get();
        this.undoTransparentActionStamp.set(null);
        Editor editor = CopilotEditorUtil.getSelectedEditorSafely(this.project);
        if (editor == null || currentEditorStamp == null || editor != currentEditorStamp.editor) {
            return;
        }
        if (CopilotCommandListener.getDocumentStamp(editor.getDocument()) == currentEditorStamp.modificationStamp) {
            return;
        }
        CopilotEditorManager editorManager = CopilotEditorManager.getInstance();
        if (editorManager.isAvailable(editor) && editorManager.hasCompletionInlays(editor)) {
            editorManager.editorModified(editor, CompletionRequestType.Forced);
        }
    }

    private static long getDocumentStamp(@NotNull Document document) {
        if (document instanceof DocumentEx) {
            return ((DocumentEx)document).getModificationSequence();
        }
        return document.getModificationStamp();
    }

    @NotNull
    private static CommandEditorState createCommandState(@NotNull Editor editor) {
        return new CommandEditorState(CopilotCommandListener.getDocumentStamp(editor.getDocument()), editor.getCaretModel().getVisualPosition());
    }

    @NotNull
    private static UndoTransparentActionState createUndoTransparentState(@NotNull Editor editor) {
        return new UndoTransparentActionState(editor, CopilotCommandListener.getDocumentStamp(editor.getDocument()));
    }

    private static boolean isDocumentModification(@NotNull CommandEditorState first, @NotNull CommandEditorState second) {
        return first.modificationStamp != second.modificationStamp;
    }

    private static boolean isCaretPositionChange(@NotNull CommandEditorState first, @NotNull CommandEditorState second) {
        return !first.visualPosition.equals((Object)second.visualPosition);
    }

    private static final class CommandEditorState {
        private final long modificationStamp;
        private final VisualPosition visualPosition;

        @Generated
        public CommandEditorState(long modificationStamp, VisualPosition visualPosition) {
            this.modificationStamp = modificationStamp;
            this.visualPosition = visualPosition;
        }

        @Generated
        public long getModificationStamp() {
            return this.modificationStamp;
        }

        @Generated
        public VisualPosition getVisualPosition() {
            return this.visualPosition;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CommandEditorState)) {
                return false;
            }
            CommandEditorState other = (CommandEditorState)o;
            if (this.getModificationStamp() != other.getModificationStamp()) {
                return false;
            }
            VisualPosition this$visualPosition = this.getVisualPosition();
            VisualPosition other$visualPosition = other.getVisualPosition();
            return !(this$visualPosition == null ? other$visualPosition != null : !this$visualPosition.equals(other$visualPosition));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $modificationStamp = this.getModificationStamp();
            result = result * 59 + (int)($modificationStamp >>> 32 ^ $modificationStamp);
            VisualPosition $visualPosition = this.getVisualPosition();
            result = result * 59 + ($visualPosition == null ? 43 : $visualPosition.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CopilotCommandListener.CommandEditorState(modificationStamp=" + this.getModificationStamp() + ", visualPosition=" + String.valueOf(this.getVisualPosition()) + ")";
        }
    }

    private static final class UndoTransparentActionState {
        @NotNull
        private final Editor editor;
        private final long modificationStamp;

        @Generated
        public UndoTransparentActionState(@NotNull Editor editor, long modificationStamp) {
            if (editor == null) {
                throw new NullPointerException("editor is marked non-null but is null");
            }
            this.editor = editor;
            this.modificationStamp = modificationStamp;
        }

        @NotNull
        @Generated
        public Editor getEditor() {
            return this.editor;
        }

        @Generated
        public long getModificationStamp() {
            return this.modificationStamp;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UndoTransparentActionState)) {
                return false;
            }
            UndoTransparentActionState other = (UndoTransparentActionState)o;
            if (this.getModificationStamp() != other.getModificationStamp()) {
                return false;
            }
            Editor this$editor = this.getEditor();
            Editor other$editor = other.getEditor();
            return !(this$editor == null ? other$editor != null : !this$editor.equals(other$editor));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $modificationStamp = this.getModificationStamp();
            result = result * 59 + (int)($modificationStamp >>> 32 ^ $modificationStamp);
            Editor $editor = this.getEditor();
            result = result * 59 + ($editor == null ? 43 : $editor.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CopilotCommandListener.UndoTransparentActionState(editor=" + String.valueOf(this.getEditor()) + ", modificationStamp=" + this.getModificationStamp() + ")";
        }
    }
}

