/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.editor;

import com.github.copilot.completions.CopilotCompletionType;
import com.github.copilot.editor.CopilotInlayRenderer;
import com.github.copilot.editor.InlayRendering;
import com.github.copilot.request.EditorRequest;
import com.github.copilot.settings.CopilotApplicationSettings;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CopilotDefaultInlayRenderer
implements CopilotInlayRenderer {
    @NotNull
    private final List<String> lines;
    @NotNull
    private final String content;
    @NotNull
    private final CopilotCompletionType type;
    @NotNull
    private final TextAttributes textAttributes;
    @Nullable
    private Inlay<CopilotInlayRenderer> inlay;
    private int cachedWidth = -1;
    private int cachedHeight = -1;

    CopilotDefaultInlayRenderer(@NotNull Editor editor, @NotNull EditorRequest request, @NotNull CopilotCompletionType type, @NotNull List<String> lines) {
        this.lines = CopilotDefaultInlayRenderer.replaceLeadingTabs(lines, request);
        this.type = type;
        this.content = StringUtils.join(lines, (String)"\n");
        this.textAttributes = CopilotDefaultInlayRenderer.getTextAttributes(editor);
    }

    @Override
    @Nullable
    public Inlay<CopilotInlayRenderer> getInlay() {
        return this.inlay;
    }

    public void setInlay(@NotNull Inlay<CopilotInlayRenderer> inlay) {
        this.inlay = inlay;
    }

    @Override
    @NotNull
    public CopilotCompletionType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public List<String> getContentLines() {
        return this.lines;
    }

    @Nullable
    @NonNls
    public String getContextMenuGroupId(@NotNull Inlay inlay) {
        return "copilot.inlayContextMenu";
    }

    public int calcHeightInPixels(@NotNull Inlay inlay) {
        if (this.cachedHeight < 0) {
            this.cachedHeight = inlay.getEditor().getLineHeight() * this.lines.size();
            return this.cachedHeight;
        }
        return this.cachedHeight;
    }

    public int calcWidthInPixels(@NotNull Inlay inlay) {
        if (this.cachedWidth < 0) {
            int width = InlayRendering.calculateWidth(inlay.getEditor(), this.content, this.lines);
            this.cachedWidth = Math.max(1, width);
            return this.cachedWidth;
        }
        return this.cachedWidth;
    }

    public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle region, @NotNull TextAttributes surroundingTextAttributes) {
        Editor editor = inlay.getEditor();
        if (editor.isDisposed()) {
            return;
        }
        InlayRendering.renderCodeBlock(editor, this.content, this.lines, g, region, this.textAttributes);
    }

    static List<String> replaceLeadingTabs(@NotNull List<String> lines, @NotNull EditorRequest request) {
        return lines.stream().map(line -> {
            int tabCount = StringUtil.countChars((CharSequence)line, (char)'\t', (int)0, (boolean)true);
            if (tabCount > 0) {
                String tabSpaces = StringUtil.repeatSymbol((char)' ', (int)(tabCount * request.getTabWidth()));
                return tabSpaces + line.substring(tabCount);
            }
            return line;
        }).collect(Collectors.toList());
    }

    @NotNull
    private static TextAttributes getTextAttributes(@NotNull Editor editor) {
        TextAttributes customAttributes;
        Color userColor = CopilotApplicationSettings.settings().inlayTextColor;
        EditorColorsScheme scheme = editor.getColorsScheme();
        TextAttributes themeAttributes = scheme.getAttributes(DefaultLanguageHighlighterColors.INLAY_TEXT_WITHOUT_BACKGROUND);
        if (userColor == null && themeAttributes != null && themeAttributes.getForegroundColor() != null) {
            return themeAttributes;
        }
        TextAttributes textAttributes = customAttributes = themeAttributes != null ? themeAttributes.clone() : new TextAttributes();
        if (userColor != null) {
            customAttributes.setForegroundColor(userColor);
        }
        if (customAttributes.getForegroundColor() == null) {
            customAttributes.setForegroundColor((Color)JBColor.GRAY);
        }
        return customAttributes;
    }

    @NotNull
    @Generated
    public List<String> getLines() {
        return this.lines;
    }

    @NotNull
    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public void setCachedWidth(int cachedWidth) {
        this.cachedWidth = cachedWidth;
    }

    @Generated
    public void setCachedHeight(int cachedHeight) {
        this.cachedHeight = cachedHeight;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CopilotDefaultInlayRenderer)) {
            return false;
        }
        CopilotDefaultInlayRenderer other = (CopilotDefaultInlayRenderer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.cachedWidth != other.cachedWidth) {
            return false;
        }
        if (this.cachedHeight != other.cachedHeight) {
            return false;
        }
        List<String> this$lines = this.getLines();
        List<String> other$lines = other.getLines();
        if (this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        CopilotCompletionType this$type = this.getType();
        CopilotCompletionType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        TextAttributes this$textAttributes = this.textAttributes;
        TextAttributes other$textAttributes = other.textAttributes;
        if (this$textAttributes == null ? other$textAttributes != null : !this$textAttributes.equals(other$textAttributes)) {
            return false;
        }
        Inlay<CopilotInlayRenderer> this$inlay = this.getInlay();
        Inlay<CopilotInlayRenderer> other$inlay = other.getInlay();
        return !(this$inlay == null ? other$inlay != null : !this$inlay.equals(other$inlay));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CopilotDefaultInlayRenderer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.cachedWidth;
        result = result * 59 + this.cachedHeight;
        List<String> $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        CopilotCompletionType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        TextAttributes $textAttributes = this.textAttributes;
        result = result * 59 + ($textAttributes == null ? 43 : $textAttributes.hashCode());
        Inlay<CopilotInlayRenderer> $inlay = this.getInlay();
        result = result * 59 + ($inlay == null ? 43 : $inlay.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CopilotDefaultInlayRenderer(lines=" + String.valueOf(this.getLines()) + ", content=" + this.getContent() + ", type=" + String.valueOf((Object)this.getType()) + ", textAttributes=" + String.valueOf(this.textAttributes) + ", cachedWidth=" + this.cachedWidth + ", cachedHeight=" + this.cachedHeight + ")";
    }
}

