/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.editor;

import com.github.copilot.editor.CompletionRequestType;
import com.github.copilot.editor.CopilotEditorManager;
import com.github.copilot.editor.CopilotEditorUtil;
import com.intellij.ide.actions.UndoRedoAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.CutAction;
import com.intellij.openapi.project.Project;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public final class CopilotEditorActionTracker {
    private static final Logger LOG = Logger.getInstance(CopilotEditorActionTracker.class);
    private final AtomicInteger executingForcedCompletionAction = new AtomicInteger(0);

    @NotNull
    public static CopilotEditorActionTracker getInstance() {
        return (CopilotEditorActionTracker)ApplicationManager.getApplication().getService(CopilotEditorActionTracker.class);
    }

    public boolean isExecutingForcedCompletionAction() {
        return this.executingForcedCompletionAction.get() > 0;
    }

    private void enterForcedCompletionAction() {
        this.executingForcedCompletionAction.incrementAndGet();
    }

    private void exitForcedCompletionAction() {
        int newValue = this.executingForcedCompletionAction.decrementAndGet();
        assert (newValue >= 0);
    }

    private static boolean isForcedCompletionAction(@NotNull AnAction action2) {
        return action2 instanceof CutAction || action2 instanceof UndoRedoAction;
    }

    public static final class ActionListener
    implements AnActionListener {
        private final AtomicReference<Editor> currentActionEditor = new AtomicReference<Object>(null);

        public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(event.getDataContext());
            this.currentActionEditor.set(editor != null && CopilotEditorManager.getInstance().isAvailable(editor) ? editor : null);
            if (CopilotEditorActionTracker.isForcedCompletionAction(action2)) {
                CopilotEditorActionTracker.getInstance().enterForcedCompletionAction();
            }
        }

        public void afterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result) {
            if (CopilotEditorActionTracker.isForcedCompletionAction(action2)) {
                CopilotEditorManager editorManager;
                Project project;
                Editor editor;
                CopilotEditorActionTracker.getInstance().exitForcedCompletionAction();
                if (!CopilotEditorActionTracker.getInstance().isExecutingForcedCompletionAction() && (editor = this.currentActionEditor.get()) != null && !editor.isDisposed() && CopilotEditorUtil.isSelectedEditor(editor) && (project = editor.getProject()) != null && !project.isDisposed() && (editorManager = CopilotEditorManager.getInstance()).isAvailable(editor)) {
                    LOG.debug("Forcing editor completion update");
                    editorManager.editorModified(editor, CompletionRequestType.Forced);
                }
            }
        }
    }
}

