/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.editor;

import com.github.copilot.editor.CompletionRequestType;
import com.github.copilot.editor.CopilotEditorManager;
import com.github.copilot.editor.CopilotEditorUtil;
import com.github.copilot.editor.InlayDisposeContext;
import com.github.copilot.editor.TypeOverHandler;
import com.github.copilot.settings.CopilotApplicationSettings;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;

public class CopilotEditorListener
implements EditorFactoryListener {
    private final CopilotSelectionListener selectionListener = new CopilotSelectionListener();

    public void editorCreated(@NotNull EditorFactoryEvent event) {
        Editor editor = event.getEditor();
        Project project = editor.getProject();
        if (project == null || project.isDisposed() || !CopilotEditorManager.getInstance().isAvailable(editor)) {
            return;
        }
        Disposable editorDisposable = Disposer.newDisposable((String)"copilotEditorListener");
        EditorUtil.disposeWithEditor((Editor)editor, (Disposable)editorDisposable);
        editor.getCaretModel().addCaretListener((CaretListener)new CopilotCaretListener(editor), editorDisposable);
        editor.getDocument().addDocumentListener((DocumentListener)new CopilotDocumentListener(editor), editorDisposable);
        editor.getSelectionModel().addSelectionListener((SelectionListener)this.selectionListener, editorDisposable);
    }

    private static class CopilotSelectionListener
    implements SelectionListener {
        private CopilotSelectionListener() {
        }

        public void selectionChanged(@NotNull SelectionEvent e) {
            Editor editor = e.getEditor();
            Project project = editor.getProject();
            if (project == null || project.isDisposed()) {
                return;
            }
            if (!CopilotEditorUtil.isSelectedEditor(editor)) {
                return;
            }
            CopilotEditorManager.getInstance().disposeInlays(editor, InlayDisposeContext.SelectionChange);
        }
    }

    private static final class CopilotCaretListener
    implements CaretListener {
        @NotNull
        private final Editor editor;

        public CopilotCaretListener(@NotNull Editor editor) {
            this.editor = editor;
        }

        public void caretPositionChanged(@NotNull CaretEvent event) {
            Project project = this.editor.getProject();
            if (project == null || project.isDisposed()) {
                return;
            }
            boolean wasTypeOver = TypeOverHandler.getPendingTypeOverAndReset(this.editor);
            if (wasTypeOver) {
                CopilotEditorManager.getInstance().editorModified(this.editor, CompletionRequestType.Forced);
                return;
            }
            if (CommandProcessor.getInstance().getCurrentCommand() != null) {
                return;
            }
            if (CopilotApplicationSettings.settings().isShowIdeCompletions() && LookupManager.getActiveLookup((Editor)this.editor) != null) {
                if (CopilotEditorManager.getInstance().hasCompletionInlays(this.editor)) {
                    CopilotEditorManager.getInstance().editorModified(this.editor, CompletionRequestType.Automatic);
                }
                return;
            }
            CopilotEditorManager.getInstance().disposeInlays(this.editor, InlayDisposeContext.CaretChange);
        }
    }

    private static final class CopilotDocumentListener
    implements BulkAwareDocumentListener {
        @NotNull
        private final Editor editor;

        public CopilotDocumentListener(@NotNull Editor editor) {
            this.editor = editor;
        }

        public void documentChangedNonBulk(@NotNull DocumentEvent event) {
            Project project = this.editor.getProject();
            if (project == null || project.isDisposed()) {
                return;
            }
            if (!CopilotEditorUtil.isSelectedEditor(this.editor)) {
                return;
            }
            CopilotEditorManager editorManager = CopilotEditorManager.getInstance();
            if (!editorManager.isAvailable(this.editor)) {
                return;
            }
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            if (commandProcessor.isUndoTransparentActionInProgress()) {
                return;
            }
            if (commandProcessor.getCurrentCommandName() != null) {
                return;
            }
            int changeOffset = event.getOffset() + event.getNewLength();
            if (this.editor.getCaretModel().getOffset() != changeOffset) {
                return;
            }
            CompletionRequestType requestType = event.getOldLength() != event.getNewLength() ? CompletionRequestType.Forced : CompletionRequestType.Automatic;
            editorManager.editorModified(this.editor, changeOffset, requestType);
        }
    }
}

