/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.editor;

import com.github.copilot.completions.CopilotInlayList;
import com.github.copilot.editor.CompletionRequestType;
import com.github.copilot.editor.CopilotApplyInlayStrategy;
import com.github.copilot.editor.CopilotInlayRenderer;
import com.github.copilot.editor.InlayDisposeContext;
import com.github.copilot.request.EditorRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface CopilotEditorManager
extends Disposable {
    @NotNull
    public static CopilotEditorManager getInstance() {
        return (CopilotEditorManager)ApplicationManager.getApplication().getService(CopilotEditorManager.class);
    }

    @RequiresEdt
    public boolean isAvailable(@NotNull Editor var1);

    @RequiresEdt
    default public boolean hasCompletionInlays(@NotNull Editor editor) {
        if (!this.isAvailable(editor)) {
            return false;
        }
        return this.countCompletionInlays(editor, TextRange.from((int)0, (int)editor.getDocument().getTextLength()), true, true, true, true) > 0L;
    }

    @RequiresEdt
    public long countCompletionInlays(@NotNull Editor var1, @NotNull TextRange var2, boolean var3, boolean var4, boolean var5, boolean var6);

    @RequiresEdt
    public boolean applyCompletion(@NotNull Editor var1, CopilotApplyInlayStrategy var2);

    @RequiresEdt
    public void applyCompletion(@NotNull Project var1, @NotNull Editor var2, @NotNull EditorRequest var3, @NotNull CopilotInlayList var4, @NotNull CopilotApplyInlayStrategy var5);

    @RequiresEdt
    public void disposeInlays(@NotNull Editor var1, @NotNull InlayDisposeContext var2);

    default public void editorModified(@NotNull Editor editor, @NotNull CompletionRequestType requestType) {
        this.editorModified(editor, editor.getCaretModel().getOffset(), requestType);
    }

    @RequiresEdt
    public void editorModified(@NotNull Editor var1, int var2, @NotNull CompletionRequestType var3);

    @RequiresEdt
    public void cancelCompletionRequests(@NotNull Editor var1);

    @NotNull
    @RequiresEdt
    public List<CopilotInlayRenderer> collectInlays(@NotNull Editor var1, int var2, int var3);

    public boolean hasNextInlaySet(@NotNull Editor var1);

    public boolean hasPreviousInlaySet(@NotNull Editor var1);

    public void showNextInlaySet(@NotNull Editor var1);

    public void showPreviousInlaySet(@NotNull Editor var1);
}

