/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.editor;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotPlugin;
import com.github.copilot.completions.CompletionSplitter;
import com.github.copilot.completions.CopilotCompletion;
import com.github.copilot.completions.CopilotCompletionService;
import com.github.copilot.completions.CopilotEditorInlay;
import com.github.copilot.completions.CopilotInlayList;
import com.github.copilot.editor.CancellableAlarm;
import com.github.copilot.editor.CompletionRequestType;
import com.github.copilot.editor.CompletionsRejectedMessage;
import com.github.copilot.editor.CopilotApplyInlayStrategy;
import com.github.copilot.editor.CopilotDefaultInlayRenderer;
import com.github.copilot.editor.CopilotEditorManager;
import com.github.copilot.editor.CopilotEditorSaveVetoer;
import com.github.copilot.editor.CopilotEditorSupport;
import com.github.copilot.editor.CopilotEditorUtil;
import com.github.copilot.editor.CopilotInlayListener;
import com.github.copilot.editor.CopilotInlayRenderer;
import com.github.copilot.editor.EditorRequestResultList;
import com.github.copilot.editor.EditorRequestsCancelledMessage;
import com.github.copilot.editor.InlayDisposeContext;
import com.github.copilot.editor.InlaysReceivedMessage;
import com.github.copilot.github.GitHubService;
import com.github.copilot.lang.agent.NotSignedInException;
import com.github.copilot.request.CompletionType;
import com.github.copilot.request.EditorRequest;
import com.github.copilot.request.RequestId;
import com.github.copilot.settings.CopilotApplicationSettings;
import com.github.copilot.status.CopilotStatus;
import com.github.copilot.status.CopilotStatusService;
import com.github.copilot.util.CopilotScreenReaderUtil;
import com.github.copilot.util.CopilotStringUtil;
import com.github.copilot.util.LoggerUtil;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.fileEditor.FileDocumentSynchronizationVetoer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopilotEditorManagerImpl
implements CopilotEditorManager {
    private static final Logger LOG = Logger.getInstance(CopilotEditorManagerImpl.class);
    private static final Key<EditorRequestResultList> KEY_LAST_REQUEST = Key.create((String)"copilot.editorRequest");
    private static final Key<Boolean> KEY_PROCESSING = KeyWithDefaultValue.create((String)"copilot.processing", (Object)false);
    private static final Key<Boolean> KEY_EDITOR_SUPPORTED = Key.create((String)"copilot.editorSupported");
    static final Key<Boolean> KEY_DOCUMENT_SAVE_VETO = Key.create((String)"copilot.docSaveVeto");
    private static final int REQUEST_DELAY_MILLIS = 45;
    private static final Set<String> COMMAND_BLACKLIST = Set.of("Expand Live Template by Tab");
    protected final CancellableAlarm requestAlarm = new CancellableAlarm(this);
    String previouslyAnnouncedSentence = "";

    @Override
    @RequiresEdt
    public boolean isAvailable(@NotNull Editor editor) {
        Boolean isAvailable = (Boolean)KEY_EDITOR_SUPPORTED.get((UserDataHolder)editor);
        if (isAvailable == null) {
            isAvailable = !(editor instanceof EditorWindow) && !(editor instanceof ImaginaryEditor) && (!(editor instanceof EditorEx) || !((EditorEx)editor).isEmbeddedIntoDialogWrapper()) && !editor.isViewer() && !editor.isOneLineMode() && CopilotPlugin.isSupportedIDE(editor.getProject()) && CopilotCompletionService.getInstance().isAvailable(editor);
            KEY_EDITOR_SUPPORTED.set((UserDataHolder)editor, (Object)isAvailable);
        }
        return isAvailable != false && !editor.isDisposed();
    }

    @Override
    public long countCompletionInlays(@NotNull Editor editor, @NotNull TextRange searchRange, boolean inlineInlays, boolean afterLineEndInlays, boolean blockInlays, boolean matchInLeadingWhitespace) {
        if (!this.isAvailable(editor)) {
            return 0L;
        }
        int startOffset = searchRange.getStartOffset();
        int endOffset = searchRange.getEndOffset();
        InlayModel inlayModel = editor.getInlayModel();
        long totalCount = 0L;
        if (inlineInlays) {
            totalCount += inlayModel.getInlineElementsInRange(startOffset, endOffset).stream().filter(inlay -> {
                if (!(inlay.getRenderer() instanceof CopilotInlayRenderer)) {
                    return false;
                }
                if (matchInLeadingWhitespace) {
                    return true;
                }
                List<String> lines = ((CopilotInlayRenderer)inlay.getRenderer()).getContentLines();
                if (lines.isEmpty()) {
                    return false;
                }
                int whitespaceEnd = inlay.getOffset() + CopilotStringUtil.leadingWhitespaceLength(lines.get(0));
                return searchRange.getEndOffset() >= whitespaceEnd;
            }).count();
        }
        if (blockInlays) {
            totalCount += inlayModel.getBlockElementsInRange(startOffset, endOffset).stream().filter(inlay -> inlay.getRenderer() instanceof CopilotInlayRenderer).count();
        }
        if (afterLineEndInlays) {
            totalCount += inlayModel.getAfterLineEndElementsInRange(startOffset, endOffset).stream().filter(inlay -> inlay.getRenderer() instanceof CopilotInlayRenderer).count();
        }
        return totalCount;
    }

    @Override
    @RequiresEdt
    public boolean applyCompletion(@NotNull Editor editor, CopilotApplyInlayStrategy applyStrategy) {
        if (editor.isDisposed()) {
            LOG.warn("editor already disposed");
            return false;
        }
        Project project = editor.getProject();
        if (project == null || project.isDisposed()) {
            LOG.warn("project disposed or null: " + String.valueOf(project));
            return false;
        }
        if (this.isProcessing(editor)) {
            LOG.warn("can't apply inlays while processing");
            return false;
        }
        EditorRequestResultList request = (EditorRequestResultList)KEY_LAST_REQUEST.get((UserDataHolder)editor);
        if (request == null) {
            return false;
        }
        CopilotInlayList currentCompletion = request.getCurrentCompletion();
        if (currentCompletion == null) {
            return false;
        }
        if (applyStrategy == CopilotApplyInlayStrategy.WHOLE) {
            this.disposeInlays(editor, InlayDisposeContext.Applied);
        } else {
            this.disposeInlays(editor, InlayDisposeContext.TypingAsSuggested);
        }
        this.applyCompletion(project, editor, request.getRequest(), currentCompletion, applyStrategy);
        return true;
    }

    @Override
    @RequiresEdt
    public void applyCompletion(@NotNull Project project, @NotNull Editor editor, @NotNull EditorRequest request, @NotNull CopilotInlayList completion, @NotNull CopilotApplyInlayStrategy applyStrategy) {
        TextRange range = completion.getReplacementRange();
        String text = new CompletionSplitter(applyStrategy).split(completion);
        WriteCommandAction.runWriteCommandAction((Project)project, (String)"Apply Copilot Suggestion", (String)"GitHub Copilot", () -> {
            if (project.isDisposed()) {
                return;
            }
            Document document = editor.getDocument();
            try {
                KEY_DOCUMENT_SAVE_VETO.set((UserDataHolder)document, (Object)true);
                this.wrapWithTemporarySaveVetoHandler(() -> {
                    if (range.getEndOffset() <= document.getTextLength()) {
                        document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)text);
                        editor.getCaretModel().moveToOffset(range.getStartOffset() + text.length());
                        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                    } else {
                        LOG.warn("Attempt to apply completions out of document bounds: " + String.valueOf(range) + ", document: " + document.getTextLength());
                    }
                });
            }
            finally {
                KEY_DOCUMENT_SAVE_VETO.set((UserDataHolder)document, null);
            }
        }, (PsiFile[])new PsiFile[0]);
        CopilotCompletionService.getInstance().sendAcceptedTelemetry(completion.getCopilotCompletion(), request.getCompletionType(), applyStrategy, text.length());
    }

    @Override
    @RequiresEdt
    public void disposeInlays(@NotNull Editor editor, @NotNull InlayDisposeContext disposeContext) {
        if (!this.isAvailable(editor) || this.isProcessing(editor)) {
            return;
        }
        EditorRequestResultList request = (EditorRequestResultList)KEY_LAST_REQUEST.get((UserDataHolder)editor);
        if (disposeContext.isSendRejectedTelemetry()) {
            this.sendRejectedTelemetry(request);
        }
        if (disposeContext.isResetLastRequest()) {
            KEY_LAST_REQUEST.set((UserDataHolder)editor, null);
        }
        if (request == null || request.getRequest().getOffset() != editor.getCaretModel().getOffset()) {
            this.cancelCompletionRequests(editor);
        }
        this.wrapProcessing(editor, () -> this.disposeInlays(this.collectInlays(editor, 0, editor.getDocument().getTextLength())));
    }

    @Override
    @RequiresEdt
    public void editorModified(@NotNull Editor editor, int offset, @NotNull CompletionRequestType requestType) {
        LOG.debug("editorModified");
        if (CopilotStatusService.isClientRequestsDisabled()) {
            LOG.debug("completions disabled because this plugin version is incompatible with the GitHub Copilot server");
            return;
        }
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        EditorRequestResultList lastRequest = (EditorRequestResultList)KEY_LAST_REQUEST.get((UserDataHolder)editor);
        if (this.isDuplicateRequest(editor.getDocument(), offset, requestType, lastRequest)) {
            LOG.debug("Ignoring duplicate editorModified request");
            return;
        }
        if (this.isLookupUnsupported(requestType, editor)) {
            LOG.debug("completion disabled because of a visible popup");
            return;
        }
        this.cancelCompletionRequests(editor);
        if (this.isBlacklistedCommand()) {
            return;
        }
        if (this.isUnsupportedEditorState(editor)) {
            return;
        }
        if (requestType.isAutomaticOrForced() && !CopilotApplicationSettings.isCopilotEnabled(project, editor)) {
            this.sendRejectedTelemetry(lastRequest);
            this.disposeInlays(editor, InlayDisposeContext.Typing);
            ((CompletionsRejectedMessage)ApplicationManager.getApplication().getMessageBus().syncPublisher(CompletionsRejectedMessage.TOPIC)).automaticCompletionsRejected(null);
            return;
        }
        if (!GitHubService.getInstance().isSignedIn()) {
            LOG.debug("Completions unavailable because user isn't authorized for GitHub Copilot");
            GitHubService.getInstance().showLoginNotification(project, false);
            return;
        }
        EditorRequest request = CopilotCompletionService.getInstance().createRequest(editor, offset, CompletionType.GhostText);
        if (request == null) {
            return;
        }
        boolean debounce = this.shouldDebounce(editor, offset, lastRequest);
        this.disposeInlays(editor, debounce ? InlayDisposeContext.Typing : InlayDisposeContext.TypingAsSuggested);
        CopilotEditorUtil.addEditorRequest(editor, request);
        KEY_LAST_REQUEST.set((UserDataHolder)editor, (Object)new EditorRequestResultList(request));
        if (CopilotEditorSupport.isEditorCompletionsSupported(editor)) {
            this.queueCompletionRequest(editor, request, null, false, first -> this.insertInlays((CopilotInlayList)first, request, editor, InlayDisposeContext.Typing), debounce);
        }
    }

    boolean shouldDebounce(@NotNull Editor editor, int offset, EditorRequestResultList lastRequest) {
        try {
            if (lastRequest != null) {
                @Nullable CopilotInlayList completion = lastRequest.getCurrentCompletion();
                int lastOffset = lastRequest.getRequest().getOffset();
                if (completion != null && offset > lastOffset) {
                    CopilotCompletion copilot = completion.getCopilotCompletion();
                    String completionText = copilot.getCompletion().stream().reduce("", (a, b) -> a + b);
                    if (completionText.isEmpty()) {
                        return true;
                    }
                    String typed = editor.getDocument().getText(TextRange.from((int)lastOffset, (int)(offset - lastOffset)));
                    return !completionText.startsWith(typed);
                }
            }
            return true;
        }
        catch (Exception e) {
            LoggerUtil.errorAndSecureTelemetry(LOG, "error computing debounce", e, new Attachment[0]);
            return true;
        }
    }

    @Override
    public void cancelCompletionRequests(@NotNull Editor editor) {
        this.requestAlarm.cancelAllRequests();
        List requests = (List)CopilotEditorUtil.KEY_REQUESTS.get((UserDataHolder)editor);
        if (requests == null || requests.isEmpty()) {
            return;
        }
        LOG.debug("cancelCompletionRequests: " + requests.size());
        int count = requests.size();
        Iterator requestIterator = requests.iterator();
        while (requestIterator.hasNext()) {
            EditorRequest request = (EditorRequest)requestIterator.next();
            requestIterator.remove();
            request.cancel();
        }
        ((EditorRequestsCancelledMessage)ApplicationManager.getApplication().getMessageBus().syncPublisher(EditorRequestsCancelledMessage.TOPIC)).requestsCancelled(count);
    }

    public void dispose() {
    }

    @Override
    @NotNull
    @RequiresEdt
    public List<CopilotInlayRenderer> collectInlays(@NotNull Editor editor, int startOffset, int endOffset) {
        InlayModel model = editor.getInlayModel();
        ArrayList inlays = new ArrayList();
        inlays.addAll(model.getInlineElementsInRange(startOffset, endOffset));
        inlays.addAll(model.getAfterLineEndElementsInRange(startOffset, endOffset));
        inlays.addAll(model.getBlockElementsInRange(startOffset, endOffset));
        ArrayList<CopilotInlayRenderer> renderers = new ArrayList<CopilotInlayRenderer>();
        for (Inlay inlay : inlays) {
            if (!(inlay.getRenderer() instanceof CopilotInlayRenderer)) continue;
            renderers.add((CopilotInlayRenderer)inlay.getRenderer());
        }
        return renderers;
    }

    @Override
    public boolean hasNextInlaySet(@NotNull Editor editor) {
        EditorRequestResultList request = (EditorRequestResultList)KEY_LAST_REQUEST.get((UserDataHolder)editor);
        if (request == null) {
            return false;
        }
        CopilotCompletionService service = CopilotCompletionService.getInstance();
        return request.hasNext() || service.isSupportingOnDemandCycling(editor) && !request.hasOnDemandCompletions();
    }

    @Override
    public boolean hasPreviousInlaySet(@NotNull Editor editor) {
        EditorRequestResultList request = (EditorRequestResultList)KEY_LAST_REQUEST.get((UserDataHolder)editor);
        return request != null && request.hasPrev();
    }

    @Override
    public void showNextInlaySet(@NotNull Editor editor) {
        EditorRequestResultList request = (EditorRequestResultList)KEY_LAST_REQUEST.get((UserDataHolder)editor);
        if (request == null) {
            LOG.debug("current request unavailable");
            return;
        }
        CopilotInlayList set = request.getNextCompletion();
        if (set != null) {
            this.insertInlays(set, request.getRequest(), editor, InlayDisposeContext.Cycling);
            return;
        }
        CopilotCompletionService service = CopilotCompletionService.getInstance();
        if (service.isSupportingOnDemandCycling(editor) && this.isActiveRequest(request.getRequest(), editor)) {
            request.setHasOnDemandCompletions();
            this.fetchOnDemandCompletions(editor, request);
        }
    }

    @Override
    public void showPreviousInlaySet(@NotNull Editor editor) {
        EditorRequestResultList request = (EditorRequestResultList)KEY_LAST_REQUEST.get((UserDataHolder)editor);
        if (request == null) {
            return;
        }
        CopilotInlayList set = request.getPrevCompletion();
        if (set == null) {
            return;
        }
        this.insertInlays(set, request.getRequest(), editor, InlayDisposeContext.Cycling);
    }

    private void queueCompletionRequest(@NotNull Editor editor, @NotNull EditorRequest contentRequest, @Nullable Integer maxCompletions, boolean cycling, @Nullable Consumer<CopilotInlayList> onFirstCompletion, boolean debounceRequest) {
        this.requestAlarm.cancelAllAndAddRequest(() -> {
            if (!contentRequest.isCancelled()) {
                this.requestCopilotCompletions(editor, contentRequest, maxCompletions, cycling, onFirstCompletion);
            }
        }, debounceRequest ? 45 : 0);
    }

    @RequiresBackgroundThread
    private void requestCopilotCompletions(final @NotNull Editor editor, final @NotNull EditorRequest request, @Nullable Integer maxCompletions, boolean cycling, final @Nullable Consumer<CopilotInlayList> onFirstCompletion) {
        if (!CopilotEditorUtil.isFocusedEditor(editor)) {
            LOG.debug("skipping completions for unfocused editor: " + String.valueOf(editor));
            return;
        }
        final AtomicBoolean resetCompletions = new AtomicBoolean(cycling);
        CopilotCompletionService.getInstance().fetchCompletions(request, maxCompletions, cycling, new Flow.Subscriber<List<CopilotInlayList>>(){
            private volatile Flow.Subscription subscription;
            private volatile boolean hasFirstCompletion;

            @Override
            public void onSubscribe(Flow.Subscription subscription2) {
                this.subscription = subscription2;
                this.subscription.request(1L);
                Disposer.tryRegister((Disposable)request.getDisposable(), this.subscription::cancel);
            }

            @Override
            public void onNext(List<CopilotInlayList> inlaySets) {
                EditorRequestResultList stored;
                LOG.debug("received inlay");
                if (!CopilotEditorManagerImpl.this.isActiveRequest(request, editor)) {
                    LOG.debug("skipping inlay because request already cancelled");
                    return;
                }
                if (resetCompletions.compareAndSet(true, false) && (stored = (EditorRequestResultList)KEY_LAST_REQUEST.get((UserDataHolder)editor)) != null) {
                    stored.resetInlays();
                }
                if (!CopilotEditorManagerImpl.this.addInlays(editor, inlaySets)) {
                    LOG.debug("failed to add inlays");
                    return;
                }
                this.subscription.request(1L);
                ((InlaysReceivedMessage)ApplicationManager.getApplication().getMessageBus().syncPublisher(InlaysReceivedMessage.TOPIC)).inlaysReceived(request, inlaySets);
                if (!this.hasFirstCompletion && onFirstCompletion != null && !inlaySets.isEmpty()) {
                    this.hasFirstCompletion = true;
                    CopilotInlayList firstSet = inlaySets.get(0);
                    assert (firstSet != null && !firstSet.isEmpty());
                    ApplicationManager.getApplication().invokeLater(() -> onFirstCompletion.accept(firstSet));
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
                if (LOG.isTraceEnabled() || ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.debug("onError", throwable);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("onError: " + throwable.getMessage());
                }
                if (throwable instanceof NotSignedInException) {
                    CopilotStatusService.notifyApplication(CopilotStatus.NotSignedIn);
                }
            }

            @Override
            public void onComplete() {
            }
        });
    }

    private void insertInlays(@NotNull CopilotInlayList inlays, @NotNull EditorRequest request, @NotNull Editor editor, @NotNull InlayDisposeContext disposeContext) {
        if (!this.isActiveRequest(request, editor)) {
            LOG.debug("skipping insertion of inlay because request was cancelled");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("inserting completion inlay into editor, current request ID: " + RequestId.currentRequestId() + ", request ID: " + request.getRequestId() + ", caret: " + editor.getCaretModel().getOffset() + ", request offset: " + request.getOffset());
        }
        if (!CopilotEditorUtil.isFocusedEditor(editor)) {
            LOG.debug("Not inserting inlays into editor without focus.");
            return;
        }
        this.doInsertInlays(inlays, request, editor, disposeContext);
    }

    private void doInsertInlays(@NotNull CopilotInlayList inlays, @NotNull EditorRequest request, @NotNull Editor editor, @NotNull InlayDisposeContext context) {
        this.disposeInlays(editor, context);
        ArrayList<Inlay<CopilotInlayRenderer>> insertedInlays = new ArrayList<Inlay<CopilotInlayRenderer>>();
        InlayModel inlayModel = editor.getInlayModel();
        int index = 0;
        Object announcerSentence = "";
        for (CopilotEditorInlay inlay : inlays) {
            if (inlay.isEmptyCompletion()) continue;
            announcerSentence = (String)announcerSentence + String.join((CharSequence)"\n", inlay.getLines());
            CopilotDefaultInlayRenderer renderer = new CopilotDefaultInlayRenderer(editor, request, inlay.getType(), inlay.getLines());
            Inlay editorInlay = null;
            switch (inlay.getType()) {
                case Inline: {
                    editorInlay = inlayModel.addInlineElement(inlay.getEditorOffset(), true, Integer.MAX_VALUE - index, (EditorCustomElementRenderer)renderer);
                    break;
                }
                case AfterLineEnd: {
                    editorInlay = inlayModel.addAfterLineEndElement(inlay.getEditorOffset(), true, (EditorCustomElementRenderer)renderer);
                    break;
                }
                case Block: {
                    editorInlay = inlayModel.addBlockElement(inlay.getEditorOffset(), true, false, Integer.MAX_VALUE - index, (EditorCustomElementRenderer)renderer);
                }
            }
            if (editorInlay != null) {
                renderer.setInlay(editorInlay);
            }
            insertedInlays.add(editorInlay);
            ++index;
        }
        if (context != InlayDisposeContext.TypingAsSuggested) {
            CopilotCompletionService.getInstance().sendShownTelemetry(inlays.getCopilotCompletion());
        }
        if (!((String)announcerSentence).isEmpty() && !this.previouslyAnnouncedSentence.equals(announcerSentence)) {
            CopilotScreenReaderUtil.announce(CopilotBundle.get("action.copilot.inlayShowAccessible.text") + " " + (String)announcerSentence, false);
            this.previouslyAnnouncedSentence = announcerSentence;
        }
        LOG.debug("publishing inlaysUpdated");
        ((CopilotInlayListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(CopilotInlayListener.TOPIC)).inlaysUpdated(request, context, editor, insertedInlays);
    }

    private boolean isProcessing(@NotNull Editor editor) {
        return (Boolean)KEY_PROCESSING.get((UserDataHolder)editor);
    }

    private void disposeInlays(List<CopilotInlayRenderer> renderers) {
        for (CopilotInlayRenderer renderer : renderers) {
            Inlay<CopilotInlayRenderer> inlay = renderer.getInlay();
            if (inlay == null) continue;
            Disposer.dispose(inlay);
        }
    }

    private void wrapProcessing(@NotNull Editor editor, @NotNull Runnable block) {
        assert (!((Boolean)KEY_PROCESSING.get((UserDataHolder)editor)).booleanValue());
        try {
            KEY_PROCESSING.set((UserDataHolder)editor, (Object)true);
            block.run();
        }
        finally {
            KEY_PROCESSING.set((UserDataHolder)editor, null);
        }
    }

    private boolean isActiveRequest(@NotNull EditorRequest request, @NotNull Editor editor) {
        if (request.getRequestId() != RequestId.currentRequestId()) {
            return false;
        }
        EditorRequestResultList stored = (EditorRequestResultList)KEY_LAST_REQUEST.get((UserDataHolder)editor);
        return stored != null && stored.getRequest().equalsRequest(request);
    }

    private boolean addInlays(@NotNull Editor editor, @NotNull List<CopilotInlayList> inlaySets) {
        EditorRequestResultList stored = (EditorRequestResultList)KEY_LAST_REQUEST.get((UserDataHolder)editor);
        if (stored != null) {
            for (CopilotInlayList inlays : inlaySets) {
                stored.addInlays(inlays);
            }
        }
        return stored != null;
    }

    private void fetchOnDemandCompletions(@NotNull Editor editor, @NotNull EditorRequestResultList request) {
        EditorRequest currentRequest = request.getRequest();
        LOG.debug("Fetching on-demand completions for cycling");
        this.queueCompletionRequest(editor, currentRequest, 2, true, first -> {
            CopilotInlayList nextSet = request.getNextCompletion();
            if (nextSet != null) {
                LOG.debug("Received first on-demand completion");
                this.insertInlays(nextSet, currentRequest, editor, InlayDisposeContext.Cycling);
            }
        }, true);
    }

    private void sendRejectedTelemetry(@Nullable EditorRequestResultList lastRequest) {
        if (lastRequest == null) {
            return;
        }
        List<CopilotInlayList> allShownCompletion = lastRequest.getAllShownCompletion();
        if (allShownCompletion != null) {
            List<CopilotCompletion> shown = allShownCompletion.stream().filter(Objects::nonNull).map(CopilotInlayList::getCopilotCompletion).collect(Collectors.toList());
            CopilotCompletionService.getInstance().sendRejectedTelemetry(shown);
        }
    }

    private boolean isDuplicateRequest(@NotNull Document document, int requestOffset, @NotNull CompletionRequestType requestType, @Nullable EditorRequestResultList lastRequest) {
        if (lastRequest == null || requestType.isForcedOrManual()) {
            return false;
        }
        if (lastRequest.getRequest().getOffset() != requestOffset) {
            return false;
        }
        long lastStamp = lastRequest.getRequest().getDocumentModificationSequence();
        return lastStamp == CopilotEditorUtil.getDocumentModificationStamp(document);
    }

    private boolean isBlacklistedCommand() {
        String commandName = CommandProcessor.getInstance().getCurrentCommandName();
        return commandName != null && COMMAND_BLACKLIST.contains(commandName);
    }

    private boolean isUnsupportedEditorState(@NotNull Editor editor) {
        if (editor.getCaretModel().getCaretCount() > 1) {
            return true;
        }
        return editor.getSelectionModel().hasSelection();
    }

    private boolean isLookupUnsupported(@NotNull CompletionRequestType requestType, @NotNull Editor editor) {
        return requestType.isAutomaticOrForced() && !CopilotApplicationSettings.settings().isShowIdeCompletions() && LookupManager.getActiveLookup((Editor)editor) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrapWithTemporarySaveVetoHandler(@NotNull Runnable runnable) {
        Disposable disposable = Disposer.newDisposable();
        try {
            ExtensionPoint extensionPoint = ApplicationManager.getApplication().getExtensionArea().getExtensionPoint(FileDocumentSynchronizationVetoer.EP_NAME);
            extensionPoint.registerExtension((Object)new CopilotEditorSaveVetoer(), disposable);
            runnable.run();
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }
}

