/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.editor;

import com.github.copilot.CopilotPlugin;
import com.github.copilot.request.EditorRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class CopilotEditorUtil {
    static final Key<List<EditorRequest>> KEY_REQUESTS = Key.create((String)"copilot.editorRequests");

    private CopilotEditorUtil() {
    }

    public static boolean isFocusedEditor(@NotNull Editor editor) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (CopilotPlugin.isRemoteIDE()) {
            return true;
        }
        return editor.getContentComponent().isFocusOwner();
    }

    public static boolean isSelectedEditor(@NotNull Editor editor) {
        Project project = editor.getProject();
        if (project == null || project.isDisposed()) {
            return false;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        if (editorManager == null) {
            return false;
        }
        if (editorManager instanceof FileEditorManagerImpl) {
            Editor current = ((FileEditorManagerImpl)editorManager).getSelectedTextEditor(true);
            return current != null && current.equals(editor);
        }
        FileEditor current = editorManager.getSelectedEditor();
        return current instanceof TextEditor && editor.equals(((TextEditor)current).getEditor());
    }

    public static long getDocumentModificationStamp(@NotNull Document document) {
        return document instanceof DocumentEx ? (long)((DocumentEx)document).getModificationSequence() : document.getModificationStamp();
    }

    public static int whitespacePrefixLength(@NotNull String lineContent) {
        int i;
        int maxLength = lineContent.length();
        for (i = 0; i < maxLength; ++i) {
            char c = lineContent.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return i;
        }
        return i;
    }

    public static void addEditorRequest(@NotNull Editor editor, @NotNull EditorRequest request) {
        EditorUtil.disposeWithEditor((Editor)editor, (Disposable)request.getDisposable());
        if (!KEY_REQUESTS.isIn((UserDataHolder)editor)) {
            KEY_REQUESTS.set((UserDataHolder)editor, (Object)ContainerUtil.createLockFreeCopyOnWriteList());
        }
        ((List)KEY_REQUESTS.getRequired((UserDataHolder)editor)).add(request);
    }

    @TestOnly
    public static List<EditorRequest> getEditorRequests(@NotNull Editor editor) {
        return (List)KEY_REQUESTS.get((UserDataHolder)editor, List.of());
    }

    @Nullable
    public static Editor getSelectedEditorSafely(@NotNull Project project) {
        try {
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
            return editorManager != null ? editorManager.getSelectedTextEditor() : null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

