/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.editor;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotIcons;
import com.github.copilot.editor.CopilotInlayListener;
import com.github.copilot.editor.CopilotInlayRenderer;
import com.github.copilot.editor.InlayDisposeContext;
import com.github.copilot.request.EditorRequest;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.GotItTooltip;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;

public class CopilotInlayGotItListener
implements CopilotInlayListener {
    @Override
    public void inlaysUpdated(@NotNull EditorRequest request, @NotNull InlayDisposeContext context, @NotNull Editor editor, @NotNull List<Inlay<CopilotInlayRenderer>> insertedInlays) {
        if (insertedInlays.isEmpty() || request.isCancelled()) {
            return;
        }
        Rectangle inlayBounds = insertedInlays.get(0).getBounds();
        if (inlayBounds != null) {
            GotItTooltip firstTimeSuggestionTooltip = CopilotInlayGotItListener.createFirstSuggestionTooltip(request);
            if (firstTimeSuggestionTooltip.canShow()) {
                this.showTooltipSafe(editor, firstTimeSuggestionTooltip, inlayBounds);
            } else {
                GotItTooltip partialAcceptanceTooltip = this.createPartialAcceptanceTooltip(request);
                this.showTooltipSafe(editor, partialAcceptanceTooltip, inlayBounds);
            }
        }
    }

    @NotNull
    private GotItTooltip createPartialAcceptanceTooltip(EditorRequest request) {
        String nextWordShortcut = KeymapUtil.getShortcutText((String)"copilot.applyInlaysNextWord");
        String nextLineShortcut = KeymapUtil.getShortcutText((String)"copilot.applyInlaysNextLine");
        String header = CopilotBundle.get("editor.inlayPartialGotIt.header");
        String message = CopilotBundle.get("editor.inlayPartialGotIt.message", nextWordShortcut, nextLineShortcut);
        return new GotItTooltip("copilot.inlayPartialGotIt", message, request.getDisposable()).withHeader(header).withPosition(Balloon.Position.atLeft).withIcon(CopilotIcons.COPILOT).withLink(CopilotBundle.get("editor.inlayPartialGotIt.settingsLink"), () -> ShowSettingsUtil.getInstance().showSettingsDialog(request.getProject(), "Keymap"));
    }

    private void showTooltipSafe(@NotNull Editor editor, GotItTooltip firstTimeSuggestionTooltip, Rectangle inlayBounds) {
        try {
            this.showTooltip(editor.getContentComponent(), firstTimeSuggestionTooltip, inlayBounds.getLocation());
        }
        catch (Exception e) {
            Logger.getInstance(this.getClass()).error("Error showing inlay GotIt tooltip", (Throwable)e);
        }
    }

    @NotNull
    private static GotItTooltip createFirstSuggestionTooltip(@NotNull EditorRequest request) {
        String applyShortcut = KeymapUtil.getShortcutText((String)"copilot.applyInlays");
        String cycleNextShortcut = KeymapUtil.getShortcutText((String)"copilot.cycleNextInlays");
        String cyclePrevShortcut = KeymapUtil.getShortcutText((String)"copilot.cyclePrevInlays");
        String header = CopilotBundle.get("editor.inlayGotIt.header");
        String message = CopilotBundle.get("editor.inlayGotIt.message", applyShortcut, cycleNextShortcut, cyclePrevShortcut);
        return new GotItTooltip("copilot.inlayGotIt", message, request.getDisposable()).withHeader(header).withPosition(Balloon.Position.atLeft).withIcon(CopilotIcons.COPILOT);
    }

    private void showTooltip(@NotNull JComponent component2, @NotNull GotItTooltip tooltip, @NotNull Point location) throws Exception {
        Class<?> tooltipClass = tooltip.getClass();
        if (ApplicationInfo.getInstance().getBuild().getBaselineVersion() <= 211) {
            Method method = tooltipClass.getMethod("show", JComponent.class, Function1.class);
            method.invoke((Object)tooltip, component2, c -> location);
        } else {
            Method method = tooltipClass.getMethod("show", JComponent.class, Function2.class);
            method.invoke((Object)tooltip, component2, (c, balloon) -> location);
        }
    }
}

