/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.editor;

import com.github.copilot.editor.CompletionRequestType;
import com.github.copilot.editor.CopilotEditorManager;
import com.github.copilot.editor.CopilotEditorUtil;
import com.github.copilot.editor.InlayDisposeContext;
import com.github.copilot.settings.CopilotApplicationSettings;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;

public class CopilotLookupListener
implements LookupManagerListener {
    private static final Logger LOG = Logger.getInstance(CopilotLookupListener.class);

    public void activeLookupChanged(@Nullable Lookup oldLookup, @Nullable Lookup newLookup) {
        Editor editor;
        PsiFile psiFile;
        LOG.debug("activeLookupChanged");
        Lookup validLookup = newLookup != null ? newLookup : oldLookup;
        PsiFile psiFile2 = psiFile = validLookup != null ? validLookup.getPsiFile() : null;
        if (psiFile != null && !CopilotApplicationSettings.isCopilotEnabled(psiFile)) {
            return;
        }
        CopilotEditorManager editorManager = CopilotEditorManager.getInstance();
        if (oldLookup != null && newLookup == null) {
            Editor editor2;
            PsiFile file = oldLookup.getPsiFile();
            if (file != null && CopilotEditorUtil.isSelectedEditor(editor2 = oldLookup.getEditor()) && editorManager.isAvailable(editor2) && !editor2.getDocument().isInBulkUpdate()) {
                editorManager.editorModified(editor2, CompletionRequestType.Forced);
            }
        } else if (newLookup != null && oldLookup == null && !CopilotApplicationSettings.settings().isShowIdeCompletions() && editorManager.isAvailable(editor = newLookup.getEditor())) {
            editorManager.cancelCompletionRequests(editor);
            editorManager.disposeInlays(editor, InlayDisposeContext.IdeCompletion);
        }
    }
}

