/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.editor;

import com.github.copilot.editor.CopilotEditorManager;
import com.github.copilot.editor.InlayDisposeContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;

public class EditorFocusListener
implements FileEditorManagerListener {
    private final Project project;

    public EditorFocusListener(@NotNull Project project) {
        this.project = project;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        VirtualFile oldFile = event.getOldFile();
        if (oldFile == null || !oldFile.isValid()) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(oldFile);
        if (psiFile == null || !psiFile.isValid()) {
            return;
        }
        FileEditor oldEditor = event.getOldEditor();
        if (oldEditor instanceof TextEditor) {
            Editor editor = ((TextEditor)oldEditor).getEditor();
            CopilotEditorManager.getInstance().disposeInlays(editor, InlayDisposeContext.UserAction);
        }
    }
}

