/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.editor;

import com.github.copilot.completions.CopilotInlayList;
import com.github.copilot.request.EditorRequest;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditorRequestResultList {
    private final EditorRequest request;
    private final Object inlayLock = new Object();
    private final ObjectLinkedOpenHashSet<CopilotInlayList> inlayLists = new ObjectLinkedOpenHashSet();
    private int index = 0;
    private int maxShownIndex = -1;
    private boolean hasOnDemandCompletions;

    public EditorRequestResultList(@NotNull EditorRequest request) {
        this.request = request;
    }

    public EditorRequest getRequest() {
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetInlays() {
        Object object = this.inlayLock;
        synchronized (object) {
            this.inlayLists.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInlays(@NotNull CopilotInlayList inlays) {
        Object object = this.inlayLock;
        synchronized (object) {
            this.inlayLists.add((Object)inlays);
            this.maxShownIndex = Math.max(0, this.maxShownIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CopilotInlayList getCurrentCompletion() {
        Object object = this.inlayLock;
        synchronized (object) {
            return EditorRequestResultList.getAtIndexLocked(this.inlayLists, this.index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<CopilotInlayList> getAllShownCompletion() {
        Object object = this.inlayLock;
        synchronized (object) {
            return this.inlayLists.stream().limit(this.maxShownIndex + 1).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCurrent() {
        Object object = this.inlayLock;
        synchronized (object) {
            return this.index >= 0 && !this.inlayLists.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPrev() {
        Object object = this.inlayLock;
        synchronized (object) {
            return this.inlayLists.size() > 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        Object object = this.inlayLock;
        synchronized (object) {
            return this.inlayLists.size() > 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CopilotInlayList getPrevCompletion() {
        Object object = this.inlayLock;
        synchronized (object) {
            int size = this.inlayLists.size();
            if (size <= 1) {
                this.index = 0;
                return null;
            }
            --this.index;
            if (this.index < 0) {
                this.index = size - 1;
            }
            return EditorRequestResultList.getAtIndexLocked(this.inlayLists, this.index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CopilotInlayList getNextCompletion() {
        Object object = this.inlayLock;
        synchronized (object) {
            int size = this.inlayLists.size();
            if (size <= 1) {
                this.index = 0;
                return null;
            }
            ++this.index;
            if (this.index >= size) {
                this.index = 0;
            }
            this.maxShownIndex = Math.max(this.maxShownIndex, this.index);
            return EditorRequestResultList.getAtIndexLocked(this.inlayLists, this.index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOnDemandCompletions() {
        Object object = this.inlayLock;
        synchronized (object) {
            return this.hasOnDemandCompletions || this.inlayLists.size() > 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHasOnDemandCompletions() {
        Object object = this.inlayLock;
        synchronized (object) {
            this.hasOnDemandCompletions = true;
        }
    }

    @Nullable
    private static CopilotInlayList getAtIndexLocked(@NotNull ObjectSortedSet<CopilotInlayList> inlays, int index) {
        return inlays.stream().skip(index).findFirst().orElse(null);
    }

    @Generated
    public Object getInlayLock() {
        return this.inlayLock;
    }

    @Generated
    public ObjectLinkedOpenHashSet<CopilotInlayList> getInlayLists() {
        return this.inlayLists;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public int getMaxShownIndex() {
        return this.maxShownIndex;
    }

    @Generated
    public boolean isHasOnDemandCompletions() {
        return this.hasOnDemandCompletions;
    }

    @Generated
    public void setIndex(int index) {
        this.index = index;
    }

    @Generated
    public void setMaxShownIndex(int maxShownIndex) {
        this.maxShownIndex = maxShownIndex;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditorRequestResultList)) {
            return false;
        }
        EditorRequestResultList other = (EditorRequestResultList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (this.getMaxShownIndex() != other.getMaxShownIndex()) {
            return false;
        }
        if (this.isHasOnDemandCompletions() != other.isHasOnDemandCompletions()) {
            return false;
        }
        EditorRequest this$request = this.getRequest();
        EditorRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Object this$inlayLock = this.getInlayLock();
        Object other$inlayLock = other.getInlayLock();
        if (this$inlayLock == null ? other$inlayLock != null : !this$inlayLock.equals(other$inlayLock)) {
            return false;
        }
        ObjectLinkedOpenHashSet<CopilotInlayList> this$inlayLists = this.getInlayLists();
        ObjectLinkedOpenHashSet<CopilotInlayList> other$inlayLists = other.getInlayLists();
        return !(this$inlayLists == null ? other$inlayLists != null : !this$inlayLists.equals(other$inlayLists));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EditorRequestResultList;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        result = result * 59 + this.getMaxShownIndex();
        result = result * 59 + (this.isHasOnDemandCompletions() ? 79 : 97);
        EditorRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Object $inlayLock = this.getInlayLock();
        result = result * 59 + ($inlayLock == null ? 43 : $inlayLock.hashCode());
        ObjectLinkedOpenHashSet<CopilotInlayList> $inlayLists = this.getInlayLists();
        result = result * 59 + ($inlayLists == null ? 43 : $inlayLists.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EditorRequestResultList(request=" + String.valueOf(this.getRequest()) + ", inlayLists=" + String.valueOf(this.getInlayLists()) + ", index=" + this.getIndex() + ", maxShownIndex=" + this.getMaxShownIndex() + ", hasOnDemandCompletions=" + this.isHasOnDemandCompletions() + ")";
    }
}

