/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class TypeOverHandler
extends TypedHandlerDelegate {
    private static final Key<Long> TYPE_OVER_STAMP = Key.create((String)"copilot.typeOverStamp");

    public static boolean getPendingTypeOverAndReset(@NotNull Editor editor) {
        Long stamp = (Long)TYPE_OVER_STAMP.get((UserDataHolder)editor);
        if (stamp == null) {
            return false;
        }
        TYPE_OVER_STAMP.set((UserDataHolder)editor, null);
        return stamp.longValue() == editor.getDocument().getModificationStamp();
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        boolean validTypeOver;
        boolean bl = validTypeOver = c == ')' || c == ']' || c == '}' || c == '\"' || c == '\'' || c == '>' || c == ';';
        if (validTypeOver && CommandProcessor.getInstance().getCurrentCommand() != null) {
            TYPE_OVER_STAMP.set((UserDataHolder)editor, (Object)editor.getDocument().getModificationStamp());
        } else {
            TYPE_OVER_STAMP.set((UserDataHolder)editor, null);
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }
}

