/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.fetch;

import com.github.copilot.fetch.FetchProgress;
import com.github.copilot.fetch.FetchProgressEnd;
import com.github.copilot.fetch.FetchProgressReport;
import com.github.copilot.fetch.FetchService;
import com.github.copilot.fetch.FetcherKt;
import com.github.copilot.lang.agent.CopilotAgentProcessService;
import java.net.http.HttpHeaders;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Flow;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0018\u0010\u0018\u001a\u00020\u00132\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016J\u0012\u0010\u001a\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/github/copilot/fetch/FetchBodySubscriber;", "Ljava/util/concurrent/Flow$Subscriber;", "", "Ljava/nio/ByteBuffer;", "workDoneToken", "", "agentProcessService", "Lcom/github/copilot/lang/agent/CopilotAgentProcessService;", "fetchService", "Lcom/github/copilot/fetch/FetchService;", "<init>", "(Ljava/lang/String;Lcom/github/copilot/lang/agent/CopilotAgentProcessService;Lcom/github/copilot/fetch/FetchService;)V", "subscription", "Ljava/util/concurrent/Flow$Subscription;", "cancelled", "", "charset", "Ljava/nio/charset/Charset;", "cancel", "", "setCharsetFromHeaders", "headers", "Ljava/net/http/HttpHeaders;", "onSubscribe", "onNext", "buffers", "onError", "throwable", "", "onComplete", "notifyComplete", "core"})
final class FetchBodySubscriber
implements Flow.Subscriber<List<? extends ByteBuffer>> {
    @NotNull
    private final String workDoneToken;
    @NotNull
    private final CopilotAgentProcessService agentProcessService;
    @NotNull
    private final FetchService fetchService;
    @Nullable
    private Flow.Subscription subscription;
    private boolean cancelled;
    @NotNull
    private Charset charset;

    public FetchBodySubscriber(@NotNull String workDoneToken, @NotNull CopilotAgentProcessService agentProcessService, @NotNull FetchService fetchService) {
        Intrinsics.checkNotNullParameter((Object)workDoneToken, (String)"workDoneToken");
        Intrinsics.checkNotNullParameter((Object)agentProcessService, (String)"agentProcessService");
        Intrinsics.checkNotNullParameter((Object)fetchService, (String)"fetchService");
        this.workDoneToken = workDoneToken;
        this.agentProcessService = agentProcessService;
        this.fetchService = fetchService;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        this.charset = charset;
    }

    public final void cancel() {
        block0: {
            this.cancelled = true;
            Flow.Subscription subscription2 = this.subscription;
            if (subscription2 == null) break block0;
            subscription2.cancel();
        }
    }

    public final void setCharsetFromHeaders(@NotNull HttpHeaders headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        String string = headers.firstValue("Content-Type").orElse(null);
        if (string == null) {
            return;
        }
        String contentType = string;
        MatchResult matchResult = Regex.find$default((Regex)new Regex("charset=([^;]+)"), (CharSequence)contentType, (int)0, (int)2, null);
        if (matchResult == null) {
            return;
        }
        MatchResult charsetMatch = matchResult;
        try {
            this.charset = Charset.forName((String)charsetMatch.getGroupValues().get(1));
        }
        catch (Exception e) {
            FetcherKt.access$getLog$p().warn("Error parsing charset from Content-Type header: " + contentType, e);
        }
    }

    @Override
    public void onSubscribe(@Nullable Flow.Subscription subscription2) {
        block2: {
            if (this.cancelled) {
                Flow.Subscription subscription3 = subscription2;
                if (subscription3 != null) {
                    subscription3.cancel();
                }
                return;
            }
            this.subscription = subscription2;
            Flow.Subscription subscription4 = subscription2;
            if (subscription4 == null) break block2;
            subscription4.request(1L);
        }
    }

    @Override
    public void onNext(@Nullable List<? extends ByteBuffer> buffers) {
        block3: {
            if (this.cancelled) {
                Flow.Subscription subscription2 = this.subscription;
                if (subscription2 != null) {
                    subscription2.cancel();
                }
                return;
            }
            Collection collection = buffers;
            if (collection == null || collection.isEmpty()) {
                return;
            }
            String chunk = CollectionsKt.joinToString$default((Iterable)buffers, (CharSequence)"", null, null, (int)0, null, arg_0 -> FetchBodySubscriber.onNext$lambda$0(this, arg_0), (int)30, null);
            this.agentProcessService.executeNotification(new FetchProgress(this.workDoneToken, new FetchProgressReport(chunk)));
            Flow.Subscription subscription3 = this.subscription;
            if (subscription3 == null) break block3;
            subscription3.request(1L);
        }
    }

    @Override
    public void onError(@Nullable Throwable throwable) {
        this.agentProcessService.executeNotification(new FetchProgress(this.workDoneToken, new FetchProgressEnd(String.valueOf(throwable))));
        this.notifyComplete();
    }

    @Override
    public void onComplete() {
        this.agentProcessService.executeNotification(new FetchProgress(this.workDoneToken, new FetchProgressEnd(null, 1, null)));
        this.notifyComplete();
    }

    private final void notifyComplete() {
        this.fetchService.complete(this.workDoneToken);
    }

    private static final CharSequence onNext$lambda$0(FetchBodySubscriber this$0, ByteBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = this$0.charset.decode(it).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

