/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.fetch;

import com.github.copilot.fetch.FetchRequest;
import com.github.copilot.fetch.FetchResult;
import com.github.copilot.fetch.Fetcher;
import com.github.copilot.lang.agent.CopilotAgentProcessService;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tJ\u0006\u0010\u0014\u001a\u00020\u0011R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/copilot/fetch/FetchService;", "", "agentProcessServiceFactory", "Lkotlin/Function0;", "Lcom/github/copilot/lang/agent/CopilotAgentProcessService;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "fetchers", "", "", "Lcom/github/copilot/fetch/Fetcher;", "fetch", "Lorg/jetbrains/concurrency/Promise;", "Lcom/github/copilot/fetch/FetchResult;", "request", "Lcom/github/copilot/fetch/FetchRequest;", "cancel", "", "workDoneToken", "complete", "disconnectAll", "core"})
public final class FetchService {
    @NotNull
    private final Function0<CopilotAgentProcessService> agentProcessServiceFactory;
    @NotNull
    private final Map<String, Fetcher> fetchers;

    public FetchService(@NotNull Function0<? extends CopilotAgentProcessService> agentProcessServiceFactory) {
        Intrinsics.checkNotNullParameter(agentProcessServiceFactory, (String)"agentProcessServiceFactory");
        this.agentProcessServiceFactory = agentProcessServiceFactory;
        this.fetchers = new LinkedHashMap();
    }

    @NotNull
    public final Promise<FetchResult> fetch(@NotNull FetchRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.fetchers.containsKey(request.getWorkDoneToken())) {
            throw new IllegalStateException("Work done token already in use");
        }
        Fetcher fetcher = new Fetcher(request, (CopilotAgentProcessService)this.agentProcessServiceFactory.invoke(), this);
        this.fetchers.put(request.getWorkDoneToken(), fetcher);
        return RdCoroutinesUtilKt.toPromise(fetcher.sendAsync());
    }

    public final void cancel(@NotNull String workDoneToken) {
        Intrinsics.checkNotNullParameter((Object)workDoneToken, (String)"workDoneToken");
        Fetcher fetcher = this.fetchers.get(workDoneToken);
        if (fetcher != null) {
            fetcher.cancel();
        }
        this.complete(workDoneToken);
    }

    public final void complete(@NotNull String workDoneToken) {
        Intrinsics.checkNotNullParameter((Object)workDoneToken, (String)"workDoneToken");
        this.fetchers.remove(workDoneToken);
    }

    public final void disconnectAll() {
        for (String token : this.fetchers.keySet()) {
            this.cancel(token);
        }
    }
}

