/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.fetch;

import com.github.copilot.fetch.FetchBodySubscriber;
import com.github.copilot.fetch.FetchRequest;
import com.github.copilot.fetch.FetchResult;
import com.github.copilot.fetch.FetchService;
import com.github.copilot.fetch.FetcherKt;
import com.github.copilot.lang.agent.CopilotAgentProcessService;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\rJ\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/github/copilot/fetch/Fetcher;", "", "request", "Lcom/github/copilot/fetch/FetchRequest;", "agentProcessService", "Lcom/github/copilot/lang/agent/CopilotAgentProcessService;", "fetchService", "Lcom/github/copilot/fetch/FetchService;", "<init>", "(Lcom/github/copilot/fetch/FetchRequest;Lcom/github/copilot/lang/agent/CopilotAgentProcessService;Lcom/github/copilot/fetch/FetchService;)V", "bodySubscriber", "Lcom/github/copilot/fetch/FetchBodySubscriber;", "requestFuture", "Ljava/util/concurrent/CompletableFuture;", "Ljava/net/http/HttpResponse;", "Ljava/lang/Void;", "sendAsync", "Lcom/github/copilot/fetch/FetchResult;", "cancel", "", "createHttpClient", "Ljava/net/http/HttpClient;", "createHttpRequest", "Ljava/net/http/HttpRequest;", "core"})
@SourceDebugExtension(value={"SMAP\nFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fetcher.kt\ncom/github/copilot/fetch/Fetcher\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n515#2:137\n500#2,6:138\n442#2:144\n392#2:145\n1238#3,4:146\n*S KotlinDebug\n*F\n+ 1 Fetcher.kt\ncom/github/copilot/fetch/Fetcher\n*L\n28#1:137\n28#1:138,6\n28#1:144\n28#1:145\n28#1:146,4\n*E\n"})
public final class Fetcher {
    @NotNull
    private final FetchRequest request;
    @NotNull
    private final FetchBodySubscriber bodySubscriber;
    @Nullable
    private CompletableFuture<HttpResponse<Void>> requestFuture;

    public Fetcher(@NotNull FetchRequest request, @NotNull CopilotAgentProcessService agentProcessService, @NotNull FetchService fetchService) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)agentProcessService, (String)"agentProcessService");
        Intrinsics.checkNotNullParameter((Object)fetchService, (String)"fetchService");
        this.request = request;
        this.bodySubscriber = new FetchBodySubscriber(this.request.getWorkDoneToken(), agentProcessService, fetchService);
    }

    @NotNull
    public final CompletableFuture<FetchResult> sendAsync() {
        CompletableFuture<FetchResult> responseFuture;
        block0: {
            responseFuture = new CompletableFuture<FetchResult>();
            HttpClient httpClient = this.createHttpClient();
            CompletableFuture<HttpResponse<Void>> completableFuture = this.requestFuture = httpClient.sendAsync(this.createHttpRequest(), arg_0 -> Fetcher.sendAsync$lambda$2(responseFuture, this, arg_0));
            if (completableFuture == null) break block0;
            completableFuture.handle((arg_0, arg_1) -> Fetcher.sendAsync$lambda$4((arg_0, arg_1) -> Fetcher.sendAsync$lambda$3(this, responseFuture, arg_0, arg_1), arg_0, arg_1));
        }
        return responseFuture;
    }

    public final void cancel() {
        CompletableFuture<HttpResponse<Void>> completableFuture = this.requestFuture;
        if (completableFuture != null) {
            completableFuture.cancel(true);
        }
        this.bodySubscriber.cancel();
    }

    private final HttpClient createHttpClient() {
        HttpClient.Builder builder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL);
        HttpClient.Builder builder2 = this.request.getTimeout() != null && this.request.getTimeout() > 0 ? builder.connectTimeout(Duration.ofMillis(this.request.getTimeout().intValue())) : builder.connectTimeout(Duration.ofSeconds(30L));
        HttpClient httpClient = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"build(...)");
        return httpClient;
    }

    private final HttpRequest createHttpRequest() {
        HttpRequest.Builder httpRequestBuilder = HttpRequest.newBuilder().uri(URI.create(this.request.getUrl()));
        Map map = this.request.getHeaders();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        for (Map.Entry<String, String> header : map.entrySet()) {
            httpRequestBuilder.header(header.getKey(), header.getValue());
        }
        CharSequence charSequence = this.request.getBody();
        HttpRequest.Builder builder = !(charSequence == null || charSequence.length() == 0) || Intrinsics.areEqual((Object)"POST", (Object)this.request.getMethod()) ? httpRequestBuilder.POST(HttpRequest.BodyPublishers.ofString(this.request.getBody())) : httpRequestBuilder.GET();
        if (this.request.getTimeout() != null && this.request.getTimeout() > 0) {
            httpRequestBuilder.timeout(Duration.ofMillis(this.request.getTimeout().intValue()));
        }
        HttpRequest httpRequest = httpRequestBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"build(...)");
        return httpRequest;
    }

    /*
     * WARNING - void declaration
     */
    private static final HttpResponse.BodySubscriber sendAsync$lambda$2(CompletableFuture $responseFuture, Fetcher this$0, HttpResponse.ResponseInfo responseInfo) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        void $this$filterTo$iv$iv;
        Map map = responseInfo.headers().map();
        Intrinsics.checkNotNullExpressionValue(map, (String)"map(...)");
        Map $this$filter$iv = map;
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry h = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(!Intrinsics.areEqual(h.getKey(), (Object)":status"))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$filterTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void h;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            Object v = h.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            String string = CollectionsKt.joinToString$default((Iterable)((Iterable)v), null, null, null, (int)0, null, null, (int)63, null);
            map4.put(k, string);
        }
        Map headers = destination$iv$iv;
        $responseFuture.complete(new FetchResult(responseInfo.statusCode(), headers));
        FetchBodySubscriber fetchBodySubscriber = this$0.bodySubscriber;
        HttpHeaders httpHeaders = responseInfo.headers();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"headers(...)");
        fetchBodySubscriber.setCharsetFromHeaders(httpHeaders);
        return HttpResponse.BodySubscribers.fromSubscriber(this$0.bodySubscriber);
    }

    private static final Unit sendAsync$lambda$3(Fetcher this$0, CompletableFuture $responseFuture, HttpResponse httpResponse, Throwable e) {
        if (e != null) {
            if (!(e instanceof CancellationException)) {
                FetcherKt.access$getLog$p().warn("Error fetching url: " + this$0.request.getUrl(), e);
            }
            $responseFuture.completeExceptionally(e);
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendAsync$lambda$4(Function2 $tmp0, Object p0, Throwable p1) {
        return (Unit)$tmp0.invoke(p0, (Object)p1);
    }
}

