/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.git;

import com.github.copilot.chat.conversation.agent.CopilotAgentConversationClient;
import com.github.copilot.chat.conversation.agent.CopilotAgentConversationClientKt;
import com.github.copilot.chat.conversation.agent.rpc.command.GitCommitGenerateCommand;
import com.github.copilot.chat.conversation.agent.rpc.command.GitCommitGenerateCommandResponse;
import com.github.copilot.git.CommitMessageResult;
import com.github.copilot.git.DiffResult;
import com.github.copilot.git.GitDiffService;
import com.github.copilot.git.GitMetadataService;
import com.github.copilot.git.RecentCommitMessages;
import com.github.copilot.platform.utils.ProjectKt;
import com.github.copilot.platform.utils.PromiseKt;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.LocalFilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0010\u001a\u00020\u00112\u0012\b\u0002\u0010\u0012\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/copilot/git/GitCommitService;", "", "<init>", "()V", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "gitDiffService", "Lcom/github/copilot/git/GitDiffService;", "getGitDiffService", "()Lcom/github/copilot/git/GitDiffService;", "gitMetadataService", "Lcom/github/copilot/git/GitMetadataService;", "getGitMetadataService", "()Lcom/github/copilot/git/GitMetadataService;", "conversationClient", "Lcom/github/copilot/chat/conversation/agent/CopilotAgentConversationClient;", "generateCommitMessage", "Lcom/github/copilot/git/CommitMessageResult;", "workflowHandler", "Lcom/intellij/vcs/commit/AbstractCommitWorkflowHandler;", "getRecentCommitMessages", "Lcom/github/copilot/git/RecentCommitMessages;", "core"})
@SourceDebugExtension(value={"SMAP\nGitCommitService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCommitService.kt\ncom/github/copilot/git/GitCommitService\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n39#2:129\n179#3,2:130\n179#3,2:142\n1603#4,9:132\n1855#4:141\n1856#4:145\n1612#4:146\n1#5:144\n*S KotlinDebug\n*F\n+ 1 GitCommitService.kt\ncom/github/copilot/git/GitCommitService\n*L\n29#1:129\n109#1:130,2\n100#1:142,2\n99#1:132,9\n99#1:141\n99#1:145\n99#1:146\n99#1:144\n*E\n"})
public final class GitCommitService {
    @NotNull
    private final Logger log;
    @NotNull
    private final CopilotAgentConversationClient conversationClient;

    public GitCommitService() {
        boolean $i$f$Logger = false;
        this.log = new GitHubLogger(GitCommitService.class);
        this.conversationClient = CopilotAgentConversationClientKt.CopilotAgentConversationClient();
    }

    private final GitDiffService getGitDiffService() {
        return GitDiffService.Companion.getInstance(ProjectKt.getProject());
    }

    private final GitMetadataService getGitMetadataService() {
        return GitMetadataService.Companion.getInstance(ProjectKt.getProject());
    }

    @NotNull
    public final CommitMessageResult generateCommitMessage(@Nullable AbstractCommitWorkflowHandler<?, ?> workflowHandler) {
        return (CommitMessageResult)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CommitMessageResult>, Object>(this, workflowHandler, null){
            int label;
            final /* synthetic */ GitCommitService this$0;
            final /* synthetic */ AbstractCommitWorkflowHandler<?, ?> $workflowHandler;
            {
                this.this$0 = $receiver;
                this.$workflowHandler = $workflowHandler;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        CommitMessageResult commitMessageResult;
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            CommitMessageResult commitMessageResult2;
                            DiffResult diffResult = GitCommitService.access$getGitDiffService(this.this$0).getChanges(this.$workflowHandler);
                            if (diffResult instanceof DiffResult.NoChanges) {
                                GitCommitService.access$getLog$p(this.this$0).info("No changes available to generate commit message");
                                return new CommitMessageResult.Error("copilot.git.commit.generate.error.no.changes");
                            }
                            if (diffResult instanceof DiffResult.AllChangesOmitted) {
                                GitCommitService.access$getLog$p(this.this$0).info("All changes were omitted due to size limits");
                                return new CommitMessageResult.Error("copilot.git.commit.generate.error.changes.too.large");
                            }
                            if (diffResult instanceof DiffResult.Success) {
                                RecentCommitMessages recentMessages = GitCommitService.access$getRecentCommitMessages(this.this$0);
                                GitCommitGenerateCommand command = new GitCommitGenerateCommand(((DiffResult.Success)diffResult).getDiffs(), recentMessages.getUser(), recentMessages.getRepository());
                                CancellablePromise<GitCommitGenerateCommandResponse> promise = GitCommitService.access$getConversationClient$p(this.this$0).generateGitCommit(command);
                                GitCommitGenerateCommandResponse response = (GitCommitGenerateCommandResponse)promise.blockingGet(15000);
                                if (PromiseKt.isSuccess((Promise)promise) && response != null) {
                                    commitMessageResult2 = new CommitMessageResult.Success(((Object)StringsKt.trim((CharSequence)response.getCommitMessage())).toString());
                                } else {
                                    GitCommitService.access$getLog$p(this.this$0).warn("Failed to generate commit message: No response or unsuccessful");
                                    commitMessageResult2 = new CommitMessageResult.Error("copilot.git.commit.generate.error");
                                }
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            commitMessageResult = commitMessageResult2;
                        }
                        catch (Exception e) {
                            GitCommitService.access$getLog$p(this.this$0).warn("Error while generating commit message", e);
                            commitMessageResult = new CommitMessageResult.Error("copilot.git.commit.generate.error");
                        }
                        return commitMessageResult;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super CommitMessageResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ CommitMessageResult generateCommitMessage$default(GitCommitService gitCommitService, AbstractCommitWorkflowHandler abstractCommitWorkflowHandler, int n, Object object) {
        if ((n & 1) != 0) {
            abstractCommitWorkflowHandler = null;
        }
        return gitCommitService.generateCommitMessage(abstractCommitWorkflowHandler);
    }

    private final RecentCommitMessages getRecentCommitMessages() {
        RecentCommitMessages recentCommitMessages;
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)ProjectKt.getProject());
        VcsRoot[] vcsRootArray = vcsManager.getAllVcsRoots();
        Intrinsics.checkNotNullExpressionValue((Object)vcsRootArray, (String)"getAllVcsRoots(...)");
        VcsRoot vcsRoot = (VcsRoot)ArraysKt.firstOrNull((Object[])vcsRootArray);
        if (vcsRoot == null || (vcsRoot = vcsRoot.getVcs()) == null) {
            return new RecentCommitMessages(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
        VcsRoot vcs = vcsRoot;
        String currentUser = this.getGitMetadataService().getCurrentUser();
        try {
            VcsHistoryProvider vcsHistoryProvider = vcs.getVcsHistoryProvider();
            if (vcsHistoryProvider == null) {
                return new RecentCommitMessages(CollectionsKt.emptyList(), CollectionsKt.emptyList());
            }
            VcsHistoryProvider history = vcsHistoryProvider;
            VcsRoot[] vcsRootArray2 = vcsManager.getAllVcsRoots();
            Intrinsics.checkNotNullExpressionValue((Object)vcsRootArray2, (String)"getAllVcsRoots(...)");
            VcsRoot vcsRoot2 = (VcsRoot)ArraysKt.firstOrNull((Object[])vcsRootArray2);
            if (vcsRoot2 == null) {
                return new RecentCommitMessages(CollectionsKt.emptyList(), CollectionsKt.emptyList());
            }
            VcsRoot root = vcsRoot2;
            LocalFilePath filePath = new LocalFilePath(root.getPath().getPath(), true);
            Ref.ObjectRef result = new Ref.ObjectRef();
            result.element = new RecentCommitMessages(CollectionsKt.emptyList(), CollectionsKt.emptyList());
            ApplicationManager.getApplication().executeOnPooledThread(() -> GitCommitService.getRecentCommitMessages$lambda$5(history, filePath, currentUser, result, this)).get();
            recentCommitMessages = (RecentCommitMessages)result.element;
        }
        catch (VcsException e) {
            this.log.warn("Failed to get recent commit messages", e);
            recentCommitMessages = new RecentCommitMessages(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
        return recentCommitMessages;
    }

    private static final boolean getRecentCommitMessages$lambda$5$lambda$2(String $currentUser, VcsFileRevision revision) {
        return Intrinsics.areEqual((Object)revision.getAuthor(), (Object)$currentUser);
    }

    private static final String getRecentCommitMessages$lambda$5$lambda$4(VcsFileRevision revision) {
        String string;
        String string2 = revision.getCommitMessage();
        if (string2 != null && (string2 = StringsKt.lineSequence((CharSequence)string2)) != null) {
            Object v2;
            block3: {
                String $this$firstOrNull$iv = string2;
                boolean $i$f$firstOrNull = false;
                Iterator iterator = $this$firstOrNull$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    String it = (String)element$iv;
                    boolean bl = false;
                    boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                    if (!bl2) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            string = v2;
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final void getRecentCommitMessages$lambda$5(VcsHistoryProvider $history, LocalFilePath $filePath, String $currentUser, Ref.ObjectRef $result, GitCommitService this$0) {
        try {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            VcsHistorySession vcsHistorySession = $history.createSessionFor((FilePath)$filePath);
            if (vcsHistorySession == null) {
                return;
            }
            VcsHistorySession session = vcsHistorySession;
            List list = session.getRevisionList();
            if (list == null) {
                return;
            }
            List commits = list;
            Iterable iterable = CollectionsKt.take((Iterable)commits, (int)5);
            boolean $i$f$mapNotNull = false;
            void var10_10 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                VcsFileRevision revision = (VcsFileRevision)element$iv$iv;
                boolean bl2 = false;
                String string2 = revision.getCommitMessage();
                if (string2 != null && (string2 = StringsKt.lineSequence((CharSequence)string2)) != null) {
                    Object v4;
                    block8: {
                        String $this$firstOrNull$iv = string2;
                        boolean $i$f$firstOrNull = false;
                        Iterator iterator2 = $this$firstOrNull$iv.iterator();
                        while (iterator2.hasNext()) {
                            Object element$iv = iterator2.next();
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            boolean bl4 = !StringsKt.isBlank((CharSequence)it);
                            if (!bl4) continue;
                            v4 = element$iv;
                            break block8;
                        }
                        v4 = null;
                    }
                    string = v4;
                } else {
                    string = null;
                }
                if (string == null) continue;
                String it$iv$iv = string;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List repoMessages = (List)destination$iv$iv;
            List userMessages = $currentUser != null ? SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.take((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)commits), arg_0 -> GitCommitService.getRecentCommitMessages$lambda$5$lambda$2($currentUser, arg_0)), (int)5), GitCommitService::getRecentCommitMessages$lambda$5$lambda$4)) : CollectionsKt.emptyList();
            $result.element = new RecentCommitMessages(repoMessages, userMessages);
        }
        catch (VcsException e) {
            this$0.log.warn("Failed to get recent commit messages", e);
        }
    }

    public static final /* synthetic */ GitDiffService access$getGitDiffService(GitCommitService $this) {
        return $this.getGitDiffService();
    }

    public static final /* synthetic */ Logger access$getLog$p(GitCommitService $this) {
        return $this.log;
    }

    public static final /* synthetic */ RecentCommitMessages access$getRecentCommitMessages(GitCommitService $this) {
        return $this.getRecentCommitMessages();
    }

    public static final /* synthetic */ CopilotAgentConversationClient access$getConversationClient$p(GitCommitService $this) {
        return $this.conversationClient;
    }
}

