/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.git;

import com.github.copilot.git.DiffResult;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandler;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\u0012\b\u0002\u0010\n\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000bJ \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0010\u0010\n\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0002J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/copilot/git/GitDiffService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "getChanges", "Lcom/github/copilot/git/DiffResult;", "workflowHandler", "Lcom/intellij/vcs/commit/AbstractCommitWorkflowHandler;", "getAvailableChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "computeDiff", "", "changes", "processDiff", "diffs", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nGitDiffService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitDiffService.kt\ncom/github/copilot/git/GitDiffService\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n39#2:133\n1603#3,9:134\n1855#3:143\n1856#3:145\n1612#3:146\n1603#3,9:147\n1855#3:156\n1856#3:159\n1612#3:160\n1002#3,2:161\n1#4:144\n1#4:157\n1#4:158\n*S KotlinDebug\n*F\n+ 1 GitDiffService.kt\ncom/github/copilot/git/GitDiffService\n*L\n26#1:133\n76#1:134,9\n76#1:143\n76#1:145\n76#1:146\n86#1:147,9\n86#1:156\n86#1:159\n86#1:160\n121#1:161,2\n76#1:144\n86#1:158\n*E\n"})
public final class GitDiffService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Logger log;

    public GitDiffService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean $i$f$Logger = false;
        this.log = new GitHubLogger(GitDiffService.class);
    }

    @NotNull
    public final DiffResult getChanges(@Nullable AbstractCommitWorkflowHandler<?, ?> workflowHandler) {
        DiffResult diffResult;
        List<Change> changes = this.getAvailableChanges(workflowHandler);
        if (changes.isEmpty()) {
            this.log.info("No changes available to generate diff");
            return DiffResult.NoChanges.INSTANCE;
        }
        try {
            DiffResult diffResult2;
            List<String> diffContents = this.computeDiff(changes);
            List<String> processedDiffs = this.processDiff(diffContents);
            if (processedDiffs.isEmpty() && !((Collection)diffContents).isEmpty()) {
                this.log.info("All changes were omitted due to size limits");
                diffResult2 = DiffResult.AllChangesOmitted.INSTANCE;
            } else {
                diffResult2 = new DiffResult.Success(processedDiffs);
            }
            diffResult = diffResult2;
        }
        catch (Exception e) {
            this.log.warn("Failed to generate diff: " + e.getMessage());
            throw e;
        }
        return diffResult;
    }

    public static /* synthetic */ DiffResult getChanges$default(GitDiffService gitDiffService, AbstractCommitWorkflowHandler abstractCommitWorkflowHandler, int n, Object object) {
        if ((n & 1) != 0) {
            abstractCommitWorkflowHandler = null;
        }
        return gitDiffService.getChanges(abstractCommitWorkflowHandler);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Change> getAvailableChanges(AbstractCommitWorkflowHandler<?, ?> workflowHandler) {
        void $this$mapNotNullTo$iv$iv;
        Object object = workflowHandler;
        List includedChanges = object != null && (object = object.getUi()) != null && (object = object.getIncludedChanges()) != null ? CollectionsKt.toList((Iterable)((Iterable)object)) : null;
        Collection collection = includedChanges;
        if (!(collection == null || collection.isEmpty())) {
            return includedChanges;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        Collection collection2 = changeListManager2.getAllChanges();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getAllChanges(...)");
        List trackedChanges = CollectionsKt.toList((Iterable)collection2);
        List list = changeListManager2.getUnversionedFilesPaths();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getUnversionedFilesPaths(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Change change;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            FilePath filePath = (FilePath)element$iv$iv;
            boolean bl2 = false;
            if (LocalFileSystem.getInstance().findFileByPath(filePath.getPath()) != null) {
                boolean bl3 = false;
                change = new Change(null, (ContentRevision)new CurrentContentRevision(filePath));
            } else {
                change = null;
            }
            if (change == null) continue;
            Change it$iv$iv = change;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List untrackedFiles = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)trackedChanges, (Iterable)untrackedFiles);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> computeDiff(List<? extends Change> changes) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = changes;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            block4: {
                String string2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Change change = (Change)element$iv$iv;
                boolean bl2 = false;
                try {
                    String string3;
                    List filePatches;
                    Object object = change.getVirtualFile();
                    if (object == null || (object = object.getParent()) == null || (object = object.toNioPath()) == null) {
                        String string4;
                        string = string4 = null;
                        break block4;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)IdeaTextPatchBuilder.buildPatch((Project)this.project, (Collection)CollectionsKt.listOf((Object)change), (Path)object, (boolean)false, (boolean)true), (String)"buildPatch(...)");
                    StringWriter stringWriter = new StringWriter();
                    UnifiedDiffWriter.write((Project)this.project, (Collection)filePatches, (Writer)stringWriter, (String)"\n", null);
                    String it = string3 = stringWriter.toString();
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    string2 = ((CharSequence)it).length() > 0 ? string3 : null;
                }
                catch (Exception e) {
                    this.log.warn("Failed to generate diff for change: " + e.getMessage());
                    string2 = null;
                }
                string = string2;
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> processDiff(List<String> diffs) {
        int modelMaxPromptTokens = 64000;
        int charLimit = modelMaxPromptTokens * 4 / 3;
        List result = CollectionsKt.toMutableList((Collection)diffs);
        int availableChars = charLimit - (int)((double)charLimit * 0.2);
        int totalChars = CollectionsKt.joinToString$default((Iterable)result, (CharSequence)"", null, null, (int)0, null, null, (int)62, null).length();
        if (totalChars > availableChars) {
            List $this$sortBy$iv = result;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        String it = (String)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.length());
                        it = (String)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.length()));
                    }
                });
            }
            while (totalChars > availableChars && !((Collection)result).isEmpty()) {
                String lastDiff = (String)result.remove(CollectionsKt.getLastIndex((List)result));
                totalChars -= lastDiff.length();
            }
        }
        return result;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/github/copilot/git/GitDiffService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/github/copilot/git/GitDiffService;", "project", "Lcom/intellij/openapi/project/Project;", "core"})
    @SourceDebugExtension(value={"SMAP\nGitDiffService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitDiffService.kt\ncom/github/copilot/git/GitDiffService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,132:1\n29#2,3:133\n*S KotlinDebug\n*F\n+ 1 GitDiffService.kt\ncom/github/copilot/git/GitDiffService$Companion\n*L\n29#1:133,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitDiffService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GitDiffService> serviceClass$iv = GitDiffService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (GitDiffService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

