/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.git;

import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.config.GitConfigUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u0004\u0018\u00010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/github/copilot/git/GitMetadataService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "getCurrentUser", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nGitMetadataService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitMetadataService.kt\ncom/github/copilot/git/GitMetadataService\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,47:1\n39#2:48\n*S KotlinDebug\n*F\n+ 1 GitMetadataService.kt\ncom/github/copilot/git/GitMetadataService\n*L\n13#1:48\n*E\n"})
public final class GitMetadataService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Logger log;

    public GitMetadataService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean $i$f$Logger = false;
        this.log = new GitHubLogger(GitMetadataService.class);
    }

    @Nullable
    public final String getCurrentUser() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.project);
        VcsRoot[] vcsRootArray = vcsManager.getAllVcsRoots();
        Intrinsics.checkNotNullExpressionValue((Object)vcsRootArray, (String)"getAllVcsRoots(...)");
        VcsRoot vcsRoot = (VcsRoot)ArraysKt.firstOrNull((Object[])vcsRootArray);
        if (vcsRoot == null || (vcsRoot = vcsRoot.getPath()) == null) {
            GitMetadataService $this$getCurrentUser_u24lambda_u240 = this;
            boolean bl = false;
            $this$getCurrentUser_u24lambda_u240.log.warn("No VCS root found");
            return null;
        }
        VcsRoot root = vcsRoot;
        return (String)ApplicationManager.getApplication().executeOnPooledThread(() -> GitMetadataService.getCurrentUser$lambda$1(this, (VirtualFile)root)).get();
    }

    private static final String getCurrentUser$lambda$1(GitMetadataService this$0, VirtualFile $root) {
        String string;
        try {
            String string2;
            String userName = GitConfigUtil.getValue((Project)this$0.project, (VirtualFile)$root, (String)"user.name");
            CharSequence charSequence = userName;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                this$0.log.warn("Git user name not configured in local config");
                string2 = null;
            } else {
                this$0.log.info("Current git user: " + userName);
                string2 = string;
            }
            string = string2;
        }
        catch (Exception e) {
            this$0.log.warn("Failed to get git user: " + e.getMessage(), e);
            string = null;
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/github/copilot/git/GitMetadataService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/github/copilot/git/GitMetadataService;", "project", "Lcom/intellij/openapi/project/Project;", "core"})
    @SourceDebugExtension(value={"SMAP\nGitMetadataService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitMetadataService.kt\ncom/github/copilot/git/GitMetadataService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,47:1\n29#2,3:48\n*S KotlinDebug\n*F\n+ 1 GitMetadataService.kt\ncom/github/copilot/git/GitMetadataService$Companion\n*L\n16#1:48,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitMetadataService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GitMetadataService> serviceClass$iv = GitMetadataService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (GitMetadataService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

