/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.github;

import com.github.copilot.CopilotBundle;
import com.github.copilot.github.DeviceCodeResponse;
import com.github.copilot.github.DeviceLoginForm;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.ClipboardSynchronizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceLoginDialog
extends DialogWrapper {
    private final DeviceCodeResponse codeResponse;

    public static DeviceLoginDialog getDeviceLogin(@NotNull Project project, @NotNull DeviceCodeResponse codeResponse) {
        DeviceLoginDialog dialog = new DeviceLoginDialog(project, codeResponse);
        dialog.init();
        return dialog;
    }

    public DeviceLoginDialog(@Nullable Project project, @NotNull DeviceCodeResponse codeResponse) {
        super(project, false, DialogWrapper.IdeModalityType.IDE);
        this.codeResponse = codeResponse;
        this.setTitle(CopilotBundle.get("deviceAuth.dialog.title"));
    }

    protected void doOKAction() {
        StringSelection content = new StringSelection(this.codeResponse.getUserCode());
        ClipboardSynchronizer.getInstance().setContent((Transferable)content, (ClipboardOwner)content);
        BrowserUtil.browse((String)this.codeResponse.getVerificationUri());
        super.doOKAction();
    }

    protected Action @NotNull [] createActions() {
        DialogWrapper.DialogWrapperAction proceedButton = new DialogWrapper.DialogWrapperAction(CopilotBundle.get("deviceAuth.okButton")){

            protected void doAction(ActionEvent e) {
                DeviceLoginDialog.super.doOKAction();
            }
        };
        this.getOKAction().putValue("Name", CopilotBundle.get("deviceAuth.copyOpenButton"));
        return new Action[]{this.getOKAction(), proceedButton, this.getCancelAction()};
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return new DeviceLoginForm(this.codeResponse);
    }
}

