/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.github;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotNotifications;
import com.github.copilot.github.GitHubService;
import com.github.copilot.lang.agent.CopilotAgent;
import com.github.copilot.status.CopilotStatus;
import com.github.copilot.status.CopilotStatusService;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHubAuthStartupActivity
implements ProjectActivity {
    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> continuation) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        this.handleAuthNotifications(project);
        return null;
    }

    private void handleAuthNotifications(@NotNull Project project) {
        if (!CopilotAgent.isAgentSupported()) {
            this.notifyAgentUnavailable(project);
            return;
        }
        GitHubService service = GitHubService.getInstance();
        service.refreshStatus();
        if (!service.isSignedIn()) {
            CopilotStatusService.notifyApplication(CopilotStatus.NotSignedIn);
            service.showLoginNotification(project, false);
        } else {
            CopilotStatusService.notifyApplication(CopilotStatus.Ready);
        }
    }

    private void notifyAgentUnavailable(@NotNull Project project) {
        CopilotStatusService.notifyApplication(CopilotStatus.Unsupported);
        Notification notification = CopilotNotifications.createFullContentNotification(CopilotBundle.get("agent.unsupportedNotification.title"), CopilotBundle.get("agent.unsupportedNotification.message"), NotificationType.WARNING, true);
        notification.notify(project);
    }
}

