/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.github;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotNotifications;
import com.github.copilot.settings.CopilotApplicationSettings;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GitHubService {
    public static GitHubService getInstance() {
        return (GitHubService)ApplicationManager.getApplication().getService(GitHubService.class);
    }

    @RequiresBackgroundThread
    public void refreshStatus();

    public boolean isSignedIn();

    @RequiresEdt
    public void loginInteractive(@NotNull Project var1);

    @RequiresEdt
    public void loginInteractive(@NotNull Project var1, @Nullable String var2);

    public void logout();

    @RequiresEdt
    default public void showLoginNotification(@NotNull Project project, boolean force) {
        boolean shown = CopilotApplicationSettings.settings().signinNotificationShown;
        if (force || !shown) {
            if (!force) {
                CopilotApplicationSettings.settings().signinNotificationShown = true;
            }
            CopilotNotifications.createFullContentNotification(CopilotBundle.get("github.loginNotification.title"), CopilotBundle.get("github.loginNotification.text"), NotificationType.WARNING, true).addAction((AnAction)NotificationAction.createSimpleExpiring((String)CopilotBundle.get("github.loginNotification.loginAction"), () -> GitHubService.getInstance().loginInteractive(project))).notify(project);
        }
    }
}

