/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.github;

import com.github.copilot.AuthHelper;
import com.github.copilot.GitHubAccountCredentials;
import com.github.copilot.settings.CopilotApplicationSettings;
import com.github.copilot.settings.CopilotApplicationState;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlinx.coroutines.BuildersKt;

public class IdeaGitHubAccounts {
    private final CopilotApplicationState state;

    public IdeaGitHubAccounts() {
        this(CopilotApplicationSettings.settings());
    }

    public IdeaGitHubAccounts(CopilotApplicationState state) {
        this.state = state;
    }

    public boolean hasNecessaryAccountSetup() {
        return !this.getPossibleAccounts().isEmpty();
    }

    public String getUsername() {
        return this.getSupportedAccount().getUsername();
    }

    public String getToken() {
        return this.getSupportedAccount().getToken();
    }

    public List<? extends GitHubAccountCredentials> getPossibleAccounts() {
        return this.getAllAccounts().stream().sorted(Comparator.comparing(acc -> !acc.getId().equals(this.state.preferredAccount)).thenComparing(GitHubAccountCredentials::getUsername)).filter(a -> !a.getUsername().isEmpty()).filter(a -> a.getServer().isGithubDotCom()).filter(a -> !a.getToken().startsWith("ghp_")).toList();
    }

    private GitHubAccountCredentials getSupportedAccount() {
        return (GitHubAccountCredentials)this.getPossibleAccounts().stream().findFirst().orElseThrow(() -> new UnsupportedOperationException("Should not access credentials without checking for account setup"));
    }

    protected Set<GitHubAccountCredentials> getAllAccounts() {
        try {
            HashSet<GitHubAccountCredentials> realAccounts = new HashSet<GitHubAccountCredentials>((Collection)BuildersKt.runBlocking((CoroutineContext)EmptyCoroutineContext.INSTANCE, (scope, continuation) -> AuthHelper.INSTANCE.getAccounts((Continuation<? super Set<GitHubAccountCredentials>>)continuation)));
            return realAccounts;
        }
        catch (NoClassDefFoundError e) {
            return Set.of();
        }
        catch (Exception e) {
            return Set.of();
        }
    }
}

