/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.github;

import com.github.copilot.github.IdeaGitHubAccounts;
import com.github.copilot.lang.agent.CopilotAgentProcessService;
import com.github.copilot.lang.agent.commands.AuthStatusResult;
import com.github.copilot.lang.agent.commands.SignInWithGitHubTokenCommand;
import com.github.copilot.util.Experiments;
import com.github.copilot.util.LoggerUtil;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.TimeUnit;

public class IdeaGitHubAuthentication {
    private static final int SIGN_IN_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(10L);
    private static final Logger LOG = Logger.getInstance(IdeaGitHubAuthentication.class);
    private static boolean isNewAuthFlowEnabled = "true".equals(System.getenv("COPILOT_NEW_AUTH_FLOW"));

    public static boolean isEnabled() {
        return isNewAuthFlowEnabled || Experiments.chooseUser("new auth flow", 0.0);
    }

    public static void enableNewAuthFlowEnabled(boolean state) {
        isNewAuthFlowEnabled = state;
    }

    public static AuthStatusResult loginWithIDEToken() {
        return IdeaGitHubAuthentication.loginWithIDEToken(new IdeaGitHubAccounts());
    }

    public static AuthStatusResult loginWithIDEToken(IdeaGitHubAccounts ideGhAccounts) {
        String username = ideGhAccounts.getUsername();
        String token = ideGhAccounts.getToken();
        try {
            return (AuthStatusResult)CopilotAgentProcessService.getInstance().executeCommand(new SignInWithGitHubTokenCommand(username, token)).onError(LoggerUtil.LogAsDebug).blockingGet(SIGN_IN_TIMEOUT_MILLIS);
        }
        catch (Exception e) {
            LOG.warn("Failed to initiate sign in", (Throwable)e);
            return AuthStatusResult.forFailedToGetToken();
        }
    }
}

