/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang;

import com.github.copilot.lang.LanguageInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageInfoManager {
    @RequiresReadLock
    @NotNull
    public static LanguageInfo findLanguage(@NotNull PsiFile psiFile) {
        return LanguageInfoManager.findLanguageMapping(psiFile.getFileType());
    }

    @RequiresReadLock
    @NotNull
    public static LanguageInfo findLanguage(@Nullable Project project, @NotNull VirtualFile file) {
        PsiFile psiFile = project != null && !project.isDisposed() ? PsiManager.getInstance((Project)project).findFile(file) : null;
        return psiFile == null ? LanguageInfoManager.findLanguageMapping(file.getFileType()) : LanguageInfoManager.findLanguageMapping(psiFile.getFileType());
    }

    @NotNull
    static LanguageInfo findLanguageMapping(@NotNull FileType fileType) {
        Language language = Language.ANY;
        if (fileType instanceof LanguageFileType) {
            language = ((LanguageFileType)fileType).getLanguage();
        }
        return new LanguageInfo(language);
    }
}

