/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent;

import com.github.copilot.editor.CopilotEditorUtil;
import com.github.copilot.lang.LanguageInfo;
import com.github.copilot.lang.LanguageInfoManager;
import com.github.copilot.lang.agent.lsp.VirtualFileUri;
import com.github.copilot.lsp.LSPUtil;
import com.github.copilot.request.CompletionType;
import com.github.copilot.request.EditorRequest;
import com.github.copilot.request.LineInfo;
import com.github.copilot.request.RequestId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class AgentEditorRequest
implements EditorRequest,
Disposable {
    private static final Logger LOG = Logger.getInstance(AgentEditorRequest.class);
    private final Project project;
    private final CompletionType completionType;
    private final boolean useTabIndents;
    private final int tabWidth;
    private final int requestId;
    private final LanguageInfo fileLanguage;
    @NotNull
    private final VirtualFileUri uri;
    private final String documentContent;
    private final int documentVersion;
    private final int offset;
    @NotNull
    private final LineInfo lineInfo;
    private final long requestTimestamp = System.currentTimeMillis();
    private final long documentModificationSequence;
    private volatile boolean isCancelled;

    @TestOnly
    public static EditorRequest createEmptyGhostText(@NotNull Editor editor) {
        return AgentEditorRequest.create(editor, 0, CompletionType.GhostText);
    }

    @Nullable
    public static EditorRequest create(@NotNull Editor editor, int offset, @NotNull CompletionType completionType) {
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file == null) {
            return null;
        }
        boolean useTabs = editor.getSettings().isUseTabCharacter(project);
        int tabWidth = editor.getSettings().getTabSize(project);
        LineInfo lineInfo = LineInfo.create(document, offset);
        VirtualFileUri uri = VirtualFileUri.from(file.getVirtualFile());
        return new AgentEditorRequest(project, completionType, useTabs, tabWidth, RequestId.incrementAndGet(), LanguageInfoManager.findLanguage(file), uri, document.getText(), LSPUtil.version(document), offset, lineInfo, CopilotEditorUtil.getDocumentModificationStamp(document));
    }

    @Override
    public void cancel() {
        if (this.isCancelled) {
            return;
        }
        this.isCancelled = true;
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        LOG.debug("EditorRequest.dispose");
        this.isCancelled = true;
    }

    @Override
    public boolean equalsRequest(@NotNull EditorRequest o) {
        return this.requestId == o.getRequestId();
    }

    @Override
    public Disposable getDisposable() {
        return this;
    }

    @Override
    @Generated
    public Project getProject() {
        return this.project;
    }

    @Override
    @Generated
    public CompletionType getCompletionType() {
        return this.completionType;
    }

    @Override
    @Generated
    public boolean isUseTabIndents() {
        return this.useTabIndents;
    }

    @Override
    @Generated
    public int getTabWidth() {
        return this.tabWidth;
    }

    @Override
    @Generated
    public int getRequestId() {
        return this.requestId;
    }

    @Override
    @Generated
    public LanguageInfo getFileLanguage() {
        return this.fileLanguage;
    }

    @NotNull
    @Generated
    public VirtualFileUri getUri() {
        return this.uri;
    }

    @Override
    @Generated
    public String getDocumentContent() {
        return this.documentContent;
    }

    @Override
    @Generated
    public int getDocumentVersion() {
        return this.documentVersion;
    }

    @Override
    @Generated
    public int getOffset() {
        return this.offset;
    }

    @Override
    @NotNull
    @Generated
    public LineInfo getLineInfo() {
        return this.lineInfo;
    }

    @Override
    @Generated
    public long getRequestTimestamp() {
        return this.requestTimestamp;
    }

    @Override
    @Generated
    public long getDocumentModificationSequence() {
        return this.documentModificationSequence;
    }

    @Override
    @Generated
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Generated
    public void setCancelled(boolean isCancelled) {
        this.isCancelled = isCancelled;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentEditorRequest)) {
            return false;
        }
        AgentEditorRequest other = (AgentEditorRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseTabIndents() != other.isUseTabIndents()) {
            return false;
        }
        if (this.getTabWidth() != other.getTabWidth()) {
            return false;
        }
        if (this.getRequestId() != other.getRequestId()) {
            return false;
        }
        if (this.getDocumentVersion() != other.getDocumentVersion()) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getRequestTimestamp() != other.getRequestTimestamp()) {
            return false;
        }
        if (this.getDocumentModificationSequence() != other.getDocumentModificationSequence()) {
            return false;
        }
        if (this.isCancelled() != other.isCancelled()) {
            return false;
        }
        Project this$project = this.getProject();
        Project other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        CompletionType this$completionType = this.getCompletionType();
        CompletionType other$completionType = other.getCompletionType();
        if (this$completionType == null ? other$completionType != null : !((Object)((Object)this$completionType)).equals((Object)other$completionType)) {
            return false;
        }
        LanguageInfo this$fileLanguage = this.getFileLanguage();
        LanguageInfo other$fileLanguage = other.getFileLanguage();
        if (this$fileLanguage == null ? other$fileLanguage != null : !((Object)this$fileLanguage).equals(other$fileLanguage)) {
            return false;
        }
        VirtualFileUri this$uri = this.getUri();
        VirtualFileUri other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        String this$documentContent = this.getDocumentContent();
        String other$documentContent = other.getDocumentContent();
        if (this$documentContent == null ? other$documentContent != null : !this$documentContent.equals(other$documentContent)) {
            return false;
        }
        LineInfo this$lineInfo = this.getLineInfo();
        LineInfo other$lineInfo = other.getLineInfo();
        return !(this$lineInfo == null ? other$lineInfo != null : !((Object)this$lineInfo).equals(other$lineInfo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AgentEditorRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseTabIndents() ? 79 : 97);
        result = result * 59 + this.getTabWidth();
        result = result * 59 + this.getRequestId();
        result = result * 59 + this.getDocumentVersion();
        result = result * 59 + this.getOffset();
        long $requestTimestamp = this.getRequestTimestamp();
        result = result * 59 + (int)($requestTimestamp >>> 32 ^ $requestTimestamp);
        long $documentModificationSequence = this.getDocumentModificationSequence();
        result = result * 59 + (int)($documentModificationSequence >>> 32 ^ $documentModificationSequence);
        result = result * 59 + (this.isCancelled() ? 79 : 97);
        Project $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        CompletionType $completionType = this.getCompletionType();
        result = result * 59 + ($completionType == null ? 43 : ((Object)((Object)$completionType)).hashCode());
        LanguageInfo $fileLanguage = this.getFileLanguage();
        result = result * 59 + ($fileLanguage == null ? 43 : ((Object)$fileLanguage).hashCode());
        VirtualFileUri $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        String $documentContent = this.getDocumentContent();
        result = result * 59 + ($documentContent == null ? 43 : $documentContent.hashCode());
        LineInfo $lineInfo = this.getLineInfo();
        result = result * 59 + ($lineInfo == null ? 43 : ((Object)$lineInfo).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AgentEditorRequest(completionType=" + String.valueOf((Object)this.getCompletionType()) + ", useTabIndents=" + this.isUseTabIndents() + ", tabWidth=" + this.getTabWidth() + ", requestId=" + this.getRequestId() + ", fileLanguage=" + String.valueOf(this.getFileLanguage()) + ", uri=" + String.valueOf(this.getUri()) + ", documentContent=" + this.getDocumentContent() + ", documentVersion=" + this.getDocumentVersion() + ", offset=" + this.getOffset() + ", lineInfo=" + String.valueOf(this.getLineInfo()) + ", requestTimestamp=" + this.getRequestTimestamp() + ", documentModificationSequence=" + this.getDocumentModificationSequence() + ", isCancelled=" + this.isCancelled() + ")";
    }

    @Generated
    public AgentEditorRequest(Project project, CompletionType completionType, boolean useTabIndents, int tabWidth, int requestId, LanguageInfo fileLanguage, @NotNull VirtualFileUri uri, String documentContent, int documentVersion, int offset, @NotNull LineInfo lineInfo, long documentModificationSequence) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        if (lineInfo == null) {
            throw new NullPointerException("lineInfo is marked non-null but is null");
        }
        this.project = project;
        this.completionType = completionType;
        this.useTabIndents = useTabIndents;
        this.tabWidth = tabWidth;
        this.requestId = requestId;
        this.fileLanguage = fileLanguage;
        this.uri = uri;
        this.documentContent = documentContent;
        this.documentVersion = documentVersion;
        this.offset = offset;
        this.lineInfo = lineInfo;
        this.documentModificationSequence = documentModificationSequence;
    }
}

