/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotNotifications;
import com.github.copilot.github.DeviceCodeResponse;
import com.github.copilot.github.DeviceLoginDialog;
import com.github.copilot.github.GitHubAuthUtil;
import com.github.copilot.github.GitHubService;
import com.github.copilot.github.IdeaGitHubAccounts;
import com.github.copilot.github.IdeaGitHubAuthentication;
import com.github.copilot.lang.agent.CopilotAgentProcessService;
import com.github.copilot.lang.agent.InteractiveLoginFlow;
import com.github.copilot.lang.agent.SignInException;
import com.github.copilot.lang.agent.commands.AuthStatusResult;
import com.github.copilot.lang.agent.commands.CheckStatusCommand;
import com.github.copilot.lang.agent.commands.SignInConfirmCommand;
import com.github.copilot.lang.agent.commands.SignInInitiateCommand;
import com.github.copilot.lang.agent.commands.SignInInitiateNotSignedInResult;
import com.github.copilot.lang.agent.commands.SignInInitiateResult;
import com.github.copilot.lang.agent.commands.SignOutCommand;
import com.github.copilot.lang.agent.commands.TelemetryNewLoginCommand;
import com.github.copilot.lang.agent.commands.TelemetrySuccessfulLoginCommand;
import com.github.copilot.lang.agent.rpc.JsonRpcErrorException;
import com.github.copilot.status.CopilotStatus;
import com.github.copilot.status.CopilotStatusService;
import com.github.copilot.util.LoggerUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.concurrent.CancellationException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;

public class AgentGitHubService
implements GitHubService {
    private static final Logger LOG = Logger.getInstance(AgentGitHubService.class);
    private static final int DEFAULT_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(60L);
    private static final int SIGN_IN_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(180L);
    private final Object sessionLock = new Object();
    @GuardedBy(value="sessionLock")
    @Nullable
    private AuthStatusResult status;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresBackgroundThread
    public void refreshStatus() {
        AuthStatusResult status;
        try {
            status = (AuthStatusResult)CopilotAgentProcessService.getInstance().executeCommand(new CheckStatusCommand()).onError(LoggerUtil.LogAsDebug).blockingGet(DEFAULT_TIMEOUT_MILLIS);
        }
        catch (Exception e) {
            status = AuthStatusResult.forFailedToGetToken();
        }
        Object object = this.sessionLock;
        synchronized (object) {
            this.status = status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSignedIn() {
        Object object = this.sessionLock;
        synchronized (object) {
            return this.status != null && this.status.isSignedIn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public AuthStatusResult getStatus() {
        Object object = this.sessionLock;
        synchronized (object) {
            return this.status;
        }
    }

    @Override
    public void loginInteractive(@NotNull Project project) {
        this.loginInteractive(project, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loginInteractive(@NotNull Project project, @Nullable String githubAppId) {
        AuthStatusResult confirmResult;
        InteractiveLoginFlow.AuthFlow flow = InteractiveLoginFlow.AuthFlow.DeviceFlow;
        if (IdeaGitHubAuthentication.isEnabled()) {
            InteractiveLoginFlow authFlow = new InteractiveLoginFlow(project, this, new IdeaGitHubAccounts());
            flow = authFlow.pickAuthFlow();
            if (flow == InteractiveLoginFlow.AuthFlow.Cancel) {
                return;
            }
            if (flow == InteractiveLoginFlow.AuthFlow.NativeIDEToken && IdeaGitHubAuthentication.isEnabled()) {
                this.trackIDELoginAttemptTelemetry();
                confirmResult = IdeaGitHubAuthentication.loginWithIDEToken();
            } else {
                confirmResult = this.doDeviceAuthFlow(project, githubAppId);
            }
        } else {
            confirmResult = this.doDeviceAuthFlow(project, githubAppId);
        }
        if (confirmResult == null) {
            return;
        }
        if (confirmResult.isError()) {
            CopilotStatusService.notifyApplication(CopilotStatus.UnknownError);
            String error = CopilotBundle.get("github.login.errorGenericMessage");
            if (confirmResult.getErrorMessage() != null) {
                error = CopilotBundle.get("github.login.errorMessageWithDetails", confirmResult.getErrorMessage());
            }
            CopilotNotifications.createFullContentNotification(CopilotBundle.get("github.login.errorTitle"), error, NotificationType.ERROR, false).notify(project);
            return;
        }
        Object object = this.sessionLock;
        synchronized (object) {
            this.status = confirmResult;
        }
        if (confirmResult.isSignedIn()) {
            this.trackLoginSuccessful(flow);
            CopilotStatusService.notifyApplication(CopilotStatus.Ready);
            CopilotNotifications.createFullContentNotification(CopilotBundle.get("github.login.successTitle"), CopilotBundle.get("github.login.successMessage"), NotificationType.INFORMATION, false).notify(project);
        } else if (confirmResult.isUnauthorized()) {
            CopilotStatusService.notifyApplication(CopilotStatus.NotAuthorized);
            GitHubAuthUtil.showUnauthorizedMessage(project);
        } else {
            CopilotStatusService.notifyApplication(CopilotStatus.NotSignedIn);
        }
    }

    private void trackIDELoginAttemptTelemetry() {
        CopilotAgentProcessService.getInstance().executeCommand(new TelemetryNewLoginCommand("menu", "editorAuth"));
    }

    private void trackLoginSuccessful(InteractiveLoginFlow.AuthFlow flow) {
        String authType = flow == InteractiveLoginFlow.AuthFlow.DeviceFlow ? "deviceFlow" : "editorAuth";
        CopilotAgentProcessService.getInstance().executeCommand(new TelemetrySuccessfulLoginCommand(authType));
    }

    @Nullable
    private AuthStatusResult doDeviceAuthFlow(@NotNull Project project, @Nullable String githubAppId) {
        SignInInitiateResult initiateSignInResponse;
        try {
            initiateSignInResponse = this.initiateSignIn(project, githubAppId);
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        catch (SignInException e) {
            LOG.warn("Failed to initiate sign in", (Throwable)e);
            CopilotStatusService.notifyApplication(CopilotStatus.UnknownError);
            CopilotNotifications.createFullContentNotification(CopilotBundle.get("activity.copilot.signin.error.notification.title"), CopilotBundle.get("activity.copilot.signin.error.notification.message", e.getMessage()), NotificationType.ERROR, false).notify(project);
            return null;
        }
        if (initiateSignInResponse == null) {
            CopilotNotifications.createFullContentNotification(CopilotBundle.get("deviceAuth.deviceCodeFetchFailed.title"), CopilotBundle.get("deviceAuth.deviceCodeFetchFailed.description"), NotificationType.ERROR, true).notify(project);
            return null;
        }
        if (initiateSignInResponse.isAlreadySignedIn()) {
            LOG.debug("agent replied that the user is already signed in");
            CopilotStatusService.notifyApplication(CopilotStatus.Ready);
            return null;
        }
        SignInInitiateNotSignedInResult notSignedInResult = (SignInInitiateNotSignedInResult)initiateSignInResponse;
        DeviceLoginDialog deviceLoginDialog = DeviceLoginDialog.getDeviceLogin(project, this.asCodeResponse(notSignedInResult));
        CancellablePromise<AuthStatusResult> signInResponsePromise = CopilotAgentProcessService.getInstance().executeCommand(new SignInConfirmCommand());
        signInResponsePromise.onError(LoggerUtil.LogAsDebug);
        signInResponsePromise.onSuccess(status -> ApplicationManager.getApplication().invokeLater(() -> ((DeviceLoginDialog)deviceLoginDialog).disposeIfNeeded(), ModalityState.any()));
        if (!deviceLoginDialog.showAndGet() && !signInResponsePromise.isSucceeded()) {
            LOG.debug("Device login dialog was cancelled");
            signInResponsePromise.cancel(true);
            return null;
        }
        AuthStatusResult confirmResult = this.confirmSignIn(project, notSignedInResult.getUserCode(), signInResponsePromise);
        if (confirmResult == null) {
            signInResponsePromise.cancel(true);
            return null;
        }
        return confirmResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout() {
        Object object = this.sessionLock;
        synchronized (object) {
            this.status = null;
        }
        CopilotAgentProcessService.getInstance().executeCommand(new SignOutCommand()).onError(throwable -> {
            Object object = this.sessionLock;
            synchronized (object) {
                this.status = null;
            }
        }).onSuccess(authStatus -> {
            Object object = this.sessionLock;
            synchronized (object) {
                this.status = authStatus;
            }
        });
    }

    @Nullable
    private SignInInitiateResult initiateSignIn(@NotNull Project project, final @Nullable String githubAppId) throws ProcessCanceledException {
        try {
            String title = CopilotBundle.get("deviceAuth.fetchingDeviceCode");
            return (SignInInitiateResult)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<SignInInitiateResult, Exception>(project, title, true){

                protected SignInInitiateResult compute(@NotNull ProgressIndicator indicator) {
                    CancellablePromise<SignInInitiateResult> promise = CopilotAgentProcessService.getInstance().executeCommand(new SignInInitiateCommand(githubAppId));
                    promise.onError(LoggerUtil.LogAsDebug);
                    return AgentGitHubService.awaitWithCheckCanceled(promise, indicator, SIGN_IN_TIMEOUT_MILLIS);
                }
            });
        }
        catch (JsonRpcErrorException e) {
            if (e.getCause() != null) {
                throw new SignInException(e.getCause().getMessage());
            }
            throw new SignInException(e.getMessage());
        }
        catch (Exception e) {
            if (e instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)((Object)e);
            }
            LOG.warn("error retrieving device code", (Throwable)e);
            return null;
        }
    }

    private DeviceCodeResponse asCodeResponse(@NotNull SignInInitiateNotSignedInResult r) {
        return new DeviceCodeResponse("", r.getUserCode(), r.getVerificationUri(), r.getExpiresInSeconds(), r.getIntervalSeconds());
    }

    @Nullable
    private AuthStatusResult confirmSignIn(@Nullable Project project, final @NotNull String userCode, final @NotNull CancellablePromise<AuthStatusResult> signInResponsePromise) {
        try {
            String title = CopilotBundle.get("deviceAuth.progressTitle");
            return (AuthStatusResult)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<AuthStatusResult, Exception>(project, title, true){

                protected AuthStatusResult compute(@NotNull ProgressIndicator indicator) {
                    indicator.setText2(CopilotBundle.get("deviceAuth.progressTitle2", userCode));
                    return (AuthStatusResult)AgentGitHubService.awaitWithCheckCanceled(signInResponsePromise, indicator);
                }
            });
        }
        catch (Exception e) {
            if (e instanceof ProcessCanceledException) {
                return null;
            }
            if (e instanceof SignInException) {
                return AuthStatusResult.forError((SignInException)e);
            }
            LOG.warn("error polling for GitHub token", (Throwable)e);
            return AuthStatusResult.forFailedToGetToken();
        }
    }

    private static <T> T awaitWithCheckCanceled(@NotNull Promise<T> promise, @Nullable ProgressIndicator indicator) {
        return AgentGitHubService.awaitWithCheckCanceled(promise, indicator, null);
    }

    private static <T> T awaitWithCheckCanceled(@NotNull Promise<T> promise, @Nullable ProgressIndicator indicator, @Nullable Integer timeoutMillis) {
        long deadline = timeoutMillis != null ? System.currentTimeMillis() + (long)timeoutMillis.intValue() : Long.MAX_VALUE;
        while (true) {
            ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled((ProgressIndicator)indicator);
            try {
                return (T)promise.blockingGet(10, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException | TimeoutException e) {
                if (System.currentTimeMillis() < deadline) continue;
                ExceptionUtil.rethrow((Throwable)e);
                continue;
            }
            catch (Throwable e) {
                Throwable cause = e.getCause();
                if (cause instanceof ProcessCanceledException) {
                    throw (ProcessCanceledException)cause;
                }
                if (cause instanceof CancellationException) {
                    throw new ProcessCanceledException(cause);
                }
                ExceptionUtil.rethrow((Throwable)e);
                continue;
            }
            break;
        }
    }
}

