/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent;

import com.github.copilot.lang.agent.CopilotAgentUtil;
import com.github.copilot.telemetry.TelemetryService;
import com.github.copilot.util.DebugServer;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.system.CpuArch;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopilotAgentCommandLine {
    private static final Logger LOG = Logger.getInstance(CopilotAgentCommandLine.class);
    private static final int RESTARTS_UNTIL_FALLBACK = 3;
    static final int MAX_RESTART_ATTEMPTS = 10;

    @NotNull
    static GeneralCommandLine createAgentCommandLine(boolean enableDebugMode, int restartCount) {
        boolean useFallback = restartCount >= 3 && CopilotAgentCommandLine.getNodeExecutablePath() != null;
        GeneralCommandLine cmdline = CopilotAgentCommandLine.shouldUseBinary() && !useFallback ? CopilotAgentCommandLine.createBinaryCommandLine() : CopilotAgentCommandLine.createJavaScriptCommandLine();
        cmdline.setCharset(StandardCharsets.UTF_8);
        if (enableDebugMode) {
            cmdline.withEnvironment("GITHUB_COPILOT_DEBUG", "true");
            cmdline.withEnvironment("COPILOT_AGENT_VERBOSE", "true");
            DebugServer.enableDebugServer(cmdline);
        }
        if (restartCount >= 1) {
            cmdline.withEnvironment("NODE_OPTIONS", "");
        }
        if (restartCount >= 2) {
            cmdline.withEnvironment("NODE_ICU_DATA", "");
        }
        return cmdline;
    }

    private static boolean shouldUseBinary() {
        String env = System.getenv("COPILOT_BINARY");
        if (env != null && !env.isEmpty()) {
            return "true".equals(env);
        }
        return CopilotAgentCommandLine.findBinary() != null;
    }

    @NotNull
    public static GeneralCommandLine createJavaScriptCommandLine() {
        Path nodePath = CopilotAgentCommandLine.getNodeExecutablePath();
        Path distPath = CopilotAgentUtil.getAgentDirectoryPath();
        if (nodePath == null || distPath == null) {
            throw new IllegalStateException("Unable to locate node or dist dir");
        }
        Path jsFilePath = distPath.resolve("language-server.js");
        if (!Files.exists(jsFilePath, new LinkOption[0])) {
            throw new IllegalStateException("Unable to locate language-server.js file");
        }
        return new GeneralCommandLine(new String[]{nodePath.toString(), jsFilePath.toString(), "--stdio"});
    }

    @NotNull
    public static GeneralCommandLine createBinaryCommandLine() {
        Path executablePath = CopilotAgentCommandLine.findBinary();
        if (executablePath == null) {
            throw new IllegalStateException("Unable to locate language server binary");
        }
        if (SystemInfoRt.isUnix && !Files.isExecutable(executablePath)) {
            try {
                FileUtil.setExecutable((File)executablePath.toFile());
            }
            catch (IOException e) {
                LOG.warn("Failed to make binary executable", (Throwable)e);
            }
        }
        return new GeneralCommandLine(new String[]{executablePath.toString(), "--stdio"});
    }

    @Nullable
    public static Path findBinary() {
        if (!SystemInfoRt.isMac && !CpuArch.isIntel64()) {
            String arch = System.getProperty("os.arch");
            LOG.debug("Language server binary is unsupported, os.arch: " + arch);
            TelemetryService.getInstance().track("editor.intellij.agentUnsupported", Map.of("os.arch", arch));
            return null;
        }
        Path binDir = CopilotAgentUtil.getAgentBinaryDirectoryPath();
        if (binDir == null) {
            return null;
        }
        Path executable = null;
        if (SystemInfoRt.isLinux) {
            executable = binDir.resolve("linux-x64/copilot-language-server");
        } else if (SystemInfoRt.isWindows) {
            executable = binDir.resolve("win32-x64/copilot-language-server.exe");
        } else if (SystemInfoRt.isMac) {
            executable = CpuArch.isArm64() ? binDir.resolve("darwin-arm64/copilot-language-server") : binDir.resolve("darwin-x64/copilot-language-server");
        }
        return executable != null && Files.exists(executable, new LinkOption[0]) ? executable : null;
    }

    @Nullable
    public static Path getNodeExecutablePath() {
        File path = PathEnvironmentVariableUtil.findExecutableInPathOnAnyOS((String)"node");
        if (path == null) {
            LOG.debug("node executable not found in $PATH");
            return null;
        }
        Path nioPath = path.toPath();
        if (SystemInfoRt.isUnix && !Files.isExecutable(nioPath)) {
            LOG.warn("node executable has no execute permissions: " + String.valueOf(nioPath));
            return null;
        }
        LOG.debug("Found node executable at " + String.valueOf(nioPath));
        return nioPath;
    }
}

