/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent;

import com.github.copilot.completions.CompletionUtil;
import com.github.copilot.completions.CopilotCompletion;
import com.github.copilot.completions.CopilotCompletionService;
import com.github.copilot.completions.CopilotEditorInlay;
import com.github.copilot.completions.CopilotInlayList;
import com.github.copilot.completions.OpenCopilotSolution;
import com.github.copilot.editor.CopilotApplyInlayStrategy;
import com.github.copilot.lang.agent.AgentCompletion;
import com.github.copilot.lang.agent.AgentEditorRequest;
import com.github.copilot.lang.agent.CopilotAgent;
import com.github.copilot.lang.agent.CopilotAgentProcessService;
import com.github.copilot.lang.agent.CopilotAgentProcessStatusListener;
import com.github.copilot.lang.agent.commands.CompletionsCommand;
import com.github.copilot.lang.agent.commands.Document;
import com.github.copilot.lang.agent.commands.GetCompletionsCommand;
import com.github.copilot.lang.agent.commands.GetCompletionsCyclingCommand;
import com.github.copilot.lang.agent.commands.GetCompletionsResult;
import com.github.copilot.lang.agent.commands.GetPanelCompletionsCommand;
import com.github.copilot.lang.agent.commands.GetPanelCompletionsResult;
import com.github.copilot.lang.agent.commands.NotifyAcceptedCommand;
import com.github.copilot.lang.agent.commands.NotifyRejectedCommand;
import com.github.copilot.lang.agent.commands.NotifyShownCommand;
import com.github.copilot.lang.agent.lsp.Position;
import com.github.copilot.lang.agent.lsp.Range;
import com.github.copilot.lang.agent.rpc.JsonRPC;
import com.github.copilot.request.CompletionType;
import com.github.copilot.request.EditorRequest;
import com.github.copilot.settings.CopilotApplicationSettings;
import com.github.copilot.settings.CopilotApplicationState;
import com.github.copilot.util.FileSizeUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Flow;
import java.util.concurrent.SubmissionPublisher;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;

public class CopilotAgentCompletionService
implements CopilotCompletionService,
Disposable {
    private static final Logger LOG = Logger.getInstance(CopilotAgentCompletionService.class);

    public CopilotAgentCompletionService() {
        MessageBus bus = ApplicationManager.getApplication().getMessageBus();
        bus.connect((Disposable)this).subscribe(CopilotAgentProcessStatusListener.TOPIC, this::reset);
    }

    public void dispose() {
        this.reset();
    }

    @Override
    public boolean isAvailable(@NotNull Editor editor) {
        if (!CopilotAgent.isAgentSupported()) {
            return false;
        }
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        CopilotApplicationState settings = CopilotApplicationSettings.settings();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        return file != null && !(file instanceof PsiBinaryFile) && !file.getFileType().isBinary() && FileSizeUtil.isSupported(file.getVirtualFile()) && settings.isEnabled(file.getLanguage());
    }

    @Override
    @Nullable
    public EditorRequest createRequest(@NotNull Editor editor, int offset, @NotNull CompletionType completionType) {
        return AgentEditorRequest.create(editor, offset, completionType);
    }

    @Override
    public boolean fetchCompletions(@NotNull EditorRequest request, @Nullable Integer maxCompletions, boolean cycling, @NotNull Flow.Subscriber<List<CopilotInlayList>> subscriber) {
        assert (request.getCompletionType() == CompletionType.GhostText);
        Document doc = this.createDocument(request);
        CompletionsCommand<GetCompletionsResult> command = cycling ? new GetCompletionsCyclingCommand(doc, null) : new GetCompletionsCommand(doc, null);
        CancellablePromise<GetCompletionsResult> promise = CopilotAgentProcessService.getInstance().executeCommand(command);
        if (promise.getState() == Promise.State.REJECTED) {
            LOG.warn("promise was rejected: " + String.valueOf(promise));
            try (SubmissionPublisher<List<CopilotInlayList>> publisher = new SubmissionPublisher<List<CopilotInlayList>>();){
                publisher.subscribe(subscriber);
                publisher.closeExceptionally(new IllegalStateException("promise was rejected"));
            }
            return false;
        }
        Disposer.tryRegister((Disposable)request.getDisposable(), () -> promise.cancel());
        promise.onError(throwable -> {
            try (SubmissionPublisher publisher = new SubmissionPublisher();){
                publisher.subscribe(subscriber);
                publisher.closeExceptionally((Throwable)throwable);
            }
        });
        promise.onSuccess(result -> {
            try (SubmissionPublisher publisher = new SubmissionPublisher();){
                publisher.subscribe(subscriber);
                ArrayList<AgentCompletionList> inlayLists = new ArrayList<AgentCompletionList>();
                List<GetCompletionsResult.Completion> completions = result.getCompletions();
                for (GetCompletionsResult.Completion completion : completions) {
                    AgentCompletion agentCompletion = new AgentCompletion(completion);
                    CopilotInlayList inlays = CompletionUtil.createEditorCompletion(request, agentCompletion, true);
                    inlayLists.add(new AgentCompletionList(inlays, agentCompletion, request));
                }
                if (!inlayLists.isEmpty()) {
                    publisher.submit(inlayLists);
                }
            }
        });
        return true;
    }

    @Override
    public boolean fetchOpenCopilotSolutions(@NotNull EditorRequest request,  @NotNull Flow.Subscriber<List<OpenCopilotSolution>> subscriber) {
        String panelId = UUID.randomUUID().toString();
        GetPanelCompletionsCommand command = new GetPanelCompletionsCommand(panelId, this.createDocument(request), null);
        CopilotAgentProcessService service = CopilotAgentProcessService.getInstance();
        CancellablePromise<GetPanelCompletionsResult> promise = service.executeCommand(command);
        if (promise.getState() == Promise.State.REJECTED) {
            LOG.warn("promise was rejected: " + String.valueOf(promise));
            try (SubmissionPublisher<List<OpenCopilotSolution>> publisher = new SubmissionPublisher<List<OpenCopilotSolution>>();){
                publisher.subscribe(subscriber);
                publisher.closeExceptionally(new IllegalStateException("promise was rejected"));
            }
            return false;
        }
        promise.onError(throwable -> {
            try (SubmissionPublisher publisher = new SubmissionPublisher();){
                publisher.subscribe(subscriber);
                publisher.closeExceptionally((Throwable)throwable);
            }
        });
        SubmissionPublisher<List<OpenCopilotSolution>> publisher = new SubmissionPublisher<List<OpenCopilotSolution>>();
        publisher.subscribe(subscriber);
        Disposable disposable = Disposer.newDisposable();
        Disposer.register((Disposable)disposable, publisher::close);
        Disposer.tryRegister((Disposable)request.getDisposable(), (Disposable)disposable);
        service.addNotificationListener(disposable, (name, message) -> {
            if (!"PanelSolutionsDone".equals(name)) {
                return false;
            }
            if (publisher.isClosed()) {
                return false;
            }
            GetPanelCompletionsResult.DoneStatus status = JsonRPC.parseResponse(message, GetPanelCompletionsResult.DoneStatus.class);
            if (!panelId.equals(status.getPanelId())) {
                return false;
            }
            Disposer.dispose((Disposable)disposable);
            if (status.isError()) {
                publisher.closeExceptionally(new Exception(status.getErrorMessage()));
            } else if (status.isOk()) {
                publisher.close();
            } else {
                LOG.warn("unknown getPanelCompletions status: " + String.valueOf(status));
            }
            return true;
        });
        service.addNotificationListener(disposable, (name, message) -> {
            Position position;
            String displayText;
            Range range;
            String text;
            if (!"PanelSolution".equals(name)) {
                return false;
            }
            if (publisher.isClosed()) {
                LOG.warn("publisher already closed");
                return false;
            }
            GetPanelCompletionsResult.Solution parsedResponse = JsonRPC.parseResponse(message, GetPanelCompletionsResult.Solution.class);
            if (!panelId.equals(parsedResponse.getPanelId())) {
                LOG.debug("not my panel id");
                return false;
            }
            String id = parsedResponse.getSolutionId();
            GetCompletionsResult.Completion completion = new GetCompletionsResult.Completion(id, text = parsedResponse.getCompletionText(), range = parsedResponse.getRange(), displayText = parsedResponse.getDisplayText(), position = new Position(request.getLineInfo()), 0);
            AgentCompletion apiChoice = new AgentCompletion(completion);
            CopilotInlayList inlays = CompletionUtil.createEditorCompletion(request, apiChoice, true);
            if (inlays != null && !inlays.isEmpty()) {
                AgentCompletionList fixedInlays = new AgentCompletionList(inlays, apiChoice, request);
                publisher.submit(List.of(new OpenCopilotSolution(parsedResponse.getScore(), parsedResponse.getSolutionId(), fixedInlays)));
            }
            return true;
        });
        return true;
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean isSupportingOnDemandCycling(@NotNull Editor editor) {
        return true;
    }

    @Override
    public void sendShownTelemetry(@NotNull CopilotCompletion completion) {
        String uuid = ((AgentCompletion)completion).getAgentData().getUuid();
        CopilotAgentProcessService.getInstance().executeCommand(new NotifyShownCommand(uuid));
    }

    @Override
    public void sendAcceptedTelemetry(@NotNull CopilotCompletion completion, @NotNull CompletionType completionType, CopilotApplyInlayStrategy strategy, int acceptedLength) {
        String uuid = ((AgentCompletion)completion).getAgentData().getUuid();
        if (strategy == CopilotApplyInlayStrategy.WHOLE) {
            CopilotAgentProcessService.getInstance().executeCommand(new NotifyAcceptedCommand(uuid, null));
        } else {
            CopilotAgentProcessService.getInstance().executeCommand(new NotifyAcceptedCommand(uuid, acceptedLength));
        }
    }

    @Override
    public void sendRejectedTelemetry(@NotNull List<CopilotCompletion> completions) {
        if (completions.isEmpty()) {
            return;
        }
        List<String> uuids = completions.stream().map(i -> ((AgentCompletion)i).getAgentData().getUuid()).collect(Collectors.toList());
        CopilotAgentProcessService.getInstance().executeCommand(new NotifyRejectedCommand(uuids));
    }

    @NotNull
    private Document createDocument(@NotNull EditorRequest request) {
        return new Document(new Position(request.getLineInfo()), !request.isUseTabIndents(), request.getTabWidth(), ((AgentEditorRequest)request).getUri(), request.getDocumentVersion());
    }

    public static class AgentCompletionList
    implements CopilotInlayList {
        private final CopilotInlayList inlays;
        private final AgentCompletion completion;
        @NotNull
        private final EditorRequest request;
        private final String replacementText;

        public AgentCompletionList(@Nullable CopilotInlayList inlays, @NotNull AgentCompletion completion, @NotNull EditorRequest request) {
            this.inlays = inlays;
            this.completion = completion;
            this.request = request;
            this.replacementText = CompletionUtil.dropOverlappingTrailingLines(completion.getAgentData().getText(), request.getDocumentContent(), request.getOffset());
        }

        @Override
        public boolean isEmpty() {
            return this.inlays == null || this.inlays.isEmpty();
        }

        @Override
        @NotNull
        public CopilotCompletion getCopilotCompletion() {
            return this.completion;
        }

        @Override
        @NotNull
        public TextRange getReplacementRange() {
            String text = this.request.getDocumentContent();
            Range range = this.completion.getAgentData().getRange();
            int startOffset = range.getStart().toOffset(text);
            int endOffset = range.getEnd().toOffset(text);
            assert (startOffset >= 0);
            assert (endOffset >= startOffset);
            return TextRange.create((int)startOffset, (int)endOffset);
        }

        @Override
        @NotNull
        public String getReplacementText() {
            return this.replacementText;
        }

        @Override
        @NotNull
        public List<CopilotEditorInlay> getInlays() {
            return this.inlays == null ? Collections.emptyList() : this.inlays.getInlays();
        }

        @Override
        @NotNull
        public Iterator<CopilotEditorInlay> iterator() {
            return this.inlays != null ? this.inlays.iterator() : Collections.emptyIterator();
        }
    }
}

