/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent;

import com.github.copilot.CopilotPlugin;
import com.github.copilot.github.IdeaGitHubAccounts;
import com.github.copilot.github.IdeaGitHubAuthentication;
import com.github.copilot.lang.agent.CopilotAgentCommandLine;
import com.github.copilot.lang.agent.CopilotAgentProcessServiceEx;
import com.github.copilot.lang.agent.commands.CancelRequestNotification;
import com.github.copilot.lang.agent.commands.ConfigurationChangeCommand;
import com.github.copilot.lang.agent.commands.EditorSettings;
import com.github.copilot.lang.agent.commands.ExitCommand;
import com.github.copilot.lang.agent.commands.InitializedCommand;
import com.github.copilot.lang.agent.commands.ShutdownCommand;
import com.github.copilot.lang.agent.commands.SignInWithGitHubTokenCommand;
import com.github.copilot.lang.agent.commands.testing.SetContentExclusionRulesCommand;
import com.github.copilot.lang.agent.lsp.AgentWorkspaceFolders;
import com.github.copilot.lang.agent.lsp.ClientCapabilities;
import com.github.copilot.lang.agent.lsp.CopilotCapabilities;
import com.github.copilot.lang.agent.lsp.InitializeCommand;
import com.github.copilot.lang.agent.lsp.TextDocumentClientCapabilities;
import com.github.copilot.lang.agent.lsp.WorkspaceCapabilities;
import com.github.copilot.lang.agent.lsp.WorkspaceFolder;
import com.github.copilot.lang.agent.lsp.textDocument.TextDocumentSyncClientCapabilities;
import com.github.copilot.lang.agent.rpc.JsonRpcClientResponse;
import com.github.copilot.lang.agent.rpc.JsonRpcCommand;
import com.github.copilot.lang.agent.rpc.JsonRpcMessageHandler;
import com.github.copilot.lang.agent.rpc.JsonRpcNotification;
import com.github.copilot.lang.agent.rpc.JsonRpcNotificationListener;
import com.github.copilot.lang.agent.rpc.JsonRpcRequestListener;
import com.github.copilot.lang.agent.vscodeRpc.AgentProcessHandler;
import com.github.copilot.lang.agent.vscodeRpc.DefaultJsonRpcMessageHandler;
import com.github.copilot.lang.agent.vscodeRpc.VSCodeJsonRpc;
import com.github.copilot.settings.CopilotApplicationSettings;
import com.github.copilot.settings.CopilotApplicationState;
import com.github.copilot.util.CodeCompletionUiTestUtil;
import com.github.copilot.util.LoggerUtil;
import com.github.copilot.util.ProcessUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promises;

abstract class CopilotAgentProcessServiceImpl
implements CopilotAgentProcessServiceEx {
    private static final Logger LOG = Logger.getInstance(CopilotAgentProcessServiceImpl.class);
    private static final String THREAD_NAME = "GitHub Copilot agent";
    private final AtomicInteger requestId = new AtomicInteger();
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final ExecutorService agentExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)"GitHub Copilot agent");
    private final DefaultJsonRpcMessageHandler messageHandler = new DefaultJsonRpcMessageHandler();
    @NotNull
    private final AgentProcessHandler agentProcess;

    CopilotAgentProcessServiceImpl(int restartAttempts) throws ExecutionException {
        this.agentProcess = CopilotAgentProcessServiceImpl.launchAgent(this.messageHandler, restartAttempts);
    }

    abstract void beforeCommand(@NotNull JsonRpcCommand<?> var1);

    abstract void afterCommand(@NotNull JsonRpcCommand<?> var1);

    abstract void beforeNotification(@NotNull JsonRpcNotification var1);

    abstract void beforeResponse(@NotNull JsonRpcClientResponse var1);

    abstract void afterNotification(@NotNull JsonRpcNotification var1);

    abstract void onRestartException(@NotNull Exception var1, @NotNull String var2, @NotNull String var3, @Nullable Integer var4);

    @Override
    public boolean isRunning() {
        return !this.agentProcess.isProcessTerminated() && !this.agentProcess.isProcessTerminating();
    }

    @Override
    @NotNull
    public final <T> CancellablePromise<T> executeCommand(@NotNull JsonRpcCommand<T> command) {
        if (this.isShutdown()) {
            return Promises.rejectedCancellablePromise((String)"agent was shutdown");
        }
        return this.executeCommandUnsafe(command);
    }

    @NotNull
    private final <T> CancellablePromise<T> executeCommandUnsafe(@NotNull JsonRpcCommand<T> command) {
        int nextRequestId = this.requestId.getAndIncrement();
        LOG.debug("Registering result for request ID: " + nextRequestId + ", command: " + command.getCommandName());
        AsyncPromise<T> promise = this.createCommandPromise(command, nextRequestId);
        this.executeCommandWithPromise(promise, command, nextRequestId);
        return promise;
    }

    @Override
    public void executeResponse(@NotNull JsonRpcClientResponse response) {
        if (this.isShutdown()) {
            return;
        }
        String responseName = response.getMethodName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending response:" + responseName);
        }
        this.agentExecutor.submit(() -> {
            try {
                CopilotAgentProcessServiceImpl.updateThreadName("response", responseName);
                this.beforeResponse(response);
                VSCodeJsonRpc.sendResponse(this.agentProcess.getProcessInput(), response);
            }
            catch (Exception e) {
                this.handleAgentExceptionLocked(responseName, e);
            }
            finally {
                CopilotAgentProcessServiceImpl.resetThreadName();
            }
        });
    }

    @Override
    public void addNotificationListener(@NotNull Disposable parentDisposable, @NotNull JsonRpcNotificationListener listener2) {
        if (this.isShutdown()) {
            LOG.debug("addNotificationListener called for shutdown agent");
            return;
        }
        Disposer.tryRegister((Disposable)parentDisposable, () -> this.messageHandler.removeNotificationListener(listener2));
        this.messageHandler.addNotificationListeners(List.of(listener2));
    }

    @Override
    public <I, O> void addRequestListener(@NotNull String lspCommand, @NotNull JsonRpcRequestListener<I, O> listener2) {
        if (this.isShutdown()) {
            LOG.debug("addRequestListener called for shutdown agent");
            return;
        }
        this.messageHandler.addRequestListener(lspCommand, listener2);
    }

    @Override
    public void initialize(@NotNull Collection<JsonRpcNotificationListener> listeners) {
        if (this.isInitialized.compareAndExchange(false, true)) {
            throw new IllegalStateException("agent was already initialized");
        }
        this.messageHandler.addNotificationListeners(listeners);
        try {
            InitializeCommand.NameAndVersion editor = this.getEditorNameAndVersion();
            InitializeCommand.NameAndVersion plugin = new InitializeCommand.NameAndVersion(CopilotPlugin.getPluginName(), CopilotPlugin.getVersion(), CopilotPlugin.getReadableEditorName());
            CopilotCapabilities copilotCapabilities = new CopilotCapabilities(true, true);
            InitializeCommand.InitializationOptions initializationOptions = new InitializeCommand.InitializationOptions(editor, plugin, copilotCapabilities, null);
            TextDocumentSyncClientCapabilities syncCapabilities = new TextDocumentSyncClientCapabilities(true, null, null, null);
            ClientCapabilities clientCapabilities = new ClientCapabilities(new TextDocumentClientCapabilities(syncCapabilities), new WorkspaceCapabilities(true), copilotCapabilities);
            List<WorkspaceFolder> workspaceFolders = this.collectWorkspaceFolders();
            this.executeCommand(new InitializeCommand(clientCapabilities, plugin, initializationOptions, ProcessHandle.current().pid(), workspaceFolders));
            CopilotApplicationState settings = CopilotApplicationSettings.settings();
            EditorSettings agentSettings = EditorSettings.basedOn(settings);
            this.executeNotification(new InitializedCommand());
            this.executeNotification(new ConfigurationChangeCommand(agentSettings));
            if (IdeaGitHubAuthentication.isEnabled()) {
                this.setupNativeAuthentication();
            }
            if (ApplicationManager.getApplication().isUnitTestMode() || this.isIntegrationTestRun()) {
                SetContentExclusionRulesCommand.ContentExclusionRule.Source source = new SetContentExclusionRulesCommand.ContentExclusionRule.Source("test-org", "Organization");
                SetContentExclusionRulesCommand.ContentExclusionRule rule = new SetContentExclusionRulesCommand.ContentExclusionRule(List.of("**/secrets*"), source);
                ArrayList<SetContentExclusionRulesCommand.ContentExclusionRule> rules = new ArrayList<SetContentExclusionRulesCommand.ContentExclusionRule>();
                rules.add(rule);
                this.executeCommand(new SetContentExclusionRulesCommand(rules));
            }
            this.setupMocksForUiTest();
        }
        catch (Exception e) {
            LoggerUtil.errorAndSecureTelemetry(LOG, "error initializing agent", e, new Attachment[0]);
        }
    }

    private void setupMocksForUiTest() {
        if (!this.isIntegrationTestRun()) {
            return;
        }
        this.executeCommand(CodeCompletionUiTestUtil.getMockCommand());
    }

    private void setupNativeAuthentication() {
        IdeaGitHubAccounts ideGhAccounts = new IdeaGitHubAccounts();
        boolean hasNativeAccount = ideGhAccounts.hasNecessaryAccountSetup();
        if (hasNativeAccount) {
            String username = ideGhAccounts.getUsername();
            String token = ideGhAccounts.getToken();
            try {
                this.executeCommand(new SignInWithGitHubTokenCommand(username, token));
            }
            catch (Exception e) {
                LOG.warn("Failed to setup github token", (Throwable)e);
            }
        }
    }

    @Override
    public void startNotify() {
        this.agentProcess.startNotify();
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown.get();
    }

    @Override
    public void shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            throw new IllegalStateException("agent was already shutdown");
        }
        boolean isAlive = !ApplicationManager.getApplication().isDisposed();
        this.executeCommandUnsafe(new ShutdownCommand()).onProcessed(it -> {
            this.messageHandler.shutdown();
            try {
                VSCodeJsonRpc.sendNotification(this.agentProcess.getProcessInput(), new ExitCommand());
                this.agentProcess.getProcessInput().close();
            }
            catch (IOException e) {
                LoggerUtil.errorAndSecureTelemetry(LOG, "error shutting down agent", e, new Attachment[0]);
            }
        });
        this.agentExecutor.shutdown();
        ProcessUtil.waitForProcessTermination(this.agentProcess, Duration.ofSeconds(5L), Duration.ofMillis(100L));
        try {
            if (isAlive) {
                this.agentExecutor.awaitTermination(1L, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            LoggerUtil.errorAndSecureTelemetry(LOG, "error awaiting agent termination", e, new Attachment[0]);
        }
    }

    @Override
    public void flush() {
        if (this.isShutdown()) {
            LOG.debug("flush called for shutdown agent");
            return;
        }
        try {
            this.agentExecutor.submit(EmptyRunnable.INSTANCE).get(15L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException("Error flushing agent executor service", e);
        }
    }

    private List<WorkspaceFolder> collectWorkspaceFolders() {
        return AgentWorkspaceFolders.asWorkspaceFolders(ProjectManager.getInstance().getOpenProjects());
    }

    private InitializeCommand.NameAndVersion getEditorNameAndVersion() {
        if (this.isIntegrationTestRun()) {
            String integratorId = "copilot-ide-team-editor-integration-test";
            return new InitializeCommand.NameAndVersion(integratorId, "0.1", integratorId);
        }
        return new InitializeCommand.NameAndVersion(CopilotPlugin.getEditorName(), CopilotPlugin.getEditorVersion(), CopilotPlugin.getReadableEditorName());
    }

    private boolean isIntegrationTestRun() {
        boolean isIntegrationTestRun = false;
        try {
            isIntegrationTestRun = "true".equals(System.getProperty("copilot.is-integration-test-run"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isIntegrationTestRun;
    }

    private void handleAgentExceptionLocked(@NotNull String commandName, @NotNull Exception e) {
        if (this.isShutdown()) {
            LOG.debug("handleAgentExceptionLocked called for shutdown agent");
            return;
        }
        if (CopilotAgentProcessServiceImpl.isRestartException(e)) {
            this.onRestartException(e, commandName, this.agentProcess.getRecentOutput(), this.agentProcess.getExitCode());
        } else {
            int id = this.requestId.get();
            LOG.warn("Failed to execute JSON-RPC command or notification. Request: " + id + ", command: " + commandName, (Throwable)e);
        }
    }

    private <T> AsyncPromise<T> createCommandPromise(@NotNull JsonRpcCommand<T> command, int nextRequestId) {
        return this.messageHandler.addPendingRequest(nextRequestId, command.getCommandName(), command.getResponseType(), () -> {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Sending cancel notification for request " + nextRequestId + ", command: " + String.valueOf(command));
            }
            this.executeNotification(new CancelRequestNotification(nextRequestId));
        });
    }

    private <T> void executeCommandWithPromise(@NotNull AsyncPromise<T> promise, @NotNull JsonRpcCommand<T> command, int nextRequestId) {
        this.agentExecutor.submit(() -> {
            try {
                CopilotAgentProcessServiceImpl.updateThreadName("command", command.getCommandName());
                this.beforeCommand(command);
                VSCodeJsonRpc.sendCommand(this.agentProcess.getProcessInput(), nextRequestId, command);
                this.afterCommand(command);
            }
            catch (Exception e) {
                this.handleAgentExceptionLocked(command.getCommandName(), e);
                promise.setError(e.getMessage());
            }
            finally {
                CopilotAgentProcessServiceImpl.resetThreadName();
            }
        });
    }

    @Override
    public void executeNotification(@NotNull JsonRpcNotification notification) {
        if (this.isShutdown()) {
            LOG.debug("executeNotification called for shutdown agent");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending notification:" + notification.getCommandName());
        }
        this.agentExecutor.submit(() -> {
            try {
                CopilotAgentProcessServiceImpl.updateThreadName("notification", notification.getCommandName());
                this.beforeNotification(notification);
                VSCodeJsonRpc.sendNotification(this.agentProcess.getProcessInput(), notification);
                this.afterNotification(notification);
            }
            catch (Exception e) {
                this.handleAgentExceptionLocked(notification.getCommandName(), e);
            }
            finally {
                CopilotAgentProcessServiceImpl.resetThreadName();
            }
        });
    }

    private static void updateThreadName(@NotNull String type, @NotNull String name) {
        Thread.currentThread().setName(String.format("%s: %s '%s'", THREAD_NAME, type, name));
    }

    private static void resetThreadName() {
        Thread.currentThread().setName(THREAD_NAME);
    }

    private static boolean isRestartException(@NotNull Exception e) {
        return e instanceof IOException && StringUtil.contains((CharSequence)e.getMessage(), (CharSequence)"Stream closed");
    }

    @NotNull
    private static AgentProcessHandler launchAgent(@NotNull JsonRpcMessageHandler messageHandler, int restartAttempts) throws ExecutionException {
        boolean debugMode = ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal();
        GeneralCommandLine cmdline = CopilotAgentCommandLine.createAgentCommandLine(debugMode, restartAttempts);
        return new AgentProcessHandler(cmdline, messageHandler);
    }
}

