/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent;

import com.github.copilot.CopilotPlugin;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopilotAgentUtil {
    private static final Logger LOG = Logger.getInstance(CopilotAgentUtil.class);

    @Nullable
    public static Path getAgentDirectoryPath() {
        return CopilotAgentUtil.findAssetDirectory("GITHUB_COPILOT_AGENTDIR", "copilot-agent/dist");
    }

    @Nullable
    public static Path getAgentBinaryDirectoryPath() {
        return CopilotAgentUtil.findAssetDirectory("GITHUB_COPILOT_AGENTBINDIR", "copilot-agent/native");
    }

    @Nullable
    private static Path findAssetDirectory(@NotNull String unitTestEnvVar, @NotNull String directoryName) {
        String envValue;
        if (ApplicationManager.getApplication().isUnitTestMode() && (envValue = System.getenv(unitTestEnvVar)) != null) {
            Path envPath = Paths.get(envValue, new String[0]);
            if (!Files.exists(envPath, new LinkOption[0])) {
                LOG.error(unitTestEnvVar + " path doesn't exist: " + String.valueOf(envPath));
                return null;
            }
            return envPath;
        }
        Path basePath = CopilotPlugin.getPluginBasePath();
        Path distPath = basePath.resolve(directoryName);
        if (Files.exists(distPath, new LinkOption[0])) {
            return distPath;
        }
        LOG.error("Unable to locate the Copilot agent dist path in base path: " + String.valueOf(basePath));
        return null;
    }
}

