/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent;

import com.github.copilot.featureflags.CopilotFeatureFlags;
import com.github.copilot.featureflags.CopilotFeatureFlagsService;
import com.github.copilot.github.feature.FeatureFlagManager;
import com.github.copilot.lang.agent.notifications.FeatureFlagsNotification;
import com.github.copilot.lang.agent.rpc.JsonRPC;
import com.github.copilot.lang.agent.rpc.JsonRpcNotificationListener;
import com.google.gson.JsonElement;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

public class FeatureFlagsChangeNotificationListener
implements JsonRpcNotificationListener {
    private static final Logger AGENT_LOG = Logger.getInstance((String)"#copilot");

    @Override
    public boolean handleMessage(@NotNull String name, @NotNull JsonElement message) {
        if (!"featureFlagsNotification".equals(name)) {
            return false;
        }
        FeatureFlagsNotification featureFlags = JsonRPC.parseResponse(message, FeatureFlagsNotification.class);
        AGENT_LOG.debug("FeatureFlags: rt=" + featureFlags.isRt() + ": sn=" + featureFlags.isSn() + ": chat=" + featureFlags.isChat() + ": ic=" + featureFlags.isIc());
        CopilotFeatureFlags flags = new CopilotFeatureFlags(featureFlags.isRt(), featureFlags.isSn(), featureFlags.isChat(), featureFlags.isIc(), featureFlags.isPc());
        FeatureFlagManager.INSTANCE.setFeatureFlags(flags);
        CopilotFeatureFlagsService.notifyApplication(flags);
        return true;
    }
}

