/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent;

import com.github.copilot.CopilotBundle;
import com.github.copilot.github.GitHubService;
import com.github.copilot.github.IdeaGitHubAccounts;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageConstants;
import com.intellij.openapi.ui.MessageDialogBuilder;
import org.jetbrains.annotations.NotNull;

public class InteractiveLoginFlow {
    private final Project project;
    private final GitHubService ghService;
    private final IdeaGitHubAccounts ideGhAccounts;

    public InteractiveLoginFlow(@NotNull Project project, GitHubService ghService, IdeaGitHubAccounts ideGhAccounts) {
        this.project = project;
        this.ghService = ghService;
        this.ideGhAccounts = ideGhAccounts;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AuthFlow pickAuthFlow() {
        this.ghService.refreshStatus();
        boolean hasDeviceAuth = this.ghService.isSignedIn();
        if (!hasDeviceAuth) {
            AuthFlow userFlowChoice = this.askWhichAuthFlowToUse();
            if (userFlowChoice != AuthFlow.NativeIDEToken) return userFlowChoice;
            if (!this.ideGhAccounts.hasNecessaryAccountSetup()) {
                this.showGitHubAuthSettingsModally();
            }
            if (this.ideGhAccounts.hasNecessaryAccountSetup()) return AuthFlow.NativeIDEToken;
            boolean continueWithDevice = this.askToContinueWithoutIDEToken();
            if (!continueWithDevice) {
                return AuthFlow.Cancel;
            }
        }
        if (!this.ideGhAccounts.hasNecessaryAccountSetup() || this.ghService.isSignedIn()) return AuthFlow.DeviceFlow;
        return AuthFlow.NativeIDEToken;
    }

    protected boolean askToContinueWithoutIDEToken() {
        return MessageDialogBuilder.okCancel((String)CopilotBundle.get("copilot.auth.flowDialogTitle"), (String)CopilotBundle.get("copilot.auth.continueWithoutIDE")).ask(this.project);
    }

    protected void showGitHubAuthSettingsModally() {
        ShowSettingsUtil.getInstance().showSettingsDialog(this.project, "settings.github");
    }

    @MessageConstants.YesNoCancelResult
    protected AuthFlow askWhichAuthFlowToUse() {
        String ideFlowText = CopilotBundle.get("copilot.auth.configure");
        if (this.ideGhAccounts.hasNecessaryAccountSetup()) {
            ideFlowText = CopilotBundle.get("copilot.auth.loginViaIDE", this.ideGhAccounts.getUsername());
        }
        int result = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)CopilotBundle.get("copilot.auth.flowDialogTitle"), (String)CopilotBundle.get("copilot.auth.flowDialogQuestion")).yesText(CopilotBundle.get("copilot.auth.flowDialogDeviceFlow"))).noText(ideFlowText)).cancelText(CopilotBundle.get("copilot.auth.flowDialogCancel")).show(this.project);
        return switch (result) {
            case 0 -> AuthFlow.DeviceFlow;
            case 1 -> AuthFlow.NativeIDEToken;
            default -> AuthFlow.Cancel;
        };
    }

    public static enum AuthFlow {
        DeviceFlow,
        NativeIDEToken,
        Cancel;

    }
}

