/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent;

import com.github.copilot.chat.conversation.agent.rpc.notification.ConversationPreconditionsNotificationListener;
import com.github.copilot.fetch.FetchCancelHandler;
import com.github.copilot.fetch.FetchDisconnectAllHandler;
import com.github.copilot.fetch.FetchRequestHandler;
import com.github.copilot.lang.agent.CopilotAgentProcessService;
import com.github.copilot.lang.agent.CopilotAgentProcessServiceEx;
import com.github.copilot.lang.agent.CopilotAgentProcessServiceImpl;
import com.github.copilot.lang.agent.CopilotAgentProcessStatusListener;
import com.github.copilot.lang.agent.FeatureFlagsChangeNotificationListener;
import com.github.copilot.lang.agent.LogMessageNotificationListener;
import com.github.copilot.lang.agent.ShowMessageRequestHandler;
import com.github.copilot.lang.agent.StatusChangeNotificationListener;
import com.github.copilot.lang.agent.UnavailableAgentProcessService;
import com.github.copilot.lang.agent.rpc.JsonRpcClientResponse;
import com.github.copilot.lang.agent.rpc.JsonRpcCommand;
import com.github.copilot.lang.agent.rpc.JsonRpcNotification;
import com.github.copilot.lang.agent.rpc.JsonRpcNotificationListener;
import com.github.copilot.lang.agent.rpc.JsonRpcRequestListener;
import com.github.copilot.status.CopilotStatus;
import com.github.copilot.status.CopilotStatusService;
import com.github.copilot.telemetry.ErrorReportService;
import com.github.copilot.telemetry.TelemetryService;
import com.github.copilot.util.LoggerUtil;
import com.google.gson.JsonElement;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.messages.MessageBus;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;

public class RestartableCopilotAgentProcessService
implements CopilotAgentProcessService,
Disposable {
    private static final Logger LOG = Logger.getInstance(RestartableCopilotAgentProcessService.class);
    @NotNull
    protected final AtomicInteger restartAttempts = new AtomicInteger();
    private final Object lock = new Object();
    @NotNull
    private CopilotAgentProcessServiceEx delegate;

    public RestartableCopilotAgentProcessService() {
        try {
            this.delegate = this.createInitializedDelegate(0);
            this.delegate.startNotify();
        }
        catch (Exception e) {
            this.delegate = new UnavailableAgentProcessService("error in constructor");
            ErrorReportService.getInstance().reportException(e, Collections.emptyMap(), 0);
        }
    }

    @Override
    public boolean isRunning() {
        return this.getDelegate().isRunning();
    }

    @Override
    @NotNull
    public <T> CancellablePromise<T> executeCommand(@NotNull JsonRpcCommand<T> command) {
        return this.getDelegate().executeCommand(command);
    }

    @Override
    public void executeResponse(@NotNull JsonRpcClientResponse response) {
        this.getDelegate().executeResponse(response);
    }

    @Override
    public void executeNotification(@NotNull JsonRpcNotification notification) {
        this.getDelegate().executeNotification(notification);
    }

    @Override
    public void addNotificationListener(@NotNull Disposable parentDisposable, @NotNull JsonRpcNotificationListener listener2) {
        CopilotAgentProcessServiceEx currentDelegate = this.getDelegate();
        BoundJsonRpcNotificationListener boundWrapper = new BoundJsonRpcNotificationListener(currentDelegate, listener2);
        currentDelegate.addNotificationListener(parentDisposable, boundWrapper);
    }

    @Override
    public <I, O> void addRequestListener(@NotNull String lspCommand, final @NotNull JsonRpcRequestListener<I, O> listener2) {
        final CopilotAgentProcessServiceEx currentDelegate = this.getDelegate();
        JsonRpcRequestListener boundWrapper = new JsonRpcRequestListener<I, O>(){

            @Override
            @NotNull
            public Promise<O> handleMessage(@NotNull I request) {
                if (currentDelegate != RestartableCopilotAgentProcessService.this.getDelegate()) {
                    throw new RuntimeException("Agent is shutting down");
                }
                return listener2.handleMessage(request);
            }

            @Override
            public Class<I> getRequestType() {
                return listener2.getRequestType();
            }

            @Override
            public Class<O> getResponseType() {
                return listener2.getResponseType();
            }
        };
        currentDelegate.addRequestListener(lspCommand, boundWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.delegate.shutdown();
            }
            finally {
                this.delegate = new UnavailableAgentProcessService("disposed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    @NotNull
    protected CopilotAgentProcessServiceEx getDelegate() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceRestart() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.delegate.shutdown();
            }
            finally {
                this.setNewDelegateLocked();
            }
        }
    }

    @NotNull
    protected CopilotAgentProcessServiceEx createInitializedDelegate(int restartAttempts) throws Exception {
        BaseDelegateImplementation delegate = new BaseDelegateImplementation(restartAttempts);
        this.initializeDelegate(delegate);
        return delegate;
    }

    protected void initializeDelegate(BaseDelegateImplementation delegate) {
        BoundJsonRpcNotificationListener wrappedStatusListener = new BoundJsonRpcNotificationListener(delegate, new StatusChangeNotificationListener());
        BoundJsonRpcNotificationListener wrappedFeatureFlagsListener = new BoundJsonRpcNotificationListener(delegate, new FeatureFlagsChangeNotificationListener());
        BoundJsonRpcNotificationListener wrappedLogListener = new BoundJsonRpcNotificationListener(delegate, new LogMessageNotificationListener());
        BoundJsonRpcNotificationListener wrappedPreconditionsListener = new BoundJsonRpcNotificationListener(delegate, new ConversationPreconditionsNotificationListener());
        delegate.initialize(List.of(wrappedStatusListener, wrappedFeatureFlagsListener, wrappedLogListener, wrappedPreconditionsListener));
        delegate.addRequestListener("window/showMessageRequest", new ShowMessageRequestHandler());
        delegate.addRequestListener("copilot/fetch", new FetchRequestHandler());
        delegate.addRequestListener("copilot/fetchCancel", new FetchCancelHandler());
        delegate.addRequestListener("copilot/fetchDisconnectAll", new FetchDisconnectAllHandler());
    }

    private void setNewDelegateLocked() {
        int attempts = this.restartAttempts.get();
        try {
            if (attempts >= 10) {
                this.delegate = new UnavailableAgentProcessService("too many restarts");
            } else {
                try {
                    this.delegate = this.createInitializedDelegate(attempts);
                }
                catch (Exception e) {
                    LoggerUtil.errorAndSecureTelemetry(LOG, "error initializing agent", e, new Attachment[0]);
                    this.delegate = new UnavailableAgentProcessService("exception");
                }
            }
        }
        finally {
            CopilotAgentProcessServiceEx current = this.delegate;
            current.startNotify();
            ApplicationManager.getApplication().executeOnPooledThread(() -> RestartableCopilotAgentProcessService.sendRestartNotifications(attempts));
        }
    }

    @RequiresBackgroundThread
    private static void sendRestartNotifications(int attempts) {
        if (attempts < 10) {
            MessageBus bus = ApplicationManager.getApplication().getMessageBus();
            ((CopilotAgentProcessStatusListener)bus.syncPublisher(CopilotAgentProcessStatusListener.TOPIC)).onAgentProcessRestart();
        } else if (attempts == 10) {
            LOG.warn("too many restart attempts");
            TelemetryService.getInstance().track("editor.intellij.tooManyAgentRestarts", Map.of("maxAttempts", String.valueOf(10)));
            CopilotStatusService.notifyApplication(CopilotStatus.AgentBroken);
        } else {
            LOG.debug("too many restart attempts");
        }
    }

    private class BoundJsonRpcNotificationListener
    implements JsonRpcNotificationListener {
        private final CopilotAgentProcessService associatedService;
        private final JsonRpcNotificationListener delegate;

        private BoundJsonRpcNotificationListener(@NotNull CopilotAgentProcessService associatedService, JsonRpcNotificationListener delegate) {
            this.delegate = delegate;
            this.associatedService = associatedService;
        }

        @Override
        public boolean handleMessage(@NotNull String name, @NotNull JsonElement message) {
            if (this.associatedService != RestartableCopilotAgentProcessService.this.getDelegate()) {
                LOG.debug("JSON-RPC listener called for shutdown agent: " + name + ", message: " + String.valueOf(message));
                return false;
            }
            return this.delegate.handleMessage(name, message);
        }
    }

    protected class BaseDelegateImplementation
    extends CopilotAgentProcessServiceImpl {
        public BaseDelegateImplementation(int restartAttempts) throws ExecutionException {
            super(restartAttempts);
        }

        @Override
        void beforeCommand(@NotNull JsonRpcCommand<?> command) {
        }

        @Override
        void afterCommand(@NotNull JsonRpcCommand<?> command) {
            if (this.isShutdown()) {
                return;
            }
            RestartableCopilotAgentProcessService.this.restartAttempts.set(0);
        }

        @Override
        void beforeNotification(@NotNull JsonRpcNotification notification) {
        }

        @Override
        void afterNotification(@NotNull JsonRpcNotification notification) {
            if (this.isShutdown()) {
                return;
            }
            RestartableCopilotAgentProcessService.this.restartAttempts.set(0);
        }

        @Override
        void beforeResponse(@NotNull JsonRpcClientResponse response) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void onRestartException(@NotNull Exception exception, @NotNull String commandName, @NotNull String recentOutput, @Nullable Integer exitCode) {
            if (this.isShutdown()) {
                return;
            }
            RestartableCopilotAgentProcessService.this.restartAttempts.incrementAndGet();
            try {
                RestartableCopilotAgentProcessService.this.forceRestart();
            }
            catch (Throwable throwable) {
                Attachment[] attachments = new Attachment[]{new Attachment("agent-output.txt", recentOutput)};
                LoggerUtil.errorAndSecureTelemetry(LOG, "Copilot Agent terminated unexpectedly. Exit code: " + exitCode, new RuntimeException("Copilot Agent terminated unexpectedly. Exit code: " + exitCode, exception), attachments);
                throw throwable;
            }
            Attachment[] attachments = new Attachment[]{new Attachment("agent-output.txt", recentOutput)};
            LoggerUtil.errorAndSecureTelemetry(LOG, "Copilot Agent terminated unexpectedly. Exit code: " + exitCode, new RuntimeException("Copilot Agent terminated unexpectedly. Exit code: " + exitCode, exception), attachments);
        }
    }
}

