/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotNotifications;
import com.github.copilot.lang.agent.notifications.MessageActionItem;
import com.github.copilot.lang.agent.notifications.WindowLogMessageRequest;
import com.github.copilot.lang.agent.rpc.JsonRpcRequestListener;
import com.github.copilot.util.ApplicationUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class ShowMessageRequestHandler
implements JsonRpcRequestListener<WindowLogMessageRequest, MessageActionItem> {
    private static final int LOG_MESSAGE_TYPE = 4;
    private static final Map<Integer, NotificationType> messageTypeToNotificationType = new Int2ObjectOpenHashMap(Map.of(1, NotificationType.ERROR, 2, NotificationType.WARNING, 3, NotificationType.INFORMATION));

    @Override
    @NotNull
    public Promise<MessageActionItem> handleMessage(@NotNull WindowLogMessageRequest request) {
        if (request.getMessageType() == 4) {
            return Promises.resolvedPromise();
        }
        Notification notification = CopilotNotifications.createFullContentNotification(CopilotBundle.get("requestsDisabledNotification.title"), request.getMessage(), ShowMessageRequestHandler.determineType(request), true);
        AsyncPromise promise = new AsyncPromise();
        List<MessageActionItem> actions = request.getActions();
        if (actions == null || actions.isEmpty()) {
            promise.setResult(null);
        } else {
            actions.forEach(ShowMessageRequestHandler.addAction((AsyncPromise<MessageActionItem>)promise, notification));
        }
        notification.whenExpired(() -> ((AsyncPromise)promise).cancel());
        notification.notify(ApplicationUtil.findCurrentProject());
        return promise;
    }

    @NotNull
    private static Consumer<MessageActionItem> addAction(AsyncPromise<MessageActionItem> promise, Notification notification) {
        return actionItem -> notification.addAction((AnAction)NotificationAction.createSimple((String)actionItem.getTitle(), () -> promise.setResult(actionItem)));
    }

    private static NotificationType determineType(WindowLogMessageRequest request) {
        return messageTypeToNotificationType.getOrDefault(request.getMessageType(), NotificationType.INFORMATION);
    }

    @Override
    public Class<WindowLogMessageRequest> getRequestType() {
        return WindowLogMessageRequest.class;
    }

    @Override
    public Class<MessageActionItem> getResponseType() {
        return MessageActionItem.class;
    }
}

